/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.RtableData;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;

public class RtableIntData
extends RtableData {
    int[] theData;
    int[] theDimensions;
    String theName;

    public boolean equals(Object o) {
        if (!(o instanceof RtableIntData)) {
            return false;
        }
        RtableIntData d = (RtableIntData)o;
        if (this.theData != d.theData && this.theData != null) {
            if (this.theData.length != d.theData.length) {
                return false;
            }
            int i = 0;
            while (i < this.theData.length) {
                if (this.theData[i] != d.theData[i]) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    @Override
    public void readDotm(WmiByteArrayInputStream bs, int[] size, int[] dims) throws IOException {
        super.readDotm(bs, size, dims);
        this.theData = new int[size[0]];
        this.theDimensions = dims;
        int i = 0;
        while (i < size[0]) {
            this.theData[i] = DagBuilder.parseShortInteger(bs);
            ++i;
        }
    }

    @Override
    public StringBuffer writeDotm() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.theData.length) {
            DagBuilder.writeShortInteger(sb, this.theData[i]);
            ++i;
        }
        return sb;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("[ ");
        int i = 0;
        while (i < this.theData.length) {
            sb.append(this.theData[i]);
            sb.append(" ");
            ++i;
        }
        sb.append("] ");
        return sb.toString();
    }

    @Override
    public int[] getDimensions() {
        return this.theDimensions;
    }

    @Override
    public int getIntegerAt(int[] positions) {
        return this.theData[0];
    }

    @Override
    public double getDoubleAt(int[] positions) {
        return this.theData[0];
    }

    public double getDoubleAt(int x, int y) {
        return this.theData[0];
    }

    @Override
    public float getFloatAt(int[] positions) {
        return this.theData[0];
    }

    @Override
    public Dag getDagAt(int[] positons) {
        return null;
    }

    @Override
    public Dag getDagAt(int x, int y) {
        return null;
    }

    @Override
    public int getIntegerAt(int pos) {
        return this.theData[pos];
    }

    @Override
    public double getDoubleAt(int pos) {
        return this.theData[pos];
    }

    @Override
    public float getFloatAt(int pos) {
        return this.theData[pos];
    }

    @Override
    public Dag getDagAt(int pos) {
        return DagUtil.createIntDag(this.theData[pos]);
    }

    @Override
    public String getNamedArray() {
        return this.theName;
    }
}

