/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.AbstractDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagConstants;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.FunctionDagFactory;
import com.maplesoft.client.dag.PowerDagFactory;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;

public class SeriesDagFactory
extends AbstractDagFactory {
    private static final int WHERE_NAME_OFFSET = 0;
    private static final int WHERE_NAME_SIGN_OFFSET = 1;
    private static final int WHERE_VALUE_OFFSET = 2;
    private static final int WHERE_VALUE_SIGN_OFFSET = 3;
    private static final int WHERE_VALUE_SHIFT = 2;

    @Override
    public Dag readDotm(WmiByteArrayInputStream is) throws IOException {
        return this.readDotm(is, 15, DagBuilder.parseShortInteger(is));
    }

    @Override
    public void writeDotm(StringBuffer sb, Dag dag) {
        this.writeDotm(sb, dag, 15, true);
    }

    @Override
    public StringBuffer toMathML(Dag dag) {
        return new StringBuffer();
    }

    private static boolean isOrderFunction(Dag dag) {
        Dag name;
        String value;
        int length;
        boolean orderFunction = false;
        if (DagUtil.isFunction(dag) && (length = dag.getLength()) > 0 && (value = (name = dag.getChild(0)).getData()) != null && value.equals("O")) {
            orderFunction = true;
        }
        return orderFunction;
    }

    @Override
    public void linePrint(StringBuffer result, Dag dag, WmiLPrintOptions options) {
        Dag sum = SeriesDagFactory.createSum(dag);
        result.append("series(");
        if (sum != null) {
            Dag order;
            DagBuilder.linePrint(result, sum, options);
            int length = dag.getLength();
            Dag base = dag.getChild(0);
            Dag where = SeriesDagFactory.createWhereDag(base);
            Dag dag2 = order = SeriesDagFactory.hasOrderFunction(dag) ? dag.getChild(length - 1) : null;
            if (order != null) {
                result.append("+O(");
                Dag[] powerArgs = new Dag[]{base, order};
                Dag powerDag = Dag.createDag(13, powerArgs, null, false);
                DagBuilder.linePrint(result, powerDag, options);
                result.append(")");
            }
            result.append(",");
            DagBuilder.linePrint(result, where, options);
            if (order != null) {
                result.append(",");
                DagBuilder.linePrint(result, order, options);
            }
        }
        result.append(")");
    }

    @Override
    public LayoutBox createLayout(LayoutFormatter f, Dag dag) {
        Dag sum;
        LayoutBox box = null;
        Dag normalized = sum = SeriesDagFactory.createSum(dag);
        if (SeriesDagFactory.hasOrderFunction(dag)) {
            Dag base = dag.getChild(0);
            Dag[] args = new Dag[]{DagBuilder.normalize(sum), base, dag.getChild(dag.getLength() - 1)};
            normalized = FunctionDagFactory.createFunctionDag("_SERIES", args);
        }
        box = DagBuilder.createLayout(f, normalized);
        return box;
    }

    public static Dag createWhereDag(Dag base) {
        Dag where = null;
        int type = base.getType();
        if (type == 16) {
            Dag name = base.getChild(0);
            base.getChild(1);
            Dag[] args = new Dag[2];
            args[0] = name;
            if (base.getLength() == 4) {
                Dag value = base.getChild(2);
                Dag valueSign = base.getChild(3);
                if (valueSign.equals(DagConstants.ONE)) {
                    Dag[] sumArgs = new Dag[2];
                    sumArgs[1] = DagConstants.MINUS_ONE;
                    sumArgs[0] = value;
                    args[1] = Dag.createDag(16, sumArgs, null, false);
                } else {
                    args[1] = value;
                }
            } else {
                int length = base.getLength() - 2;
                Dag[] valueArgs = new Dag[length];
                int i = 0;
                while (i < length) {
                    valueArgs[i] = base.getChild(i + 2);
                    ++i;
                }
                Dag value = Dag.createDag(16, valueArgs, null, false);
                valueArgs = new Dag[]{value, DagConstants.MINUS_ONE};
                args[1] = Dag.createDag(16, valueArgs, null, false);
            }
            where = Dag.createDag(20, args, null, false);
        } else {
            where = base;
        }
        return where;
    }

    public static boolean hasOrderFunction(Dag source) {
        int length;
        boolean found = false;
        if (source != null && (length = source.getLength()) > 0) {
            found = length > 1 ? SeriesDagFactory.isOrderFunction(source.getChild(length - 2)) : false;
        }
        return found;
    }

    public static Dag createSum(Dag source) {
        Dag result = null;
        try {
            Dag base = DagBuilder.normalize(source.getChild(0));
            int length = source.getLength();
            if (SeriesDagFactory.hasOrderFunction(source)) {
                length -= 2;
            }
            Dag[] terms = new Dag[length - 1];
            Dag sum = Dag.createDag(16, terms, null, false);
            int i = 1;
            while (i < length) {
                SeriesDagFactory.fillTerm(source, terms, base, i);
                i += 2;
            }
            result = DagBuilder.normalize(sum);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private static void fillTerm(Dag seriesDag, Dag[] sumTerms, Dag base, int i) {
        Dag scale = seriesDag.getChild(i);
        Dag power = seriesDag.getChild(i + 1);
        if (DagUtil.isZero(power)) {
            SeriesDagFactory.fillZeroPowerTerm(scale, sumTerms, i);
        } else if (DagUtil.isNumeric(scale)) {
            if (DagUtil.isOne(power)) {
                sumTerms[i - 1] = base;
                sumTerms[i] = scale;
            } else {
                sumTerms[i - 1] = PowerDagFactory.create(base, power);
                sumTerms[i] = scale;
            }
        } else {
            Dag[] prodKids = new Dag[4];
            if (scale.getType() == 16 && scale.getLength() == 2) {
                prodKids[0] = scale.getChild(0);
                prodKids[1] = DagConstants.ONE;
                sumTerms[i] = scale.getChild(1);
            } else {
                prodKids[0] = scale;
                prodKids[1] = DagConstants.ONE;
                sumTerms[i] = DagConstants.ONE;
            }
            prodKids[2] = base;
            prodKids[3] = power;
            Dag prod = Dag.createDag(14, prodKids, null, false);
            sumTerms[i - 1] = DagBuilder.normalize(prod);
        }
    }

    private static void fillZeroPowerTerm(Dag scale, Dag[] sumTerms, int i) {
        if (DagUtil.isNumeric(scale)) {
            if (DagUtil.isNegative(scale)) {
                scale = DagUtil.negate(scale);
                sumTerms[i] = DagConstants.MINUS_ONE;
            } else {
                sumTerms[i] = DagConstants.ONE;
            }
            sumTerms[i - 1] = scale;
        } else if (scale.getType() == 16 && scale.getLength() == 2) {
            sumTerms[i - 1] = scale.getChild(0);
            sumTerms[i] = scale.getChild(1);
        } else {
            sumTerms[i - 1] = DagBuilder.normalize(scale);
            sumTerms[i] = DagConstants.ONE;
        }
    }

    @Override
    public int getPrecedence() {
        return 10;
    }
}

