/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.dag.AbstractCommandDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.WmiLPrintOptions;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.template.ProcTemplate;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;

public class TryDagFactory
extends AbstractCommandDagFactory {
    @Override
    public Dag readDotm(WmiByteArrayInputStream is) throws IOException {
        return this.readDotm(is, 49, DagBuilder.parseShortInteger(is));
    }

    @Override
    public void writeDotm(StringBuffer sb, Dag dag) {
        this.writeDotm(sb, dag, 49, true);
    }

    @Override
    public void linePrint(StringBuffer result, Dag dag, WmiLPrintOptions options) {
        int length = dag.getLength();
        result.append("try ");
        DagBuilder.linePrint(result, dag.getChild(0), options);
        result.append(" ");
        if (length > 1) {
            int i = 2;
            while (i < length) {
                Dag child = dag.getChild(i - 1);
                result.append("catch");
                if (!DagUtil.isNull(child)) {
                    result.append(" ");
                    DagBuilder.linePrint(result, child, options);
                }
                result.append(": ");
                child = dag.getChild(i);
                DagBuilder.linePrint(result, child, options);
                result.append(" ");
                i += 2;
            }
            if ((length & 1) == 0) {
                result.append("finally ");
                DagBuilder.linePrint(result, dag.getChild(length - 1), options);
                result.append(" ");
            }
        }
        result.append("end try");
    }

    @Override
    public LayoutBox createLayout(LayoutFormatter f, Dag dag) {
        int length = dag.getLength();
        InlineLayoutBox b = new InlineLayoutBox(6 + length + length / 2);
        InlineLayoutBox row = new InlineLayoutBox(1);
        row.addChild(NotationLayoutBox.createNotationBox(f, 58));
        b.addChild(row);
        b.addChild(new ProcTemplate.ProcDelimiter(f));
        b.addChild(ProcTemplate.layoutStatement(f, dag.getChild(0)));
        b.addChild(new ProcTemplate.ProcDelimiter(f));
        if (length > 1) {
            int i = 2;
            while (i < length) {
                row = new InlineLayoutBox(2);
                row.addChild(NotationLayoutBox.createNotationBox(f, 59));
                Dag child = dag.getChild(i - 1);
                if (!DagUtil.isNull(child)) {
                    row.addChild(NotationLayoutBox.createCustomBox(f, " "));
                    row.addChild(DagBuilder.createLayout(f, child));
                }
                row.addChild(NotationLayoutBox.createNotationBox(f, 60));
                ProcTemplate.addNeededDelimiter(f, b);
                b.addChild(row);
                b.addChild(new ProcTemplate.ProcDelimiter(f));
                b.addChild(ProcTemplate.layoutStatement(f, dag.getChild(i)));
                i += 2;
            }
            if ((length & 1) == 0) {
                row = new InlineLayoutBox(1);
                row.addChild(NotationLayoutBox.createNotationBox(f, 61));
                b.addChild(row);
                b.addChild(new ProcTemplate.ProcDelimiter(f));
                b.addChild(ProcTemplate.layoutStatement(f, dag.getChild(length - 1)));
            }
        }
        ProcTemplate.addNeededDelimiter(f, b);
        b.addChild(NotationLayoutBox.createNotationBox(f, longForm ? 72 : 37));
        b.addChild(ProcTemplate.createSemiColon(f));
        b.addChild(new ProcTemplate.ProcDelimiter(f));
        b.setLineBreaker(LineBreakerFactory.newLineBreaker(16));
        return b;
    }
}

