/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag;

import com.maplesoft.client.MapleNumbers;
import com.maplesoft.client.dag.AbstractDagFactory;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagConstants;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.FunctionDagFactory;
import com.maplesoft.util.WmiByteArrayInputStream;
import java.io.IOException;

public class ZppolyDagFactory
extends AbstractDagFactory {
    private static final int ZPPOLY_INDET = 0;
    private static final int ZPPOLY_MOD = 1;
    private static final int ZPPOLY_COEFF1 = 2;
    private static final int ZPPOLY_DEGREE = 1;
    private static final int MAX_HARDWARE_ZPPOLY = 46327;
    private static final int MAX_HARDWARE_DIGITS = 5;

    @Override
    public Dag readDotm(WmiByteArrayInputStream is) throws IOException {
        return this.readDotm(is, 17, DagBuilder.parseShortInteger(is));
    }

    @Override
    protected Dag readDotm(WmiByteArrayInputStream bs, int type, int length) {
        int cnt = DagBuilder.dagCountPlus();
        Dag[] myDag = new Dag[--length];
        Dag dag = Dag.createDag(type, myDag, null, false);
        try {
            int i = 0;
            while (i < 2) {
                myDag[i] = DagBuilder.create(bs);
                ++i;
            }
            if (ZppolyDagFactory.isHardwareZPPOLY(dag) && ZppolyDagFactory.isOneVarZPPOLY(dag)) {
                i = 2;
                while (i < length) {
                    int value = DagBuilder.parseShortInteger(bs);
                    myDag[i] = Dag.createDag(2, null, Integer.toString(value), false);
                    ++i;
                }
            } else {
                i = 2;
                while (i < length) {
                    myDag[i] = DagBuilder.create(bs);
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        DagBuilder.putDag(dag, cnt);
        return dag;
    }

    @Override
    public void writeDotm(StringBuffer sb, Dag dag) {
        int type = dag.getType();
        int backrefPosition = ZppolyDagFactory.isABackref(dag, type);
        if (backrefPosition > 0) {
            this.writeBackref(sb, backrefPosition);
            return;
        }
        char ch = (char)(MapleNumbers.dotMOutputTable[type] + 33 - 1);
        sb.append(ch);
        int length = dag.getLength();
        if (length > 0) {
            DagBuilder.writeShortInteger(sb, length + 1);
            int i = 0;
            while (i < 2) {
                DagBuilder.writeDotm(sb, dag.getChild(i));
                ++i;
            }
            if (ZppolyDagFactory.isHardwareZPPOLY(dag) && ZppolyDagFactory.isOneVarZPPOLY(dag)) {
                i = 2;
                while (i < length) {
                    int value = Integer.parseInt(dag.getChild(i).getData());
                    DagBuilder.writeShortInteger(sb, value);
                    ++i;
                }
            } else {
                i = 2;
                while (i < length) {
                    DagBuilder.writeDotm(sb, dag.getChild(i));
                    ++i;
                }
            }
        } else {
            DagBuilder.writeShortInteger(sb, 1);
        }
    }

    public static boolean isHardwareZPPOLY(Dag dag) {
        String strValue;
        Dag mod;
        int length;
        boolean hardware = false;
        if (dag.getType() == 17 && (length = dag.getLength()) > 1 && (mod = dag.getChild(1)) != null && mod.getType() == 2 && (strValue = mod.getData()).length() <= 5) {
            hardware = Integer.parseInt(strValue) < 46327;
        }
        return hardware;
    }

    public static boolean isOneVarZPPOLY(Dag dag) {
        int length;
        boolean oneVar = false;
        if (dag.getType() == 17 && (length = dag.getLength()) > 0) {
            Dag indet = dag.getChild(0);
            oneVar = indet != null && indet.getType() != 29;
        }
        return oneVar;
    }

    @Override
    public StringBuffer toMathML(Dag dag) {
        return new StringBuffer();
    }

    @Override
    public Dag normalize(Dag dag) {
        Dag modFunc;
        Dag sumDag = null;
        Dag normalized = null;
        if (dag != null && !dag.isNormalized()) {
            sumDag = this.convertToSum(dag);
        }
        this.invertSumDag(sumDag);
        Dag var = dag.getChild(0);
        Dag[] convertInArgs = null;
        if (var.getType() == 29) {
            int length = var.getLength();
            convertInArgs = new Dag[1 + length];
            int i = 0;
            while (i < length) {
                convertInArgs[i + 1] = var.getChild(i);
                ++i;
            }
        } else {
            convertInArgs = new Dag[2];
            convertInArgs[1] = var;
        }
        convertInArgs[0] = DagBuilder.normalize(sumDag);
        Dag convertInFunc = FunctionDagFactory.createFunctionDag("ConvertIn", convertInArgs);
        Dag[] modpArgs = new Dag[]{convertInFunc, this.getDegree(dag)};
        String name = convertInArgs.length == 2 ? "modp1" : "modp2";
        normalized = modFunc = FunctionDagFactory.createFunctionDag(name, modpArgs);
        dag.setNormalized(normalized);
        return normalized;
    }

    private Dag getDegree(Dag dag) {
        return dag.getChild(1);
    }

    private void invertSumDag(Dag dag) {
        int i = 0;
        int n = 0;
        int length = dag.getLength();
        if (dag.getType() == 16 && length > 2) {
            Dag temp = null;
            i = 0;
            n = length - 2;
            while (i < n) {
                temp = dag.getChild(i);
                dag.setChild(i, dag.getChild(n));
                dag.setChild(n, temp);
                temp = dag.getChild(i + 1);
                dag.setChild(i + 1, dag.getChild(n + 1));
                dag.setChild(n + 1, temp);
                i += 2;
                n -= 2;
            }
        }
    }

    private Dag convertToSum(Dag dag) {
        Dag sum = null;
        int i = 0;
        int terms = 0;
        int n = 0;
        int degree = 0;
        Dag[] normKids = null;
        int length = dag.getLength();
        if (length > 0) {
            Dag var = dag.getChild(0);
            if (length <= 2) {
                sum = DagConstants.ZERO;
            } else {
                if (var.getType() == 29 && var.getLength() > 0) {
                    var = var.getChild(0);
                }
                terms = 0;
                i = 2;
                while (i < length) {
                    if (!DagUtil.isZero(dag.getChild(i))) {
                        ++terms;
                    }
                    ++i;
                }
                normKids = new Dag[2 * terms];
                sum = Dag.createDag(16, normKids, null, false);
                n = 0;
                i = 2;
                while (i < length) {
                    Dag coeff = DagBuilder.normalize(dag.getChild(i));
                    Dag scale = DagConstants.ONE;
                    boolean checkCoefficient = true;
                    while (checkCoefficient) {
                        if (coeff.getType() == 18) {
                            String name = coeff.getChild(0).getData();
                            if (name.equals("modp1") || name.equals("ConvertIn")) {
                                coeff = coeff.getChild(1).getChild(0);
                                continue;
                            }
                            checkCoefficient = false;
                            continue;
                        }
                        checkCoefficient = false;
                    }
                    if (coeff.getType() == 16 && coeff.getLength() == 2) {
                        coeff = coeff.getChild(0);
                    }
                    if (!DagUtil.isZero(coeff)) {
                        degree = i - 2;
                        if (degree == 0) {
                            normKids[n++] = coeff;
                            normKids[n++] = scale;
                        } else {
                            Dag[] prodKids = null;
                            int k = 0;
                            if (DagUtil.isOne(coeff) && DagUtil.isOne(scale)) {
                                prodKids = new Dag[2];
                            } else {
                                prodKids = new Dag[4];
                                prodKids[k++] = coeff;
                                prodKids[k++] = DagConstants.ONE;
                            }
                            prodKids[k++] = var;
                            prodKids[k++] = Dag.createDag(2, null, Integer.toString(degree), false);
                            Dag term = Dag.createDag(14, prodKids, null, false);
                            normKids[n++] = term;
                            normKids[n++] = DagConstants.ONE;
                        }
                    }
                    ++i;
                }
            }
            if (sum == null) {
                sum = DagConstants.ZERO;
            } else if (sum != DagConstants.ZERO) {
                if (n < normKids.length) {
                    if (n > 0) {
                        Dag[] subset = new Dag[n];
                        i = 0;
                        while (i < n) {
                            subset[i] = normKids[i];
                            ++i;
                        }
                        sum = Dag.createDag(16, subset, null, false);
                    } else {
                        sum = DagConstants.ZERO;
                    }
                }
                sum = DagBuilder.normalize(sum);
            }
        }
        return sum;
    }
}

