/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag.util;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.RtableDag;
import com.maplesoft.client.dag.RtableData;

public class RTableElementAccessor {
    private static final int INDEX_NOT_IN_STORAGE = -1;

    private RTableElementAccessor() {
    }

    public static Dag getTableElement(RtableDag rt, Dag index) {
        Dag dag = null;
        dag = index.getLength() == 1 ? RTableElementAccessor.getTableElement1D(rt, index) : RTableElementAccessor.getTableElement2D(rt, index);
        return dag;
    }

    private static Dag getTableElement1D(RtableDag rt, Dag index) {
        RtableData data = rt.getTableData();
        int i = DagUtil.parseInt(index.getChild(0));
        return data.getDagAt(i - 1);
    }

    private static Dag getTableElement2D(RtableDag rt, Dag index) {
        RtableData data = rt.getTableData();
        int i = DagUtil.parseInt(index.getChild(0));
        int j = DagUtil.parseInt(index.getChild(1));
        int m = rt.getRangeUpperBound(0);
        int n = rt.getRangeUpperBound(1);
        int dataIndex = 0;
        int order = rt.getOrder();
        if (order == 0) {
            switch (rt.getStorage()) {
                case 5: {
                    dataIndex = i > j ? -1 : (j > m ? (2 * j - 1 - m) * m / 2 + i - 1 : j * (j - 1) / 2 + i - 1);
                    break;
                }
                case 8: {
                    dataIndex = i < j ? -1 : (j - 1) * (2 * m + 2 - j) / 2 + i - j;
                    break;
                }
                case 6: {
                    dataIndex = i >= j ? -1 : (j > m ? (2 * j - 3 - m) * m / 2 + i - 1 : (j - 1) * (j - 2) / 2 + i - 1);
                    break;
                }
                case 9: {
                    dataIndex = i <= j ? -1 : (j - 1) * (2 * m - j) / 2 + i - j - 1;
                    break;
                }
                case 7: {
                    dataIndex = i > j + 1 ? -1 : (j > m ? (2 * j + 1 - m) * m / 2 + i - 2 : j * (j + 1) / 2 + i - 2);
                    break;
                }
                case 10: {
                    dataIndex = j > i + 1 ? -1 : (i >= j ? (j - 1) * (2 * m + 4 - j) / 2 + i - j : (j - 1) * (2 * m + 2 - j) / 2 + 2 * i - j);
                    break;
                }
                case 4: {
                    dataIndex = (j - 1) * m + (i - 1);
                    break;
                }
                case 1: {
                    dataIndex = -1;
                    break;
                }
                case 11: {
                    dataIndex = 0;
                    break;
                }
                case 2: {
                    dataIndex = i != j ? -1 : i - 1;
                    break;
                }
                case 3: {
                    int b1 = rt.getBandLowerBound();
                    int b2 = rt.getBandUpperBound();
                    dataIndex = i - j < -b2 || i - j > b1 ? -1 : (j - 1) * (b2 + b1 + 1) + i - j + b2;
                    break;
                }
                default: {
                    dataIndex = -1;
                    break;
                }
            }
        } else if (order == 1) {
            switch (rt.getStorage()) {
                case 5: {
                    dataIndex = i > j ? -1 : (i - 1) * (2 * n + 2 - i) / 2 + j - i;
                    break;
                }
                case 8: {
                    dataIndex = i < j ? -1 : (i > n ? (2 * i - 2 + 1 - n) * n / 2 + j - 1 : (i - 1) * i / 2 + j - 1);
                    break;
                }
                case 6: {
                    dataIndex = i >= j ? -1 : (i - 1) * (2 * n - i) / 2 + j - i - 1;
                    break;
                }
                case 9: {
                    dataIndex = i <= j ? -1 : (i > n ? (2 * i - 3 - n) * n / 2 + j - 1 : (i - 1) * (i - 2) / 2 + j - 1);
                    break;
                }
                case 7: {
                    dataIndex = i > j + 1 ? -1 : (j >= i ? (i - 1) * (2 * n + 4 - i) / 2 + j - i : (i - 1) * (2 * n + 2 - i) / 2 + 2 * j - i);
                    break;
                }
                case 10: {
                    dataIndex = j > i + 1 ? -1 : (i > n ? (2 * i + 1 - n) * n / 2 + j - 2 : i * (i + 1) / 2 + j - 2);
                    break;
                }
                case 4: {
                    dataIndex = (i - 1) * n + (j - 1);
                    break;
                }
                case 1: {
                    dataIndex = -1;
                    break;
                }
                case 11: {
                    dataIndex = 0;
                    break;
                }
                case 2: {
                    dataIndex = i != j ? -1 : i - 1;
                    break;
                }
                case 3: {
                    int b1 = rt.getBandLowerBound();
                    int b2 = rt.getBandUpperBound();
                    dataIndex = i - j < -b2 || i - j > b1 ? -1 : (i - j + b2) * n + j - 1;
                    break;
                }
                default: {
                    dataIndex = -1;
                }
            }
        }
        return dataIndex != -1 ? data.getDagAt(dataIndex) : null;
    }
}

