/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag.util;

import com.maplesoft.client.dag.RtableDag;

public class RTableFlagConverter {
    private static final String[] RTABLE_DATATYPE_LABELS = new String[]{"anything", "anything", "integer[1]", "integer[2]", "integer[4]", "integer[8]", "float[8]", "complex[8]", "float[32]"};
    private static final String[] RTABLE_STORAGE_LABELS = new String[]{"sparse", "empty", "diagonal", "band", "rectangular", "triangular[upper]", "triangular[upper,strict]", "Hessenberg[upper]", "triangular[lower]", "triangular[lower,strict]", "Hessenberg[lower]", "scalar"};
    private static final String[] RTABLE_ORDER_LABELS = new String[]{"Fortran_order", "C_order"};

    private RTableFlagConverter() {
    }

    public static String getDataTypeLabel(int dataType) {
        return RTABLE_DATATYPE_LABELS[dataType];
    }

    public static String getStorageLabel(int storageType, RtableDag rt) {
        String label = RTABLE_STORAGE_LABELS[storageType];
        if (storageType == 3) {
            label = String.valueOf(label) + "[";
            label = String.valueOf(label) + rt.getBandLowerBound();
            label = String.valueOf(label) + ",";
            label = String.valueOf(label) + rt.getBandUpperBound();
            label = String.valueOf(label) + "]";
        }
        return label;
    }

    public static String getOrderLabel(int orderType) {
        return RTABLE_ORDER_LABELS[orderType];
    }
}

