/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag.util;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.util.WmiDagVisitor;

public class WmiDagWalkNode {
    private Dag dag;
    private int depth;
    private WmiDagVisitor visitor;
    private WmiDagWalkNode parent;

    public WmiDagWalkNode(Dag theDag, WmiDagVisitor theVisitor) {
        this(theDag, theVisitor, null);
    }

    public WmiDagWalkNode(Dag theDag, WmiDagVisitor theVisitor, WmiDagWalkNode parentNode) {
        this.dag = theDag;
        this.visitor = theVisitor;
        if (parentNode != null) {
            this.depth = parentNode.depth + 1;
            this.parent = parentNode;
        } else {
            this.depth = 0;
        }
    }

    public Dag getDag() {
        return this.dag;
    }

    public WmiDagWalkNode getParentNode() {
        return this.parent;
    }

    public int getDepth() {
        return this.depth;
    }

    public String toString() {
        StringBuffer buffy = new StringBuffer();
        buffy.append("WalkNode(");
        buffy.append(System.identityHashCode(this));
        buffy.append(" ) - [");
        buffy.append(DagBuilder.CLASS_NAMES[this.dag.getType()]);
        buffy.append("] ");
        String data = this.dag.getData();
        if (data != null && !data.equals("null")) {
            buffy.append("{\"");
            buffy.append(data);
            buffy.append("\"} ");
        }
        buffy.append("(");
        int len = this.dag.getLength();
        buffy.append(len);
        if (len == 1) {
            buffy.append(" child) ");
        } else {
            buffy.append(" children) ");
        }
        return buffy.toString();
    }

    public WmiDagVisitor getVisitor() {
        return this.visitor;
    }
}

