/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.dag.util;

import com.maplesoft.client.dag.BranchDag;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.LeafDag;
import com.maplesoft.client.dag.util.WmiAbstractDagVisitor;
import com.maplesoft.client.dag.util.WmiDagVisitOperation;
import com.maplesoft.client.dag.util.WmiDagWalkNode;
import com.maplesoft.client.dag.util.WmiDagWalkerContext;

class WmiSummaryDagVisitor
extends WmiAbstractDagVisitor {
    WmiSummaryDagVisitor() {
    }

    @Override
    public void enqueue(WmiDagWalkNode parentNode, WmiDagWalkerContext context) {
        Dag dag = parentNode.getDag();
        if (dag.getType() == 29 && dag.getLength() == 1) {
            super.enqueue(parentNode, context);
        }
    }

    @Override
    protected void initializeDagVisitOps() {
        this.setDagVisitOp(0, new WmiSummaryDefaultOperation());
        this.setupDagOp(1, new WmiSummaryNegativeIntegerOperation(), "Negative Integer");
        this.setupDagOp(2, new WmiSummaryPositiveIntegerOperation(), "Positive Integer");
        this.setDagTypeName(3, "Rational");
        this.setDagTypeName(4, "Float Number");
        this.setDagTypeName(5, "Hardware Float");
        this.setDagTypeName(6, "Complex Value");
        this.setupDagOp(7, new WmiSummaryStringOperation(), "String");
        this.setupDagOp(8, new WmiSummaryIdentifierOperation(), "Identifier");
        this.setDagTypeName(9, "Member");
        this.setDagTypeName(10, "Table Reference");
        this.setDagTypeName(11, "Type Specification");
        this.setDagTypeName(12, "Name Concatenation");
        this.setDagTypeName(13, "Power");
        this.setupDagOp(14, new WmiSummaryProductSumOperation(), "Product");
        this.setupDagOp(15, new WmiSummarySeriesOperation(), "Series");
        this.setupDagOp(16, new WmiSummaryProductSumOperation(), "Sum");
        this.setDagTypeName(17, "Polynomial");
        this.setDagTypeName(18, "Function Call");
        this.setDagTypeName(19, "Unevaluated Expression");
        this.setDagTypeName(20, "Equality");
        this.setDagTypeName(21, "Inequality");
        this.setDagTypeName(22, "Less Than or Equal");
        this.setDagTypeName(23, "Less Than");
        this.setDagTypeName(24, "Logical AND");
        this.setDagTypeName(25, "Logical NOT");
        this.setDagTypeName(26, "Logical OR");
        this.setDagTypeName(27, "Logical Xor");
        this.setDagTypeName(28, "Inplication");
        this.setupDagOp(29, new WmiSummaryExpSeqOperation(), "Expression Sequence");
        this.setupDagOp(30, new WmiSummaryListSetOperation(), "List");
        this.setDagTypeName(31, "Local Variable");
        this.setDagTypeName(32, "Procedure Parameter");
        this.setDagTypeName(33, "Lexically Scoped Variable");
        this.setDagTypeName(34, "Procedure Definition");
        this.setDagTypeName(35, "Range");
        this.setupDagOp(36, new WmiSummaryListSetOperation(), "Set");
        this.setDagTypeName(37, "Table");
        this.setDagTypeName(38, "Rectangular Table");
        this.setDagTypeName(39, "Module Definition");
        this.setDagTypeName(40, "Module Instance");
        this.setDagTypeName(41, "Assignment");
        this.setDagTypeName(42, "For/While Loop");
        this.setDagTypeName(43, "If Statement");
        this.setDagTypeName(44, "Read Statement");
        this.setDagTypeName(45, "Save Statement");
        this.setDagTypeName(46, "Statement Sequence");
        this.setDagTypeName(47, "Stop Maple");
        this.setDagTypeName(48, "Error Statement");
        this.setDagTypeName(49, "Try Statement");
        this.setDagTypeName(50, "Return Statement");
        this.setDagTypeName(51, "Break Statement");
        this.setDagTypeName(52, "Next Statement");
        this.setDagTypeName(53, "Use Statement");
        this.setDagTypeName(54, "Binary Object");
        this.setDagTypeName(55, "Hash Table");
        this.setDagTypeName(56, "Back Reference");
        this.setDagTypeName(57, "Garbage");
        this.setDagTypeName(58, "Foreign Data");
        this.setDagTypeName(59, "Control Structure");
        this.setDagTypeName(60, "Debug");
    }

    @Override
    public Object createStartingResultObject() {
        return new StringBuffer();
    }

    private void setupDagOp(int type, WmiDagVisitOperation op, String name) {
        this.setDagVisitOp(type, op);
        this.setDagTypeName(type, name);
    }

    private class WmiSummaryDefaultOperation
    extends WmiSummaryOperation {
        private WmiSummaryDefaultOperation() {
        }

        @Override
        protected String getSummaryString(WmiDagWalkNode walkNode) {
            return WmiSummaryDagVisitor.this.getDagTypeName(walkNode);
        }
    }

    private class WmiSummaryExpSeqOperation
    extends WmiSummaryOperation {
        private WmiSummaryExpSeqOperation() {
        }

        @Override
        protected String getSummaryString(WmiDagWalkNode walkNode) {
            Dag dag = walkNode.getDag();
            return String.valueOf(WmiSummaryDagVisitor.this.getDagTypeName(dag)) + " with " + dag.getLength() + " elements";
        }

        @Override
        public void performOperation(WmiDagWalkNode walkNode, WmiDagWalkerContext context) {
            Dag dag = walkNode.getDag();
            if (dag.getLength() > 1) {
                super.performOperation(walkNode, context);
            }
        }
    }

    private class WmiSummaryIdentifierOperation
    extends WmiSummaryOperation {
        private WmiSummaryIdentifierOperation() {
        }

        @Override
        protected String getSummaryString(WmiDagWalkNode walkNode) {
            Dag dag = walkNode.getDag();
            if (dag instanceof LeafDag && dag.getData().length() <= 15) {
                return dag.getData();
            }
            return WmiSummaryDagVisitor.this.getDagTypeName(dag);
        }
    }

    private class WmiSummaryListSetOperation
    extends WmiSummaryOperation {
        private WmiSummaryListSetOperation() {
        }

        @Override
        protected String getSummaryString(WmiDagWalkNode walkNode) {
            Dag dag = walkNode.getDag();
            if (dag instanceof BranchDag && dag.getLength() > 1) {
                Dag child = dag.getChild(0);
                return String.valueOf(WmiSummaryDagVisitor.this.getDagTypeName(dag)) + " with " + dag.getLength() + " elements";
            }
            return WmiSummaryDagVisitor.this.getDagTypeName(dag);
        }
    }

    private class WmiSummaryNegativeIntegerOperation
    extends WmiSummaryOperation {
        private WmiSummaryNegativeIntegerOperation() {
        }

        @Override
        protected String getSummaryString(WmiDagWalkNode walkNode) {
            Dag dag = walkNode.getDag();
            if (dag instanceof LeafDag && dag.getData().length() < 15) {
                return "-" + dag.getData();
            }
            return WmiSummaryDagVisitor.this.getDagTypeName(dag);
        }
    }

    private static abstract class WmiSummaryOperation
    implements WmiDagVisitOperation {
        private WmiSummaryOperation() {
        }

        private void appendResults(Object data, WmiDagWalkerContext context) {
            if (!(context.getResult() instanceof StringBuffer)) {
                context.setResult(new StringBuffer());
            }
            StringBuffer buff = (StringBuffer)context.getResult();
            buff.append(data);
        }

        protected abstract String getSummaryString(WmiDagWalkNode var1);

        @Override
        public void performOperation(WmiDagWalkNode walkNode, WmiDagWalkerContext context) {
            this.appendResults(this.getSummaryString(walkNode), context);
        }
    }

    private class WmiSummaryPositiveIntegerOperation
    extends WmiSummaryOperation {
        private WmiSummaryPositiveIntegerOperation() {
        }

        @Override
        protected String getSummaryString(WmiDagWalkNode walkNode) {
            Dag dag = walkNode.getDag();
            if (dag instanceof LeafDag && dag.getData().length() <= 15) {
                return dag.getData();
            }
            return WmiSummaryDagVisitor.this.getDagTypeName(dag);
        }
    }

    private class WmiSummaryProductSumOperation
    extends WmiSummaryOperation {
        private WmiSummaryProductSumOperation() {
        }

        @Override
        protected String getSummaryString(WmiDagWalkNode walkNode) {
            Dag dag = walkNode.getDag();
            if (dag instanceof BranchDag && dag.getLength() > 1) {
                int terms = dag.getLength() / 2;
                return String.valueOf(WmiSummaryDagVisitor.this.getDagTypeName(dag)) + " with " + terms + " terms";
            }
            return WmiSummaryDagVisitor.this.getDagTypeName(dag);
        }
    }

    private class WmiSummarySeriesOperation
    extends WmiSummaryOperation {
        private WmiSummarySeriesOperation() {
        }

        @Override
        protected String getSummaryString(WmiDagWalkNode walkNode) {
            Dag dag = walkNode.getDag();
            if (dag instanceof BranchDag && dag.getLength() > 1) {
                Dag orderDag = dag.getChild(dag.getLength() - 1);
                String order = orderDag.getData();
                return String.valueOf(WmiSummaryDagVisitor.this.getDagTypeName(dag)) + " of order " + order;
            }
            return WmiSummaryDagVisitor.this.getDagTypeName(dag);
        }
    }

    private class WmiSummaryStringOperation
    extends WmiSummaryOperation {
        private WmiSummaryStringOperation() {
        }

        @Override
        protected String getSummaryString(WmiDagWalkNode walkNode) {
            Dag dag = walkNode.getDag();
            if (dag instanceof LeafDag && dag.getData().length() <= 13) {
                return "\"" + dag.getData() + "\"";
            }
            return WmiSummaryDagVisitor.this.getDagTypeName(dag);
        }
    }
}

