/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.kernelresult;

import com.maplesoft.client.KernelEvent;
import com.maplesoft.client.KernelListener;
import com.maplesoft.client.KernelUtil;
import java.io.InputStream;

public abstract class AbstractKernelResult {
    int typeID;

    protected AbstractKernelResult(int resultTypeID) {
        this.typeID = resultTypeID;
    }

    public KernelEvent create(char[] reply, boolean isDotm, KernelListener listener) {
        return new KernelEvent(this.typeID, reply, isDotm, listener);
    }

    public KernelEvent create(String reply, boolean isDotm, KernelListener listener) {
        return new KernelEvent(this.typeID, reply, isDotm, listener);
    }

    public abstract KernelEvent readResults(InputStream var1, KernelListener var2);

    protected KernelEvent readTextResults(InputStream is, KernelListener listener, boolean readLength) {
        KernelEvent event = null;
        try {
            int length = -1;
            if (readLength) {
                length = this.readLength(is);
            }
            if (length != 0) {
                char[] text = KernelUtil.readText(is);
                event = this.create(text, false, listener);
            } else {
                event = this.create("", false, listener);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return event;
    }

    public KernelEvent readDotm(InputStream is, KernelListener listener) {
        return this.readDotm(is, listener, false, null);
    }

    public KernelEvent readDotm(InputStream is, KernelListener listener, boolean readLength) {
        return this.readDotm(is, listener, readLength, null);
    }

    protected KernelEvent readDotm(InputStream is, KernelListener listener, String streamName) {
        return this.readDotm(is, listener, false, streamName);
    }

    protected KernelEvent readDotm(InputStream is, KernelListener listener, boolean readLength, String streamName) {
        KernelEvent event = null;
        int length = 1;
        try {
            if (readLength) {
                length = this.readLength(is);
            }
            char[] text = KernelUtil.readText(is);
            int i = 1;
            while (i < length) {
                KernelUtil.readText(is);
                ++i;
            }
            event = this.create(text, true, listener);
            event.setStreamName(streamName);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return event;
    }

    private int readLength(InputStream is) throws Exception {
        String strLength = new String(KernelUtil.readText(is));
        int length = Integer.parseInt(strLength.substring(0, strLength.length() - 1));
        return length;
    }

    protected KernelEvent readNull(KernelListener listener) {
        KernelEvent event = null;
        event = this.create("", false, listener);
        return event;
    }

    protected boolean fireEvent(KernelListener listener, KernelEvent e) {
        return listener.processText(e);
    }

    protected boolean processEvent(KernelListener listener, KernelEvent e) {
        boolean processed = false;
        if (listener != null) {
            while (!(processed = this.fireEvent(listener, e))) {
                if ((listener = listener.getParentListener()) == null) break;
            }
        }
        return processed;
    }
}

