/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.kernelresult;

import com.maplesoft.client.KernelCommunicationError;
import com.maplesoft.client.KernelConnection;
import com.maplesoft.client.KernelEvent;
import com.maplesoft.client.KernelListener;
import com.maplesoft.client.dag.DotMParseError;
import com.maplesoft.client.kernelresult.AbstractKernelResult;
import com.maplesoft.client.kernelresult.KernelErrorResult;

public class KernelResultsDescriptor {
    static String[] kernelResultsClasses = new String[]{"", "KernelErrorResult", "KernelStatusResult", "KernelPlotResult", "KernelRealMathResult", "KernelReadlineResult", "KernelRedirectResult", "KernelCallbackResult", "KernelQueryInterruptResult", "KernelStreamResult", "KernelTextResult", "KernelResultResult", "KernelNoneResult", "KernelPlot3DResult", "KernelHelpResult", "KernelPrintResult", "KernelStartResult", "KernelWarnResult", "KernelLogoResult", "KernelDoneResult", "KernelCharResult", "KernelInterruptResult", "KernelIniErrorResult", "KernelIniWarnResult"};
    private static AbstractKernelResult[] kernelResults = new AbstractKernelResult[kernelResultsClasses.length];
    static int resultCount;
    public static final String KERNEL_ERROR_RESULT_NOT_FOUND = "An unknown Maple Callback was received from the kernel. Type index: ";

    private static void readClass(int i) {
        try {
            String s = "com.maplesoft.client.kernelresult." + kernelResultsClasses[i];
            Class<?> c = Class.forName(s);
            KernelResultsDescriptor.kernelResults[i] = (AbstractKernelResult)c.newInstance();
        }
        catch (Exception ie) {
            System.err.println("can't create " + kernelResultsClasses[i]);
            ie.printStackTrace();
        }
    }

    protected static AbstractKernelResult getKernelResult(int index) {
        if (kernelResults[index] == null) {
            KernelResultsDescriptor.readClass(index);
        }
        return kernelResults[index];
    }

    public static KernelEvent createKernelEvent(KernelConnection connection, int type, KernelListener listener) {
        KernelEvent event = null;
        try {
            if (type <= -1 || type >= kernelResults.length) {
                throw new KernelCommunicationError(KERNEL_ERROR_RESULT_NOT_FOUND + type);
            }
            event = KernelResultsDescriptor.getKernelResult(type).readResults(connection.getClientInputStream(), listener);
            event.buildDAG();
        }
        catch (DotMParseError dpe) {
            event = KernelErrorResult.create(dpe.getMessage(), listener);
        }
        event.setKernelConnection(connection);
        return event;
    }

    public static boolean processEvent(int type, KernelListener listener, KernelEvent e) {
        return KernelResultsDescriptor.getKernelResult(type).processEvent(listener, e);
    }
}

