/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagRenderContext;
import com.maplesoft.client.prettyprinter.DefaultLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutAnchor;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.PostLayoutJob;
import com.maplesoft.client.prettyprinter.PostLayoutJobQueue;
import com.maplesoft.client.prettyprinter.SubexpressionLabelLayoutBox;

public abstract class AbstractFormatter
implements LayoutFormatter {
    private int procedureCount = 0;
    private boolean isOperatorProc = false;
    private int superscriptCount = 0;
    private boolean funcName = false;
    protected int displayPrecision = -2;
    protected PostLayoutJobQueue postLayoutQueue = new PostLayoutJobQueue();
    protected DagRenderContext renderContext = null;
    protected static DagRenderContext defaultRenderContext = null;
    protected static DagRenderContext activeRenderContext = null;
    private static int[] contextFactories = new int[]{2, 6, 42, 4, 8, 34, 16};

    public static void invalidateContext() {
        activeRenderContext = null;
    }

    public static void setDefaultContext(DagRenderContext context) {
        defaultRenderContext = context;
    }

    @Override
    public void setContext(DagRenderContext context) {
        this.renderContext = context;
    }

    @Override
    public DagRenderContext getContext() {
        return this.renderContext != null ? this.renderContext : defaultRenderContext;
    }

    public boolean updateContext() {
        boolean update = false;
        if (this.renderContext == null) {
            this.renderContext = defaultRenderContext;
            update = true;
        }
        if (this.renderContext != null && this.renderContext != activeRenderContext) {
            activeRenderContext = this.renderContext;
            int i = 0;
            while (i < contextFactories.length) {
                DagBuilder.updateContext(contextFactories[i], this.renderContext);
                ++i;
            }
            update = true;
        }
        return update;
    }

    @Override
    public double getBearingMultiplier() {
        return 1.0;
    }

    @Override
    public void incProcCount() {
        ++this.procedureCount;
    }

    @Override
    public void decProcCount() {
        --this.procedureCount;
    }

    @Override
    public boolean isInProc() {
        return this.procedureCount > 0;
    }

    @Override
    public int getProcCount() {
        return this.procedureCount;
    }

    @Override
    public void incSuperscriptCount() {
        ++this.superscriptCount;
    }

    @Override
    public void decSuperscriptCount() {
        --this.superscriptCount;
    }

    @Override
    public boolean isInSuperscript() {
        return this.superscriptCount > 0;
    }

    @Override
    public boolean isInOperatorProc() {
        return this.isOperatorProc;
    }

    @Override
    public void setInOperatorProc(boolean b) {
        this.isOperatorProc = b;
    }

    @Override
    public void setDisplayPrecision(int displayPrecision) {
        this.displayPrecision = displayPrecision;
    }

    @Override
    public NotationLayoutBox createNotationBox(int type) {
        return new NotationLayoutBox(type);
    }

    @Override
    public boolean isFunctionName() {
        return this.funcName;
    }

    @Override
    public void setIsFunctionName(boolean funcName) {
        this.funcName = funcName;
    }

    @Override
    public LayoutBox format(Dag dag, String styleName, double breakWidth) {
        Dag normalized;
        if (dag.getType() == 29 && dag.getLength() == 1) {
            dag = dag.getChild(0);
        }
        normalized = (normalized = DagBuilder.normalize(dag)) == null ? dag : normalized;
        LayoutBox layout = DagBuilder.createNewLayoutBox(this, normalized);
        layout.applyLayout();
        return layout;
    }

    @Override
    public void addPostLayoutJob(Object identifier, PostLayoutJob job) {
        this.postLayoutQueue.addJob(identifier, job);
    }

    @Override
    public boolean containsJobForIdentifier(Object jobID) {
        return this.postLayoutQueue.containsJobForIdentifier(jobID);
    }

    @Override
    public PostLayoutJobQueue getPostLayoutJobQueue() {
        return this.postLayoutQueue;
    }

    @Override
    public double getSafeBreakWidth() {
        return this.getBreakWidth() - (double)this.getColumnSeparator();
    }

    public static class AssumptionLabelJob
    implements PostLayoutJob {
        private LayoutBox labelBox;

        public AssumptionLabelJob(LayoutFormatter formatter, String variable) {
            this.labelBox = variable.endsWith("~") ? NotationLayoutBox.createCustomBox(formatter, variable.substring(0, variable.length() - 1)) : NotationLayoutBox.createCustomBox(formatter, variable);
        }

        public LayoutBox getVariable() {
            return this.labelBox;
        }
    }

    public static class SubexpressionLabelJob
    implements PostLayoutJob {
        private LayoutBox legendItem;
        private SubexpressionLabelLayoutBox subexpressionBox;

        public SubexpressionLabelJob(LayoutFormatter formatter, SubexpressionLabelLayoutBox subexpr) {
            this.subexpressionBox = subexpr;
            this.buildLegendItem(formatter, subexpr);
        }

        public SubexpressionLabelLayoutBox getSubexpressionBox() {
            return this.subexpressionBox;
        }

        public LayoutBox getLegendItem() {
            return this.legendItem;
        }

        private void buildLegendItem(LayoutFormatter formatter, SubexpressionLabelLayoutBox subexpr) {
            this.legendItem = new DefaultLayoutBox();
            this.legendItem.addChild(NotationLayoutBox.createCustomBox(formatter, subexpr.getLabel()));
            this.legendItem.addChild(NotationLayoutBox.createNotationBox(formatter, 17));
            this.legendItem.addChild(subexpr.getLabelTarget());
            LayoutAnchor.anchorLeftToRight(this.legendItem, 0, 2);
            this.legendItem.applyLayout();
        }
    }
}

