/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter;

import com.maplesoft.client.prettyprinter.AbstractBranchLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutAnchor;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutPoint;
import java.util.ArrayList;
import java.util.Iterator;

public class DefaultLayoutBox
extends AbstractBranchLayoutBox {
    protected ArrayList layoutAnchors = new ArrayList();

    public DefaultLayoutBox() {
        this.name = "";
        this.children = new LayoutBox[0];
    }

    public DefaultLayoutBox(String name) {
        this();
        this.name = name;
    }

    public DefaultLayoutBox(int expectedChildren) {
        this.name = "";
        this.children = new LayoutBox[expectedChildren + 1];
    }

    public DefaultLayoutBox(String name, int expectedChildren) {
        this(expectedChildren);
        this.name = name;
    }

    protected LayoutBox getReferenceForBaseline() {
        return this.getChild(0);
    }

    @Override
    public void computeSize() {
        Iterator iChildren = this.getChildren();
        double xleft = 0.0;
        double xright = 0.0;
        double ybottom = 0.0;
        double ytop = 0.0;
        while (iChildren.hasNext()) {
            LayoutBox b = (LayoutBox)iChildren.next();
            if (b.getXorig() - b.getLeftSideBearing() < xleft) {
                xleft = b.getXorig() - b.getLeftSideBearing();
            }
            if (b.getYorig() < ybottom) {
                ybottom = b.getYorig();
            }
            if (b.getXorig() + b.getWidth() + b.getRightSideBearing() > xright) {
                xright = b.getXorig() + b.getWidth() + b.getRightSideBearing();
            }
            if (!(b.getYorig() + b.getHeight() > ytop)) continue;
            ytop = b.getYorig() + b.getHeight();
        }
        LayoutBox reference = this.getReferenceForBaseline();
        if (reference != null) {
            this.baseline = reference.getYorig() + reference.getBaseline();
        }
        if (xleft != 0.0 || ybottom != 0.0) {
            iChildren = this.getChildren();
            LayoutPoint offset = new LayoutPoint(-xleft, -ybottom);
            while (iChildren.hasNext()) {
                LayoutBox b = (LayoutBox)iChildren.next();
                b.translateOrigin(offset);
            }
            this.baseline -= ybottom;
            xright -= xleft;
            ytop -= ybottom;
            ybottom = 0.0;
            xleft = 0.0;
        }
        this.setSize(xright - xleft, ytop - ybottom);
        this.setOrigin(xleft, ybottom);
        this.validLayout = true;
    }

    @Override
    public Iterator getAnchors() {
        return this.layoutAnchors.iterator();
    }

    @Override
    public void addLayoutAnchor(LayoutAnchor a) {
        this.layoutAnchors.add(a);
    }

    @Override
    public void applyLayout() {
        if (!this.isLayoutValid()) {
            this.setOrigin(0.0, 0.0);
            if (this.hasChildren()) {
                int i = 0;
                while (i < this.numChildren()) {
                    LayoutBox child = this.getChild(i);
                    if (child.hasChildren() && !child.isLayoutValid()) {
                        child.applyLayout();
                    }
                    ++i;
                }
                this.getChild(0).setOrigin(0.0, 0.0);
                for (LayoutAnchor connection : this.layoutAnchors) {
                    connection.apply(this);
                }
                this.computeSize();
            }
        }
    }
}

