/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter;

import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutVector;
import java.util.ArrayList;

public class LayoutAnchor {
    public static final int ORIGIN = 1;
    public static final int BASELINE = 2;
    public static final int ADJUSTED_ORIGIN = 3;
    public static final int PARTIALLY_ADJUSTED_ORIGIN = 4;
    public static final LayoutAnchor INLINE_01 = new LayoutAnchor(0, LayoutVector.EAST, 1, LayoutVector.WEST, 2);
    public static final LayoutAnchor INLINE_12 = new LayoutAnchor(1, LayoutVector.EAST, 2, LayoutVector.WEST, 2);
    public static final LayoutAnchor INLINE_23 = new LayoutAnchor(2, LayoutVector.EAST, 3, LayoutVector.WEST, 2);
    public static final LayoutAnchor INLINE_LOW_01 = new LayoutAnchor(0, LayoutVector.SOUTHEAST, 1, LayoutVector.SOUTHWEST, 2);
    public static final LayoutAnchor OVER_01 = new LayoutAnchor(0, LayoutVector.SOUTH, 1, LayoutVector.NORTH, 4);
    public static final LayoutAnchor OVER_02 = new LayoutAnchor(0, LayoutVector.SOUTH, 2, LayoutVector.NORTH, 4);
    public static final LayoutAnchor UNDER_01 = new LayoutAnchor(0, LayoutVector.NORTH, 1, LayoutVector.SOUTH, 4);
    public static final LayoutAnchor UNDER_02 = new LayoutAnchor(0, LayoutVector.NORTH, 2, LayoutVector.SOUTH, 4);
    public static final LayoutAnchor RIGHTOF_01 = new LayoutAnchor(0, LayoutVector.WEST, 1, LayoutVector.EAST);
    public static final LayoutAnchor RIGHTOF_03 = new LayoutAnchor(0, LayoutVector.WEST, 3, LayoutVector.EAST);
    public static final LayoutAnchor RIGHTOF_12 = new LayoutAnchor(1, LayoutVector.WEST, 2, LayoutVector.EAST);
    public static final LayoutAnchor RIGHTOF_31 = new LayoutAnchor(3, LayoutVector.WEST, 1, LayoutVector.EAST);
    public static final LayoutAnchor LEFTOF_02 = new LayoutAnchor(0, LayoutVector.EAST, 2, LayoutVector.WEST);
    public static final LayoutAnchor LEFTOF_01 = new LayoutAnchor(0, LayoutVector.EAST, 1, LayoutVector.WEST);
    public static final LayoutAnchor LEFTOF_12 = new LayoutAnchor(1, LayoutVector.EAST, 2, LayoutVector.WEST);
    public static final LayoutAnchor SUPERSCRIPT_10 = new LayoutAnchor(0, LayoutVector.NORTHEAST, 1, LayoutVector.SOUTHWEST, 3);
    public static final LayoutAnchor SUPERSCRIPT_20 = new LayoutAnchor(0, LayoutVector.NORTHEAST, 2, LayoutVector.SOUTHWEST, 3);
    public static final LayoutAnchor SUPERSCRIPT_32 = new LayoutAnchor(2, LayoutVector.NORTHEAST, 3, LayoutVector.SOUTHWEST, 3);
    public static final LayoutAnchor SUBSCRIPT_10 = new LayoutAnchor(0, LayoutVector.SOUTHEAST, 1, LayoutVector.NORTHWEST, 3);
    public static final LayoutAnchor TOPLEFT_01 = new LayoutAnchor(0, LayoutVector.NORTHEAST, 1, LayoutVector.NORTHWEST);
    public static final LayoutAnchor BOTTOMRIGHT_21 = new LayoutAnchor(1, LayoutVector.SOUTHEAST, 2, LayoutVector.SOUTHWEST);
    private static final String category = "prettyprinter.LayoutAnchor";
    private static ArrayList anchorPool = new ArrayList();
    private static ArrayList topBottomAnchorPool = new ArrayList();
    protected LayoutVector pt1;
    protected LayoutVector pt2;
    protected int sibling1;
    protected int sibling2;
    protected int reference;

    static {
        anchorPool.add(INLINE_01);
        anchorPool.add(INLINE_12);
        anchorPool.add(INLINE_23);
    }

    public LayoutAnchor(int i1, LayoutVector p1, int i2, LayoutVector p2) {
        this.pt1 = p1;
        this.pt2 = p2;
        this.sibling1 = i1;
        this.sibling2 = i2;
        this.reference = 1;
    }

    public LayoutAnchor(int i1, LayoutVector p1, int i2, LayoutVector p2, int style) {
        this.pt1 = p1;
        this.pt2 = p2;
        this.sibling1 = i1;
        this.sibling2 = i2;
        this.reference = style;
    }

    public static LayoutAnchor createTopToBottomAnchor(int firstIndex) {
        LayoutAnchor a = null;
        if (firstIndex < topBottomAnchorPool.size()) {
            a = (LayoutAnchor)topBottomAnchorPool.get(firstIndex);
        } else {
            a = new LayoutAnchor(firstIndex, LayoutVector.SOUTHWEST, firstIndex + 1, LayoutVector.NORTHWEST);
            topBottomAnchorPool.add(a);
        }
        return a;
    }

    public static LayoutAnchor createLeftToRightAnchor(int firstIndex) {
        LayoutAnchor a = null;
        if (firstIndex < anchorPool.size()) {
            a = (LayoutAnchor)anchorPool.get(firstIndex);
        } else {
            a = new LayoutAnchor(firstIndex, LayoutVector.EAST, firstIndex + 1, LayoutVector.WEST, 2);
            anchorPool.add(a);
        }
        return a;
    }

    public static void anchorLeftToRight(LayoutBox target, int from, int to) {
        if (from >= to || to > target.numChildren()) {
            throw new IndexOutOfBoundsException("Problem creating left to right anchors from " + from + " to " + to + " for a box with " + target.numChildren() + " children.");
        }
        int i = from;
        while (i < to) {
            target.addLayoutAnchor(LayoutAnchor.createLeftToRightAnchor(i));
            ++i;
        }
    }

    public String toString() {
        return "Sibling : " + this.sibling1 + " " + this.pt1.toString() + "Relative: " + this.sibling2 + " " + this.pt2.toString();
    }

    public LayoutVector getFirstVector() {
        return this.pt1;
    }

    public LayoutVector getSecondVector() {
        return this.pt2;
    }

    public int getFirstSibling() {
        return this.sibling1;
    }

    public int getSecondSibling() {
        return this.sibling2;
    }

    public void apply(LayoutBox box) {
        LayoutBox child = box.getChild(this.getFirstSibling());
        LayoutBox sibling = box.getChild(this.getSecondSibling());
        LayoutVector first = this.getFirstVector();
        LayoutVector second = this.getSecondVector();
        double x = 0.0;
        double y = 0.0;
        double dy = 0.0;
        x = child.getXorig() + first.getWidth() * child.getWidth() - second.getWidth() * sibling.getWidth();
        switch (this.reference) {
            case 1: {
                y = child.getYorig() + first.getHeight() * child.getHeight() - second.getHeight() * sibling.getHeight();
                break;
            }
            case 2: {
                y = child.getYorig() + child.getBaseline() - sibling.getBaseline();
                break;
            }
            case 3: {
                dy = child.getYorig() - child.getAdjustedYorig();
                y = child.getAdjustedYorig() + first.getHeight() * child.getAdjustedHeight() - second.getHeight() * (sibling.getAdjustedHeight() - dy);
                break;
            }
            case 4: {
                dy = child.getYorig() - child.getAdjustedYorig();
                y = child.getAdjustedYorig() + first.getHeight() * child.getHeight() - second.getHeight() * (sibling.getAdjustedHeight() - dy);
            }
        }
        sibling.setOrigin(x, y);
    }
}

