/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter;

import com.maplesoft.client.prettyprinter.AbstractBranchLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutAnchor;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import java.util.Iterator;

public class LayoutSwitchBox
extends AbstractBranchLayoutBox {
    private LayoutFormatter formatter;
    private LayoutBox reference;
    private LayoutBox main;
    private LayoutBox alternate;
    private LayoutBox active;
    private boolean switchLock = false;

    public LayoutSwitchBox(LayoutFormatter formatter, LayoutBox main, LayoutBox alternate, LayoutBox reference) {
        this.formatter = formatter;
        this.main = main;
        this.alternate = alternate;
        this.reference = reference;
        this.active = null;
    }

    @Override
    public void addLayoutAnchor(LayoutAnchor a) {
    }

    @Override
    public void applyLayout() {
        this.getChildBox();
    }

    @Override
    public void invalidateAll() {
        this.main.invalidateAll();
        this.alternate.invalidateAll();
        this.validate(false);
        this.switchLock = false;
    }

    @Override
    public void computeSize() {
        this.getChildBox();
    }

    @Override
    public void setSize(double w, double h) {
    }

    @Override
    public double getWidth() {
        LayoutBox child = this.getChildBox();
        return child.getWidth();
    }

    @Override
    public double getHeight() {
        LayoutBox child = this.getChildBox();
        return child.getHeight();
    }

    @Override
    public double getBaseline() {
        LayoutBox child = this.getChildBox();
        return child.getBaseline();
    }

    @Override
    public void setBaseline(double base) {
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public int numChildren() {
        return 1;
    }

    @Override
    public LayoutBox getChild(int index) {
        return this.getChildBox();
    }

    @Override
    public double getAdjustedYorig() {
        return this.getYorig();
    }

    public LayoutBox getChildBox() {
        LayoutBox child = this.active;
        if (!this.switchLock) {
            if (!this.reference.isLayoutValid()) {
                this.reference.applyLayout();
            }
            if (this.active != (child = this.reference.getWidth() > this.formatter.getBreakWidth() - (double)this.formatter.getColumnSeparator() ? this.alternate : this.main)) {
                if (super.numChildren() > 0) {
                    this.removeChild(0);
                }
                this.addChild(child);
                if (!child.isLayoutValid()) {
                    child.applyLayout();
                }
                this.setSize(child.getWidth(), child.getHeight());
                this.setBaseline(child.getBaseline());
                this.active = child;
            }
            this.switchLock = true;
            this.validate(true);
        }
        return child;
    }

    @Override
    public Iterator getAnchors() {
        return null;
    }

    @Override
    public SelectionData getSelectionData() {
        return null;
    }

    @Override
    public void setSelectionData(SelectionData selectionData) {
    }

    @Override
    public String toString() {
        return "switch-box";
    }
}

