/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter;

import com.maplesoft.client.prettyprinter.BoxUtils;
import com.maplesoft.client.prettyprinter.LayoutBox;
import java.util.Iterator;
import java.util.List;

public abstract class LeafBoxIterator
implements Iterator {
    private LayoutBox currentBox;
    private LayoutBox rootBox;
    private List pathToCurrent;
    private boolean justCreated = true;
    private boolean boxUpdated = true;

    protected LeafBoxIterator(LayoutBox box, LayoutBox root) {
        this.rootBox = root;
        if (box != null) {
            this.currentBox = box;
            this.hasNext();
        } else {
            this.currentBox = this.findFirstLeaf(root);
        }
        this.updatePath();
    }

    protected abstract LayoutBox getFirstInTraversal(LayoutBox var1);

    protected abstract int getNextIndexInTraversal(int var1);

    protected LayoutBox getNextAtCurrentLevelInTraversal(LayoutBox box, LayoutBox parent) {
        if (this.hasNextInTraversal(box, parent)) {
            int indexOfCurrent = parent.indexOf(box);
            int nextIndex = this.getNextIndexInTraversal(indexOfCurrent);
            return parent.getChild(nextIndex);
        }
        return null;
    }

    protected boolean hasNextInTraversal(LayoutBox box, LayoutBox parent) {
        int indexOfCurrent = parent.indexOf(box);
        int nextIndex = this.getNextIndexInTraversal(indexOfCurrent);
        return indexOfCurrent != -1 && nextIndex >= 0 && nextIndex < parent.numChildren();
    }

    private LayoutBox findFirstLeaf(LayoutBox box) {
        LayoutBox parent = box;
        LayoutBox child = this.getFirstInTraversal(parent);
        while (child != null) {
            parent = child;
            child = this.getFirstInTraversal(parent);
        }
        return parent;
    }

    private LayoutBox findParentInList(LayoutBox box) {
        int i = this.pathToCurrent.indexOf(box);
        if (i > 0) {
            return (LayoutBox)this.pathToCurrent.get(i - 1);
        }
        return null;
    }

    private void updatePath() {
        this.pathToCurrent = BoxUtils.findPathToBox(this.rootBox, this.currentBox);
        this.pathToCurrent.add(this.currentBox);
    }

    protected LayoutBox getNextInTraversal(LayoutBox box, LayoutBox parent) {
        if (parent == null) {
            return null;
        }
        LayoutBox nextChild = this.getNextAtCurrentLevelInTraversal(box, parent);
        if (nextChild != null) {
            return this.findFirstLeaf(nextChild);
        }
        if (parent != null) {
            LayoutBox grandparent = this.findParentInList(parent);
            return this.getNextInTraversal(parent, grandparent);
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        LayoutBox box;
        if (this.justCreated) {
            this.justCreated = false;
            return true;
        }
        LayoutBox currentParent = this.findParentInList(this.currentBox);
        this.currentBox = box = this.getNextInTraversal(this.currentBox, currentParent);
        if (this.currentBox != null) {
            this.updatePath();
        }
        this.boxUpdated = true;
        return this.currentBox != null;
    }

    public Object next() {
        if (!this.boxUpdated) {
            this.hasNext();
        }
        this.boxUpdated = false;
        return this.currentBox;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static class BackwardLeafBoxIterator
    extends LeafBoxIterator {
        public BackwardLeafBoxIterator(LayoutBox a, LayoutBox b) {
            super(a, b);
        }

        @Override
        protected LayoutBox getFirstInTraversal(LayoutBox box) {
            return box.getChild(box.numChildren() - 1);
        }

        @Override
        protected int getNextIndexInTraversal(int i) {
            return i - 1;
        }
    }

    public static class ForwardLeafBoxIterator
    extends LeafBoxIterator {
        public ForwardLeafBoxIterator(LayoutBox a, LayoutBox b) {
            super(a, b);
        }

        @Override
        protected LayoutBox getFirstInTraversal(LayoutBox box) {
            return box.getChild(0);
        }

        @Override
        protected int getNextIndexInTraversal(int i) {
            return i + 1;
        }
    }
}

