/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter;

import com.maplesoft.client.prettyprinter.DefaultLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutPoint;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import java.util.Iterator;

public class MatrixLayoutBox
extends DefaultLayoutBox {
    public static final int COLUMN_FILL_ORDER = 0;
    public static final int ROW_FILL_ORDER = 1;
    public static final int LEFT_JUSTIFY = 0;
    public static final int CENTER_JUSTIFY = 1;
    public static final int RIGHT_JUSTIFY = 2;
    private int rows;
    private int cols;
    private int nextIndex;
    private int fillOrder;
    private int justification;
    private int rowSeparator = 1;
    private int columnSeparator = 2;
    LayoutBox[] elements;
    private double baselineFF = 0.0;

    public MatrixLayoutBox(int rows, int cols, int fill) {
        super("Matrix");
        this.rows = rows;
        this.cols = cols;
        this.fillOrder = fill;
        this.justification = 0;
        this.nextIndex = 0;
        this.elements = new LayoutBox[rows * cols];
        this.setLineBreaker(LineBreakerFactory.newLineBreaker(5));
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.cols;
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public int numChildren() {
        return this.elements.length;
    }

    @Override
    public LayoutBox getChild(int index) {
        return index < this.elements.length ? this.elements[index] : null;
    }

    @Override
    public void addChild(LayoutBox child) {
        if (this.nextIndex < this.elements.length) {
            if (this.fillOrder == 1) {
                this.elements[this.nextIndex] = child;
            } else {
                int row = this.nextIndex % this.rows;
                int col = this.nextIndex / this.rows;
                int index = row * this.cols + col;
                this.elements[index] = child;
            }
        }
        ++this.nextIndex;
        this.validate(false);
    }

    @Override
    public Iterator getChildren() {
        return new MatrixLayoutIterator(this);
    }

    @Override
    public void setTheFirstOrigin() {
        this.elements[0].setOrigin(0.0, 0.0);
    }

    @Override
    public void computeSize() {
        if (this.numChildren() > 0) {
            LayoutBox reference = this.getChild(0);
            double xleft = reference.getXorig();
            double xright = xleft + reference.getWidth();
            double ybottom = reference.getYorig();
            double ytop = ybottom + reference.getHeight();
            int i = 0;
            i = 0;
            while (i < this.elements.length) {
                LayoutBox b = this.elements[i];
                if (b.getXorig() < xleft) {
                    xleft = b.getXorig();
                }
                if (b.getYorig() < ybottom) {
                    ybottom = b.getYorig();
                }
                if (b.getXorig() + b.getWidth() > xright) {
                    xright = b.getXorig() + b.getWidth();
                }
                if (b.getYorig() + b.getHeight() > ytop) {
                    ytop = b.getYorig() + b.getHeight();
                }
                ++i;
            }
            if (xleft != 0.0 || ybottom != 0.0) {
                LayoutPoint offset = new LayoutPoint(-xleft, -ybottom);
                i = 0;
                while (i < this.elements.length) {
                    this.elements[i].translateOrigin(offset);
                    ++i;
                }
                xright -= xleft;
                ytop -= ybottom;
                ybottom = 0.0;
                xleft = 0.0;
            }
            this.setSize(xright - xleft, ytop - ybottom);
            this.setBaseline((ytop - ybottom) / 2.0 + this.baselineFF);
            this.setOrigin(xleft, ybottom);
            this.validate(true);
        }
    }

    public void setSeparators(int row, int col) {
        this.rowSeparator = row;
        this.columnSeparator = col;
    }

    public int getRowSeparator() {
        return this.rowSeparator;
    }

    public int getColumnSeparator() {
        return this.columnSeparator;
    }

    public void setBaselineFudgeFactor(double ff) {
        this.baselineFF = ff;
    }

    public void setJustification(int justification) {
        this.justification = justification;
    }

    @Override
    public void applyLayout() {
        if (!this.isLayoutValid()) {
            this.setOrigin(0.0, 0.0);
            int i = 0;
            i = 0;
            while (i < this.elements.length) {
                if (this.elements[i] != null && this.elements[i].hasChildren()) {
                    this.elements[i].applyLayout();
                }
                ++i;
            }
            this.insertCells();
            this.computeSize();
        }
    }

    private void insertCells() {
        int n = 0;
        int row = 0;
        int col = 0;
        if (this.rows > 0 && this.cols > 0) {
            double[] colWidth = new double[this.cols];
            double rowOrigin = 0.0;
            double colOrigin = 0.0;
            double base = 0.0;
            double rowMin = 0.0;
            double rowMax = 0.0;
            double x = 0.0;
            double y = 0.0;
            double shift = 0.0;
            row = 0;
            while (row < this.rows) {
                LayoutBox sibling;
                int m = n = row * this.cols;
                double yMin = 0.0;
                y = 0.0;
                LayoutBox first = this.elements[m];
                base = first.getBaseline();
                rowMin = 0.0;
                rowMax = first.getHeight();
                if (first.getWidth() > colWidth[0]) {
                    colWidth[0] = first.getWidth();
                }
                col = 0;
                while (col < this.cols) {
                    sibling = this.elements[m++];
                    sibling.setOrigin(0.0, base - sibling.getBaseline());
                    y = sibling.getYorig();
                    x = sibling.getXorig();
                    if (y < yMin) {
                        yMin = y;
                    }
                    ++col;
                }
                if (yMin < 0.0) {
                    m = n;
                    LayoutPoint p = new LayoutPoint(0.0, -yMin);
                    col = 0;
                    while (col < this.cols) {
                        this.elements[m++].translateOrigin(p);
                        ++col;
                    }
                }
                m = n;
                col = 0;
                while (col < this.cols) {
                    int n2 = m++;
                    sibling = this.elements[n2];
                    if (sibling.getWidth() > colWidth[col]) {
                        colWidth[col] = sibling.getWidth();
                    }
                    if ((y = sibling.getYorig()) < rowMin) {
                        rowMin = y;
                    }
                    if ((y += sibling.getHeight()) > rowMax) {
                        rowMax = y;
                    }
                    ++col;
                }
                if (shift != 0.0) {
                    LayoutPoint offset = new LayoutPoint(0.0, shift);
                    n = row * this.cols;
                    col = 0;
                    while (col < this.cols) {
                        LayoutBox colb = this.elements[n++];
                        colb.translateOrigin(offset);
                        ++col;
                    }
                }
                rowMax -= rowMin;
                shift = rowOrigin += (rowMax += (double)this.rowSeparator);
                ++row;
            }
            row = 0;
            while (row < this.rows) {
                n = row * this.cols;
                colOrigin = 0.0;
                col = 0;
                while (col < this.cols) {
                    y = this.elements[n].getYorig();
                    x = 0.0;
                    if (this.justification != 0) {
                        x = colWidth[col] - this.elements[n].getWidth();
                        if (this.justification == 1) {
                            x /= 2.0;
                        }
                    }
                    this.elements[n].setOrigin(x + colOrigin, y);
                    colOrigin += colWidth[col] + (double)this.columnSeparator;
                    ++col;
                    ++n;
                }
                ++row;
            }
        }
    }

    private static class MatrixLayoutIterator
    implements Iterator {
        private MatrixLayoutBox parent;
        private int offset = 0;

        private MatrixLayoutIterator(MatrixLayoutBox parent) {
            this.parent = parent;
        }

        @Override
        public boolean hasNext() {
            return this.offset < this.parent.numChildren();
        }

        public Object next() {
            LayoutBox obj = this.parent.getChild(this.offset);
            ++this.offset;
            return obj;
        }

        @Override
        public void remove() {
        }
    }
}

