/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.PostLayoutJob;
import com.maplesoft.client.prettyprinter.SubexpressionLabelLayoutBox;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;

public class PostLayoutJobQueue {
    private HashMap jobMap;
    private LinkedList jobList;
    private int subexpressionNumber = 0;
    private boolean labelAllowed = true;
    private int labelWidth = 20;
    private HashSet dupSet;
    private HashSet testSet;
    private boolean[] allowedToLabel;

    public PostLayoutJobQueue() {
        boolean[] blArray = new boolean[94];
        blArray[13] = true;
        blArray[14] = true;
        blArray[15] = true;
        blArray[16] = true;
        blArray[17] = true;
        this.allowedToLabel = blArray;
        this.testSet = new HashSet();
        this.dupSet = new HashSet();
        this.jobMap = new HashMap();
        this.jobList = new LinkedList();
    }

    public void addJob(Object identifier, PostLayoutJob job) {
        this.jobMap.put(identifier, job);
        this.jobList.add(job);
    }

    public boolean containsJobForIdentifier(Object identifier) {
        return this.jobMap.containsKey(identifier);
    }

    public boolean containsJob(PostLayoutJob job) {
        return this.jobList.indexOf(job) != -1;
    }

    public PostLayoutJob getJob(Object identifier) {
        return (PostLayoutJob)this.jobMap.get(identifier);
    }

    public PostLayoutJob getFirstJob() {
        return (PostLayoutJob)this.jobList.get(0);
    }

    public int getJobCount() {
        return this.jobList.size();
    }

    public PostLayoutJob removeFirstJob() {
        PostLayoutJob job = (PostLayoutJob)this.jobList.remove(0);
        Object key = null;
        for (Map.Entry entry : this.jobMap.entrySet()) {
            if (!entry.getValue().equals(job)) continue;
            key = entry.getKey();
            break;
        }
        this.jobMap.remove(key);
        return job;
    }

    public boolean isEmpty() {
        return this.jobList.isEmpty();
    }

    public int getSubexpressionNumber() {
        return this.subexpressionNumber;
    }

    public void setSubexpressionNumber(int number) {
        this.subexpressionNumber = number;
    }

    public LayoutBox subexpressionLabel(LayoutFormatter f, LayoutBox source, Dag dag) {
        if (this.labelAllowed && this.isDuplicated(dag)) {
            source.applyLayout();
            double itemWidth = source.getWidth();
            int testWidth = (int)((double)this.labelWidth * f.getFontWidth(0));
            if (itemWidth >= (double)testWidth) {
                source = new SubexpressionLabelLayoutBox(f, source, DagBuilder.lPrint(dag));
            }
        }
        return source;
    }

    public void setLabelAllowed(boolean labelAllowed) {
        this.labelAllowed = labelAllowed;
    }

    public boolean getLabelAllowed() {
        return this.labelAllowed;
    }

    public void setLabelWidth(int labelWidth) {
        this.labelWidth = labelWidth;
    }

    public void locateDuplicates(Dag dag) {
        this.dupSet = new HashSet();
        this.internalLocateDuplicates(dag, dag);
        this.testSet = new HashSet();
    }

    private void internalLocateDuplicates(Dag dag, Dag parentTest) {
        if (this.allowedToLabel[dag.getType()] && !this.dupSet.contains(dag)) {
            if (this.testSet.contains(dag)) {
                this.dupSet.add(dag);
            } else {
                this.testSet.add(dag);
            }
        }
        int i = 0;
        while (i < dag.getLength()) {
            this.internalLocateDuplicates(dag.getChild(i), dag);
            ++i;
        }
    }

    public boolean isDuplicated(Dag dag) {
        return this.dupSet.contains(dag);
    }
}

