/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter;

import com.maplesoft.client.prettyprinter.BracketLayoutBox;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;

public class TTYBracketLayoutBox
extends BracketLayoutBox {
    private static final char LEFT_PAREN = '(';
    private static final char RIGHT_PAREN = ')';
    private static final char LEFT_BRACKET = '[';
    private static final char RIGHT_BRACKET = ']';
    private static final char LEFT_BRACE = '{';
    private static final char RIGHT_BRACE = '}';
    private static final char ABSOLUTE_BAR = '|';
    private static final char LOW_LEFT_PAREN = '\\';
    private static final char UPPER_LEFT_PAREN = '/';
    private static final char LEFT_PAREN_FILL = '|';
    private static final char LOW_LEFT_BRACKET = '[';
    private static final char UPPER_LEFT_BRACKET = '[';
    private static final char LEFT_BRACKET_FILL = '[';
    private static final char LOW_RIGHT_PAREN = '/';
    private static final char UPPER_RIGHT_PAREN = '\\';
    private static final char RIGHT_PAREN_FILL = '|';
    private static final char LOW_RIGHT_BRACKET = ']';
    private static final char UPPER_RIGHT_BRACKET = ']';
    private static final char RIGHT_BRACKET_FILL = ']';
    private static final char INTEGRAL_SMALL = 'S';
    private static final char INTEGRAL_TOP = '/';
    private static final char INTEGRAL_BOTTOM = '/';
    private static final char INTEGRAL_FILL = '|';
    private static final char LOW_LEFT_BRACE = '\\';
    private static final char UPPER_LEFT_BRACE = '/';
    private static final char LEFT_BRACE_FILL = '|';
    private static final char LEFT_BRACE_MIDDLE = '<';
    private static final char LOW_RIGHT_BRACE = '/';
    private static final char UPPER_RIGHT_BRACE = '\\';
    private static final char RIGHT_BRACE_FILL = '|';
    private static final char RIGHT_BRACE_MIDDLE = '>';
    private static final int FIXED_INTEGRAL_HEIGHT = 5;
    private static final int MIN_INTEGRAL_HEIGHT = 3;
    private static final int MAX_INTEGRAL_HEIGHT = 5;
    private TTYBracket bracket = null;

    public TTYBracketLayoutBox(int type) {
        super(type);
        switch (type) {
            case 91: {
                this.bracket = new LeftParen();
                break;
            }
            case 92: {
                this.bracket = new RightParen();
                break;
            }
            case 93: {
                this.bracket = new LeftBrace();
                break;
            }
            case 94: {
                this.bracket = new RightBrace();
                break;
            }
            case 103: 
            case 106: {
                this.bracket = new LeftAbsolute();
                break;
            }
            case 104: {
                this.bracket = new RightAbsolute();
                break;
            }
            case 95: {
                this.bracket = new LeftBracket();
                break;
            }
            case 96: {
                this.bracket = new RightBracket();
                break;
            }
            case 97: {
                this.bracket = new IntegralBracket();
            }
        }
    }

    public void drawBracket(char[][] out, int xoffset, int yoffset) {
        if (this.bracket != null) {
            this.bracket.drawBracket(out, xoffset, yoffset);
        }
    }

    @Override
    public void setSize(double width, double height) {
        if (this.bracket != null) {
            super.setSize(width, height);
            this.bracket.setSize(width, height);
        }
    }

    protected static class IntegralBracket
    extends TTYBracket {
        protected IntegralBracket() {
            super(97, 'S', '/', '|', '/');
        }

        @Override
        public void drawBracket(char[][] out, int xoffset, int yoffset) {
            int h = (int)this.getHeight();
            ++xoffset;
            if (h < 2) {
                out[yoffset][xoffset] = this.single;
            } else {
                out[yoffset][xoffset + 1] = this.top;
                int i = 1;
                while (i < h - 1) {
                    out[yoffset + i][xoffset] = this.fill;
                    ++i;
                }
                out[yoffset + h - 1][xoffset - 1] = this.bottom;
            }
        }
    }

    protected static class LeftAbsolute
    extends TTYBracket {
        protected LeftAbsolute() {
            super(103, '|', '|', '|', '|');
        }
    }

    protected static class LeftBrace
    extends TTYBrace {
        protected LeftBrace() {
            super(93, '{', '\\', '|', '<', '/');
        }
    }

    protected static class LeftBracket
    extends TTYBracket {
        protected LeftBracket() {
            super(95, '[', '[', '[', '[');
        }
    }

    protected static class LeftParen
    extends TTYBracket {
        protected LeftParen() {
            super(91, '(', '\\', '|', '/');
        }
    }

    protected static class RightAbsolute
    extends TTYBracket {
        protected RightAbsolute() {
            super(104, '|', '|', '|', '|');
        }
    }

    protected static class RightBrace
    extends TTYBrace {
        protected RightBrace() {
            super(94, '}', '/', '|', '>', '\\');
        }
    }

    protected static class RightBracket
    extends TTYBracket {
        protected RightBracket() {
            super(96, ']', ']', ']', ']');
        }
    }

    protected static class RightParen
    extends TTYBracket {
        protected RightParen() {
            super(92, ')', '/', '|', '\\');
        }
    }

    protected static class TTYBrace
    extends TTYBracket {
        private char middle;

        protected TTYBrace(int type, char single, char bottom, char fill, char middle, char top) {
            super(type, single, bottom, fill, top);
            this.middle = middle;
        }

        @Override
        public void drawBracket(char[][] out, int xoffset, int yoffset) {
            int h = (int)this.getHeight();
            int ioffset = 1;
            int ooffset = 0;
            if (this.single == '}') {
                ioffset = 0;
                ooffset = 1;
            }
            if (h == 1) {
                out[yoffset][xoffset] = this.single;
            } else if (h < 4) {
                out[yoffset][xoffset + ioffset] = this.top;
                out[yoffset + 1][xoffset + ooffset] = this.single;
                out[yoffset + 2][xoffset + ioffset] = this.bottom;
            } else {
                out[yoffset][xoffset + ioffset] = this.top;
                int i = 1;
                while (i < h - 1) {
                    out[yoffset + i][xoffset + ioffset] = this.fill;
                    ++i;
                }
                out[yoffset + h / 2][xoffset + ooffset] = this.middle;
                out[yoffset + h / 2][xoffset + ioffset] = 32;
                out[yoffset + h - 1][xoffset + ioffset] = this.bottom;
            }
        }
    }

    protected static class TTYBracket
    extends NotationLayoutBox {
        protected char single;
        protected char bottom;
        protected char fill;
        protected char top;

        protected TTYBracket(int type, char single, char bottom, char fill, char top) {
            super(type);
            this.single = single;
            this.bottom = bottom;
            this.fill = fill;
            this.top = top;
        }

        public void drawBracket(char[][] out, int xoffset, int yoffset) {
            int h = (int)this.getHeight();
            if (yoffset > out.length - 1) {
                System.out.println("drawBracket: out of bounds! " + this.single);
                System.out.println("yoffset: " + yoffset + ", height: " + h + ", out.length: " + out.length);
            } else if (h < 2) {
                out[yoffset][xoffset] = this.single;
            } else {
                out[yoffset][xoffset] = this.top;
                int i = 1;
                while (i < h - 1) {
                    out[yoffset + i][xoffset] = this.fill;
                    ++i;
                }
                out[yoffset + h - 1][xoffset] = this.bottom;
            }
        }
    }
}

