/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.linebreaker;

import com.maplesoft.client.prettyprinter.DefaultLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutAnchor;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.linebreaker.BracketLineBreaker;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakLayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreaker;

public class DefaultLineBreaker
implements LineBreaker {
    protected static final double LINEBREAKING_MINIMUM_CHARACTERS = 5.0;

    @Override
    public LayoutBox startLinebreak(LayoutBox source, LayoutFormatter formatter, double widthHint) {
        source.applyLayout();
        LineBreakLayoutBox lineBreakLayout = new LineBreakLayoutBox(formatter);
        LayoutBox result = this.linebreak(source, lineBreakLayout, formatter, widthHint, false, 0.0, 0.0);
        if (result instanceof LineBreakLayoutBox) {
            ((LineBreakLayoutBox)result).finishCurrentRow(formatter);
        }
        result.applyLayout();
        return result;
    }

    @Override
    public LayoutBox linebreak(LayoutBox box, LineBreakLayoutBox target, LayoutFormatter formatter, double width, boolean forceLine, double xOffset, double yOffset) {
        LineBreakLayoutBox rootBox = target;
        xOffset += box.getXorig();
        yOffset += box.getYorig();
        int i = 0;
        while (i < box.numChildren()) {
            LayoutBox child = box.getChild(i);
            if (child != null) {
                if (DefaultLineBreaker.fitsOnLine(child, rootBox, width) && !forceLine) {
                    rootBox.addChild(child, xOffset, yOffset);
                } else if (DefaultLineBreaker.fitsOnLine(child, rootBox, width) || forceLine) {
                    DefaultLineBreaker.nextLinebreak(child, rootBox, formatter, width, false, xOffset, yOffset);
                } else {
                    if (!forceLine && !this.findGoodBreakPoint(child, rootBox, width, 0)) {
                        rootBox.finishCurrentRow(formatter);
                        rootBox.createNewRow(formatter);
                    }
                    if (DefaultLineBreaker.fitsOnLine(child, rootBox, width)) {
                        rootBox.addChild(child, xOffset, yOffset);
                    } else {
                        DefaultLineBreaker.nextLinebreak(child, rootBox, formatter, width, false, xOffset, yOffset);
                    }
                }
            }
            ++i;
        }
        return rootBox;
    }

    public static void nextLinebreak(LayoutBox source, LineBreakLayoutBox target, LayoutFormatter formatter, double width, boolean forceLine, double xOffset, double yOffset) {
        LayoutBox ideal;
        if (source != null && (ideal = source.getIdealLayoutBox()) != null) {
            LineBreaker linebreaker = ideal.getLineBreaker();
            if (linebreaker instanceof BracketLineBreaker) {
                linebreaker.continueLinebreak(source, target, formatter, width, true, xOffset, yOffset);
            } else if (linebreaker != null) {
                linebreaker.continueLinebreak(source, target, formatter, width, forceLine, xOffset, yOffset);
            }
        }
    }

    @Override
    public void continueLinebreak(LayoutBox source, LineBreakLayoutBox target, LayoutFormatter formatter, double widthHint, boolean forceLine, double xOffset, double yOffset) {
        this.linebreak(source, target, formatter, widthHint, forceLine, xOffset, yOffset);
    }

    public void finishRow(LayoutBox rootBox, LayoutBox currentLine, LayoutFormatter formatter) {
        DefaultLayoutBox rowSpacer = new DefaultLayoutBox();
        rowSpacer.setSize(0.0, formatter.getRowSeparator());
        rootBox.addChild(rowSpacer);
        rootBox.addChild(currentLine);
    }

    public void addLRAnchors(LayoutBox box) {
        int i = 0;
        while (i < box.numChildren() - 1) {
            box.addLayoutAnchor(LayoutAnchor.createLeftToRightAnchor(i));
            ++i;
        }
    }

    public void addTBAnchors(LayoutBox box) {
        int i = 0;
        while (i < box.numChildren() - 1) {
            box.addLayoutAnchor(LayoutAnchor.createTopToBottomAnchor(i));
            ++i;
        }
    }

    @Override
    public boolean findGoodBreakPoint(LayoutBox box, LineBreakLayoutBox rootBox, double width, int startIndex) {
        boolean goodBreak = false;
        if (DefaultLineBreaker.fitsOnLine(box, rootBox, width)) {
            goodBreak = true;
        } else {
            int size = box.numChildren();
            if (size > startIndex) {
                double baseOffset = box.getChild(startIndex).getXorig();
                int i = startIndex;
                while (i < size && !goodBreak) {
                    LayoutBox child = box.getChild(i);
                    double xOffset = child.getXorig();
                    double adjustedWidth = width - (xOffset - baseOffset);
                    if (adjustedWidth < 0.0) break;
                    LineBreaker breaker = child.getLineBreaker();
                    if (this.validLineBreakerForSearch(breaker)) {
                        goodBreak = breaker.findGoodBreakPoint(child, rootBox, adjustedWidth, 0);
                    }
                    ++i;
                }
            }
        }
        return goodBreak;
    }

    @Override
    public boolean validLineBreakerForSearch(LineBreaker breaker) {
        return true;
    }

    public static double getCharacterBreakWidth(double width, LayoutFormatter formatter) {
        double rwidth = width;
        return rwidth;
    }

    public static double getMinimumBreakWidth(double width, LayoutFormatter formatter) {
        double mwidth = width;
        return mwidth;
    }

    public static boolean fitsOnLine(double width, double widthHint) {
        return width < widthHint;
    }

    public static boolean fitsOnLine(LayoutBox target, LineBreakLayoutBox rootBox, double widthHint) {
        return target.getWidth() + rootBox.getCurrentLineWidth() < widthHint;
    }
}

