/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.selection;

import com.maplesoft.client.prettyprinter.selection.EquationSelectionEvent;
import com.maplesoft.client.prettyprinter.selection.EquationSelectionListener;
import com.maplesoft.client.prettyprinter.selection.EquationSelectionRecorder;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;

public class EquationSelectionManager {
    private LinkedList listeners = new LinkedList();

    public EquationSelectionManager() {
        this.addEquationSelectionListener(EquationSelectionRecorder.getInstance());
    }

    public void addEquationSelectionListener(EquationSelectionListener l) {
        this.listeners.add(l);
    }

    public void removeEquationSelectionListener(EquationSelectionListener l) {
        int i = 0;
        i = this.listeners.indexOf(l);
        if (i > -1) {
            this.listeners.remove(i);
        }
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    public void fireActionEvent(EquationSelectionEvent e) {
        this.eventDispatch(new ActionDispatch(), e);
    }

    public void fireContextEvent(EquationSelectionEvent e) {
        this.eventDispatch(new ContextDispatch(), e);
    }

    public void fireSelectionEvent(EquationSelectionEvent e) {
        this.eventDispatch(new SelectionDispatch(), e);
    }

    private void eventDispatch(Dispatcher type, EquationSelectionEvent e) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            if (e.isConsumed()) break;
            try {
                EquationSelectionListener listen = (EquationSelectionListener)it.next();
                type.dispatch(listen, e);
            }
            catch (ConcurrentModificationException ex) {
                break;
            }
        }
    }

    class ActionDispatch
    implements Dispatcher {
        ActionDispatch() {
        }

        @Override
        public void dispatch(EquationSelectionListener t, EquationSelectionEvent e) {
            t.actionRequest(e);
        }
    }

    class ContextDispatch
    implements Dispatcher {
        ContextDispatch() {
        }

        @Override
        public void dispatch(EquationSelectionListener t, EquationSelectionEvent e) {
            t.contextRequest(e);
        }
    }

    static interface Dispatcher {
        public void dispatch(EquationSelectionListener var1, EquationSelectionEvent var2);
    }

    class SelectionDispatch
    implements Dispatcher {
        SelectionDispatch() {
        }

        @Override
        public void dispatch(EquationSelectionListener t, EquationSelectionEvent e) {
            t.selectionChanged(e);
        }
    }
}

