/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.selection;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.selection.EquationSelectionEvent;
import com.maplesoft.client.prettyprinter.selection.EquationSelectionListener;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;

public class EquationSelectionRecorder
implements EquationSelectionListener {
    private static EquationSelectionRecorder instance;
    private Dag selectedDag;
    private LayoutBox selectedBox;
    private LayoutBox rootBox;
    private List selectedList;
    private EventObject selectionTrigger;
    boolean haltUpdateForForcedSelection = false;

    private EquationSelectionRecorder() {
    }

    public static EquationSelectionRecorder getInstance() {
        if (instance == null) {
            instance = new EquationSelectionRecorder();
        }
        return instance;
    }

    @Override
    public void contextRequest(EquationSelectionEvent e) {
    }

    @Override
    public void actionRequest(EquationSelectionEvent e) {
    }

    public void forceRecordsClear() {
        this.selectedDag = null;
        this.selectedBox = null;
        this.selectedList = null;
        this.selectionTrigger = null;
        this.rootBox = null;
        this.haltUpdateForForcedSelection = false;
    }

    public void forceRecordSelection(Dag dag, LayoutBox root, LayoutBox box) {
        this.selectedDag = dag;
        this.selectedBox = box;
        this.selectedList = new LinkedList();
        this.selectedList.add(box);
        this.rootBox = root;
        this.haltUpdateForForcedSelection = true;
    }

    @Override
    public void selectionChanged(EquationSelectionEvent e) {
        if (this.haltUpdateForForcedSelection) {
            this.haltUpdateForForcedSelection = false;
        } else if (e.isClearedSelection()) {
            this.forceRecordsClear();
        } else {
            this.selectedDag = e.getDag();
            this.selectedBox = e.getSelectedBox();
            this.selectedList = e.getMultiSelectedBoxes();
            this.rootBox = e.getRootBox();
            this.selectionTrigger = e.getSourceEvent();
        }
    }

    public Dag getSelectedDag() {
        return this.selectedDag;
    }

    public LayoutBox getSelectedBox() {
        return this.selectedBox;
    }

    public List getMultiSelectionList() {
        return this.selectedList;
    }

    public EventObject getSelectionTrigger() {
        return this.selectionTrigger;
    }

    public LayoutBox getRootBox() {
        return this.rootBox;
    }
}

