/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.selection;

import com.maplesoft.client.prettyprinter.LayoutBox;

public class SelectionData {
    public static final int NO_SELECTION_CODE = 0;
    public static final int SUBSELECTABLE = 1;
    public static final int SELECT_ALL_ONLY = 16;
    public static final int SELECTABLE = 2;
    public static final int SINGLE_SUBSELECTABLE_OR_ALL = 3;
    public static final int SELECT_ALL_IN_PARENT = 4;
    public static final int CONTEXT_HELP_AVAILABLE = -128;
    public static final int TRAVERSE_ASCEND = -10;
    public static final int TRAVERSE_DESCEND = -12;
    public static final int NORTH = -2;
    public static final int UP = -2;
    public static final int SOUTH = 2;
    public static final int DOWN = 2;
    public static final int EAST = 1;
    public static final int LEFT = 1;
    public static final int WEST = -1;
    public static final int RIGHT = -1;
    private int selectionCode;
    private int[] traversalNorthSouth;
    private int[] traversalEastWest;
    private int firstCaretPosition = 0;
    private int lastCaretPosition = -1;

    public SelectionData() {
        this.setSelectionCode(0);
    }

    public SelectionData(int selectionCode) {
        this.setSelectionCode(selectionCode);
    }

    public int getSelectionCode() {
        return this.isContextHelpAvailable() ? this.selectionCode ^ 0xFFFFFF80 : this.selectionCode;
    }

    public void setSelectionCode(int selectionCode) {
        this.selectionCode = selectionCode;
        this.setContextHelpAvailable(true);
    }

    public void setContextHelpAvailable(boolean value) {
        if (value) {
            this.selectionCode |= 0xFFFFFF80;
        } else if (!value && this.isContextHelpAvailable()) {
            this.selectionCode ^= 0xFFFFFF80;
        }
    }

    public boolean isContextHelpAvailable() {
        return (this.selectionCode & 0xFFFFFF80) == -128;
    }

    public void setFirstCaretPosition(int firstCaretPosition) {
        this.firstCaretPosition = firstCaretPosition;
    }

    public int getFirstCaretPosition() {
        return this.firstCaretPosition;
    }

    public void setLastCaretPosition(int lastCaretPosition) {
        this.lastCaretPosition = lastCaretPosition;
    }

    public int getLastCaretPosition() {
        return this.lastCaretPosition;
    }

    public boolean isIndividuallySelectable() {
        return this.getSelectionCode() == 1;
    }

    public void setTraversalNorthSouth(int[] traversal) {
        this.traversalNorthSouth = traversal;
    }

    public void setTraversalEastWest(int[] traversal) {
        this.traversalEastWest = traversal;
    }

    public static boolean isUp(int code) {
        return code == -2;
    }

    public static boolean isDown(int code) {
        return code == 2;
    }

    public static boolean isLeft(int code) {
        return code == -1;
    }

    public static boolean isRight(int code) {
        return code == 1;
    }

    public static boolean isUpDown(int code) {
        return code == -2 || code == 2;
    }

    public static boolean isRightLeft(int code) {
        return code == 1 || code == -1;
    }

    public static boolean isNorth(int code) {
        return SelectionData.isUp(code);
    }

    public static boolean isSouth(int code) {
        return SelectionData.isDown(code);
    }

    public static boolean isWest(int code) {
        return SelectionData.isLeft(code);
    }

    public static boolean isEast(int code) {
        return SelectionData.isRight(code);
    }

    public static boolean isNorthSouth(int code) {
        return SelectionData.isUpDown(code);
    }

    public static boolean isEastWest(int code) {
        return SelectionData.isRightLeft(code);
    }

    public static int determineTraversalDirection(int keyEventCode) {
        int traversalDirection = 0;
        if (keyEventCode == 38 || keyEventCode == 224) {
            traversalDirection = -2;
        } else if (keyEventCode == 40 || keyEventCode == 225) {
            traversalDirection = 2;
        } else if (keyEventCode == 39 || keyEventCode == 227) {
            traversalDirection = 1;
        } else if (keyEventCode == 37 || keyEventCode == 226) {
            traversalDirection = -1;
        }
        return traversalDirection;
    }

    public static int defaultTraversal(int pos, int direction) {
        if (SelectionData.isUp(direction)) {
            --pos;
        } else if (SelectionData.isDown(direction)) {
            ++pos;
        } else if (SelectionData.isRight(direction)) {
            ++pos;
        } else if (SelectionData.isLeft(direction)) {
            --pos;
        }
        return pos;
    }

    public int traverse(int pos, int direction) {
        int position = 0;
        if (Math.abs(direction) == 2) {
            direction = direction < 0 ? -1 : 1;
            position = pos + direction < 0 || pos + direction >= this.traversalNorthSouth.length ? -10 : this.traversalNorthSouth[pos + direction];
        } else {
            position = pos + direction < 0 || pos + direction >= this.traversalEastWest.length ? -10 : this.traversalEastWest[pos + direction];
        }
        return position;
    }

    public void setStandardEastWestArray(LayoutBox box) {
        int[] traversal = new int[2];
        int numChildren = 0;
        traversal[1] = -10;
        traversal[0] = -10;
        if (box != null && (numChildren = box.numChildren()) > 0) {
            traversal = new int[numChildren + 1];
            int i = 0;
            while (i < traversal.length) {
                traversal[i] = i;
                ++i;
            }
            traversal[numChildren] = -10;
        }
        this.setTraversalEastWest(traversal);
    }

    public void setStandardNorthSouthArray() {
        int[] traversal = new int[2];
        traversal[1] = -10;
        traversal[0] = -10;
        this.setTraversalNorthSouth(traversal);
    }

    public int getTraversalArrayIndex(int boxChildPosition, int direction) {
        int traversalArrayIndex;
        block5: {
            block6: {
                traversalArrayIndex = 0;
                if (!SelectionData.isRightLeft(direction)) break block6;
                if (this.traversalEastWest == null) break block5;
                int i = 0;
                while (i < this.traversalEastWest.length) {
                    if (this.traversalEastWest[i] == boxChildPosition) {
                        traversalArrayIndex = i;
                        break block5;
                    }
                    ++i;
                }
                break block5;
            }
            if (this.traversalNorthSouth != null) {
                int i = 0;
                while (i < this.traversalNorthSouth.length) {
                    if (this.traversalNorthSouth[i] == boxChildPosition) {
                        traversalArrayIndex = i;
                        break;
                    }
                    ++i;
                }
            }
        }
        return traversalArrayIndex;
    }
}

