/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.template;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.FunctionDagFactory;
import com.maplesoft.client.prettyprinter.AncestorArrayLayoutBox;
import com.maplesoft.client.prettyprinter.DefaultLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutAnchor;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.ResizableNotationBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import com.maplesoft.client.prettyprinter.selection.StandardSelectionData;
import com.maplesoft.client.prettyprinter.template.SpecialFunctionTemplate;

public class ConjugateTemplate
implements SpecialFunctionTemplate {
    private static final SelectionData overbarSD = new StandardSelectionData(4);

    static {
        overbarSD.setContextHelpAvailable(false);
    }

    @Override
    public LayoutBox apply(LayoutFormatter formatter, Dag function, Dag[] args) {
        LayoutBox box = new DefaultLayoutBox(2);
        int[] nArray = new int[2];
        nArray[0] = 1;
        int[] underPath = nArray;
        if (args != null && args.length > 0) {
            Dag dag = args[0];
            LayoutBox under = DagBuilder.createLayout(formatter, dag);
            under = AncestorArrayLayoutBox.wrapWithAncestorData(under, function, underPath);
            ResizableNotationBox overbar = new ResizableNotationBox(formatter, 105, 1, under);
            overbar.setSelectionData(overbarSD);
            box.addChild(under);
            box.addChild(overbar);
            box.addLayoutAnchor(LayoutAnchor.UNDER_01);
            box.applyLayout();
            if (box.getWidth() < formatter.getSafeBreakWidth()) {
                int[] EWtraversal = new int[]{1};
                int[] NStraversal = new int[]{1};
                SelectionData sd = new SelectionData(1);
                sd.setLastCaretPosition(0);
                sd.setTraversalNorthSouth(NStraversal);
                sd.setTraversalEastWest(EWtraversal);
                box.setSelectionData(sd);
                box.setLineBreaker(LineBreakerFactory.newLineBreaker(5));
            } else {
                box = FunctionDagFactory.createGenericLayout(formatter, function);
            }
        }
        return box;
    }
}

