/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.template;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.FunctionDagFactory;
import com.maplesoft.client.prettyprinter.AncestorArrayLayoutBox;
import com.maplesoft.client.prettyprinter.DefaultLayoutBox;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutAnchor;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.ResizableNotationBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import com.maplesoft.client.prettyprinter.selection.StandardSelectionData;
import com.maplesoft.client.prettyprinter.template.BracketTemplate;
import com.maplesoft.client.prettyprinter.template.SpecialFunctionTemplate;

public class EvalTemplate
implements SpecialFunctionTemplate {
    private static final SelectionData evalSD = new StandardSelectionData(4);

    static {
        evalSD.setContextHelpAvailable(false);
    }

    @Override
    public LayoutBox apply(LayoutFormatter formatter, Dag evalFunction, Dag[] args) {
        LayoutBox box = null;
        int[] nArray = new int[2];
        nArray[0] = 1;
        int[] funcPath = nArray;
        int[] subPath = new int[]{1, 1};
        if (args != null && args.length == 2) {
            Dag function = args[0];
            Dag[] eq = null;
            if (args[1].getType() == 36) {
                int numChildEqDags = 0;
                Dag setDag = args[1];
                int length = setDag.getLength();
                int i = 0;
                while (i < length) {
                    if (setDag.getChild(i).getType() == 20) {
                        ++numChildEqDags;
                    }
                    ++i;
                }
                eq = new Dag[numChildEqDags];
                int index = 0;
                int i2 = 0;
                while (i2 < length) {
                    Dag child = setDag.getChild(i2);
                    if (child.getType() == 20) {
                        eq[index] = child;
                        ++index;
                    }
                    ++i2;
                }
            } else if (args[1].getType() == 20) {
                eq = new Dag[]{args[1]};
            }
            if (eq != null) {
                formatter.incSuperscriptCount();
                InlineLayoutBox varBox = new InlineLayoutBox(eq.length * 2 + 1);
                int i = 0;
                while (i < eq.length) {
                    if (eq.length > 1) {
                        subPath = new int[3];
                        subPath[1] = 1;
                        subPath[0] = 1;
                        subPath[2] = i;
                    }
                    LayoutBox subVarBox = DagBuilder.createLayout(formatter, eq[i]);
                    subVarBox = AncestorArrayLayoutBox.wrapWithAncestorData(subVarBox, evalFunction, subPath);
                    varBox.addChild(subVarBox);
                    if (i < eq.length - 1) {
                        NotationLayoutBox comma = NotationLayoutBox.createNotationBox(formatter, 14);
                        varBox.addChild(comma);
                    }
                    ++i;
                }
                formatter.decSuperscriptCount();
                LayoutBox functionBox = DagBuilder.createLayout(formatter, function);
                functionBox = AncestorArrayLayoutBox.wrapWithAncestorData(functionBox, evalFunction, funcPath);
                functionBox = BracketTemplate.apply(formatter, functionBox, function, 3);
                formatter.incSuperscriptCount();
                ResizableNotationBox evalBar = new ResizableNotationBox(formatter, 103, 3, functionBox, varBox);
                evalBar.setSelectionData(evalSD);
                formatter.decSuperscriptCount();
                box = new DefaultLayoutBox(3);
                box.addChild(functionBox);
                box.addChild(evalBar);
                box.addChild(varBox);
                box.addLayoutAnchor(LayoutAnchor.TOPLEFT_01);
                box.addLayoutAnchor(LayoutAnchor.BOTTOMRIGHT_21);
                box.applyLayout();
                if (box.getWidth() < formatter.getSafeBreakWidth()) {
                    SelectionData sd = new SelectionData(1);
                    sd.setStandardEastWestArray(box);
                    sd.setStandardNorthSouthArray();
                    box.setSelectionData(sd);
                    box.setLineBreaker(LineBreakerFactory.newLineBreaker(5));
                } else {
                    box = FunctionDagFactory.createGenericLayout(formatter, evalFunction);
                }
            }
        }
        return box;
    }
}

