/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.template;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagConstants;
import com.maplesoft.client.dag.DagRenderContext;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.SumDagFactory;
import com.maplesoft.client.prettyprinter.AbstractFormatter;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.PowerLayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import com.maplesoft.client.prettyprinter.selection.StandardSelectionData;
import com.maplesoft.client.prettyprinter.template.SpecialFunctionTemplate;

public class FloatTemplate
implements SpecialFunctionTemplate {
    private static final int DEFAULT_DISPLAY_PRECISION = -1;
    private static int displayPrecision = -1;
    private static SelectionData noHelpSD = null;
    public static final int SCIENTIFIC_NOTATION_THRESHOLD = 6;

    @Override
    public LayoutBox apply(LayoutFormatter formatter, Dag function, Dag[] args) {
        if (args.length > 1) {
            return FloatTemplate.apply(formatter, args[0], args[1]);
        }
        return null;
    }

    public static void updateContext(DagRenderContext context) {
        displayPrecision = context.getInterfaceProperty("displayprecision", -1);
    }

    public static LayoutBox buildFloatInfinity(LayoutFormatter f, boolean negative) {
        Dag type = negative ? DagConstants.MINUS_INFINITY : DagConstants.INFINITY;
        return DagBuilder.createLayout(f, type);
    }

    public static LayoutBox apply(LayoutFormatter f, Dag argOne, Dag argTwo) {
        boolean isFloatFunctionInfinity;
        LayoutBox box = null;
        StringBuffer floats = new StringBuffer();
        boolean bl = isFloatFunctionInfinity = argTwo.getType() == 8 && argTwo.getData().equals("infinity") || argTwo.getType() == 16 && argTwo.getChild(1).getData().equals("infinity");
        if (isFloatFunctionInfinity) {
            return FloatTemplate.buildFloatInfinity(f, DagUtil.isMinusOne(SumDagFactory.sumDagToIntegerDag(argOne)));
        }
        if (argTwo.getType() == 8) {
            box = DagUtil.isFloatInfinity(argTwo) ? FloatTemplate.buildFloatInfinity(f, DagUtil.isMinusOne(SumDagFactory.sumDagToIntegerDag(argTwo))) : DagBuilder.createLayout(f, DagConstants.UNDEFINED);
            return box;
        }
        if (argOne.getType() == 16) {
            argOne = SumDagFactory.sumDagToIntegerDag(argOne);
        }
        if (argTwo.getType() == 16) {
            argTwo = SumDagFactory.sumDagToIntegerDag(argTwo);
        }
        boolean negative = argOne.getType() == 1;
        String strMantissa = argOne.getData();
        int exponent = FloatTemplate.calculateExponent(argTwo);
        if (strMantissa == null) {
            strMantissa = "0";
        }
        int mantissaLength = strMantissa.length();
        int expCount = 0;
        int mantExpDif = mantissaLength + exponent;
        expCount = exponent < 0 && Math.abs(mantExpDif) >= 5 ? mantExpDif : (exponent < 0 ? 0 : (mantExpDif == 0 ? mantExpDif : mantExpDif));
        int n = expCount = Math.abs(expCount) < 6 ? 0 : expCount;
        if (negative) {
            floats.append("-");
        }
        if (noHelpSD == null) {
            noHelpSD = new StandardSelectionData(2);
            noHelpSD.setContextHelpAvailable(false);
        }
        if (expCount != 0) {
            box = new InlineLayoutBox();
            NotationLayoutBox ten = NotationLayoutBox.createCustomBox(f, "10", 4);
            ten.setSelectionData(noHelpSD);
            NotationLayoutBox expon = null;
            int rightLength = strMantissa.length();
            rightLength = displayPrecision >= 0 ? displayPrecision : rightLength;
            floats = FloatTemplate.buildFloatString(floats, strMantissa, 0, 0, 1, rightLength);
            NotationLayoutBox mantissaBox = NotationLayoutBox.createCustomBox(f, floats.toString(), 4);
            mantissaBox.setLineBreaker(LineBreakerFactory.newLineBreaker(3));
            mantissaBox.setSelectionData(noHelpSD);
            f.incSuperscriptCount();
            expon = NotationLayoutBox.createCustomBox(f, "" + (expCount - 1), 4);
            expon.setSelectionData(noHelpSD);
            f.decSuperscriptCount();
            box.addChild(mantissaBox);
            if (f.isInProc()) {
                box.addChild(NotationLayoutBox.createNotationBox(f, 75));
                box.addChild(ten);
                box.addChild(NotationLayoutBox.createNotationBox(f, 51));
                box.addChild(expon);
            } else {
                box.addChild(NotationLayoutBox.createNotationBox(f, 76));
                PowerLayoutBox exponentBox = new PowerLayoutBox(ten, (LayoutBox)expon, true, (AbstractFormatter)f);
                box.addChild(exponentBox);
                box.setLineBreaker(LineBreakerFactory.newLineBreaker(12));
            }
            SelectionData sd = new SelectionData(2);
            sd.setContextHelpAvailable(false);
            sd.setStandardEastWestArray(box);
            sd.setStandardNorthSouthArray();
            box.setSelectionData(sd);
        } else {
            int leftHS = mantissaLength + exponent;
            int rightHS = displayPrecision >= 0 ? displayPrecision + 1 : mantissaLength;
            int lpad = 0;
            int rpad = 0;
            if (exponent < 0 && Math.abs(exponent) > mantissaLength) {
                lpad = 1;
                rpad = Math.abs(exponent) - mantissaLength;
            }
            if (mantissaLength < leftHS) {
                int i = 0;
                while (i < leftHS - mantissaLength) {
                    strMantissa = String.valueOf(strMantissa) + "0";
                    ++i;
                }
            }
            if ((floats = FloatTemplate.buildFloatString(floats, strMantissa, lpad, rpad, leftHS, rightHS)).toString().indexOf(".") == -1) {
                if (displayPrecision <= 0) {
                    floats.append(".");
                } else {
                    StringBuffer postZeros = new StringBuffer();
                    postZeros.append(".");
                    int i = 1;
                    while (i <= displayPrecision) {
                        postZeros.append("0");
                        ++i;
                    }
                    floats.append(postZeros);
                }
            }
            box = NotationLayoutBox.createCustomBox(f, floats.toString(), 4);
            box.setLineBreaker(LineBreakerFactory.newLineBreaker(3));
            SelectionData sd = new SelectionData(2);
            sd.setContextHelpAvailable(false);
            sd.setStandardEastWestArray(box);
            sd.setStandardNorthSouthArray();
            box.setSelectionData(sd);
        }
        return box;
    }

    public static StringBuffer buildFloatString(StringBuffer floats, String mantissa, int lprepad, int rprepad, int leftHandSide, int rightHandSide) {
        char[] mantChars = mantissa.toCharArray();
        int mantLength = mantChars.length;
        int pos = 0;
        int i = 0;
        while (i < lprepad) {
            floats.append("0");
            ++i;
        }
        while (pos < leftHandSide) {
            floats.append(mantChars[pos]);
            ++pos;
        }
        if (mantLength != leftHandSide) {
            floats.append(".");
            i = 0;
            while (i < rprepad) {
                floats.append("0");
                ++i;
            }
            while (pos < rightHandSide) {
                if (pos >= mantLength) {
                    floats.append("0");
                } else if (pos == rightHandSide - 1 && mantChars.length > rightHandSide) {
                    String charnum = "" + mantChars[pos + 1];
                    int numval = Integer.parseInt(charnum);
                    if (numval > 4) {
                        String newcnum = "" + mantChars[pos];
                        int newval = Integer.parseInt(newcnum);
                        if (++newval == 10) {
                            floats.append(0);
                            int index = floats.length() - 2;
                            while (index > -1) {
                                if (floats.charAt(index) == '.' && index > 0) {
                                    --index;
                                } else if (floats.charAt(index) == '.') {
                                    floats.insert(0, "0");
                                }
                                newval = Integer.parseInt(floats.substring(index, index + 1));
                                if (++newval != 10) {
                                    String val = String.valueOf(newval);
                                    floats.replace(index, index + 1, val);
                                    break;
                                }
                                if (index == 0) {
                                    floats.insert(0, "10");
                                } else {
                                    floats.setCharAt(index, '0');
                                }
                                --index;
                            }
                        } else {
                            floats.append(newval);
                        }
                    } else {
                        floats.append(mantChars[pos]);
                    }
                } else {
                    floats.append(mantChars[pos]);
                }
                ++pos;
            }
        }
        if (floats.charAt(0) == '.') {
            floats.insert(0, '0');
        }
        if (floats.indexOf("-.") == 0) {
            floats.insert(1, '0');
        }
        return floats;
    }

    public static int calculateExponent(Dag exp) {
        int exponent = 0;
        try {
            exponent = Integer.parseInt(exp.getData());
            exponent = exp.getType() == 1 ? exponent * -1 : exponent;
        }
        catch (Exception e) {
            exponent = 0;
        }
        return exponent;
    }
}

