/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.template;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.template.BracketTemplate;
import com.maplesoft.client.prettyprinter.template.SpecialFunctionTemplate;

public class InfixNotationTemplate
implements SpecialFunctionTemplate {
    private int notationID;
    private int precedence;
    private String keyword;
    private int minSize;
    private int maxSize;
    private double leftBearing;
    private double rightBearing;
    private boolean precedenceGreaterEqual = false;

    public InfixNotationTemplate(String keyword, int notationID, int precedence, int minSize, int maxSize) {
        this(keyword, notationID, precedence, minSize, maxSize, 0.0, 0.0, false);
    }

    public InfixNotationTemplate(String keyword, int notationID, int precedence, int minSize, int maxSize, double leftBearing, double rightBearing) {
        this(keyword, notationID, precedence, minSize, maxSize, leftBearing, rightBearing, false);
    }

    public InfixNotationTemplate(String keyword, int notationID, int precedence, int minSize, int maxSize, double leftBearing, double rightBearing, boolean precedenceGreaterEqual) {
        this.keyword = keyword;
        this.notationID = notationID;
        this.precedence = precedence;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.leftBearing = leftBearing;
        this.rightBearing = rightBearing;
        this.precedenceGreaterEqual = precedenceGreaterEqual;
    }

    @Override
    public LayoutBox apply(LayoutFormatter f, Dag function, Dag[] args) {
        InfixLayoutBox box = null;
        if (args != null && args.length >= this.minSize && args.length <= this.maxSize) {
            box = new InfixLayoutBox(f, this.keyword, this.notationID, args, this.precedence, this.leftBearing, this.rightBearing, this.precedenceGreaterEqual);
        }
        return box;
    }

    static class InfixLayoutBox
    extends InlineLayoutBox {
        InfixLayoutBox(LayoutFormatter f, String keyword, int notationID, Dag[] args, int precedence, double leftBearing, double rightBearing, boolean precedenceGreaterEqual) {
            super(args.length * 2 - 1);
            LayoutBox first = DagBuilder.createLayout(f, args[0]);
            first = BracketTemplate.apply(f, first, args[0], precedence, precedenceGreaterEqual ? 0 : 1);
            this.addChild(first);
            int i = 1;
            while (i < args.length) {
                this.addChild(this.buildNotation(f, keyword, notationID, first, leftBearing, rightBearing));
                LayoutBox next = DagBuilder.createLayout(f, args[i]);
                next = BracketTemplate.apply(f, next, args[i], precedence, precedenceGreaterEqual ? 0 : 1);
                next.applyLayout();
                this.addChild(next);
                ++i;
            }
        }

        InfixLayoutBox() {
        }

        public NotationLayoutBox buildNotation(LayoutFormatter f, String keyword, int notationID, LayoutBox left, double lb, double rb) {
            NotationLayoutBox notation = null;
            notation = f.isInProc() ? f.createNotationBox(174, keyword, 2) : NotationLayoutBox.createNotationBox(f, notationID);
            if (notation.getHeight() == 0.0) {
                notation.setSize(7.0, f.getFontHeight(1));
                if (f.getFontHeight(1) != 1.0) {
                    notation.setBaseline(notation.getHeight());
                }
            }
            notation.setLeftSideBearing(lb * f.getBearingMultiplier());
            notation.setRightSideBearing(rb * f.getBearingMultiplier());
            return notation;
        }
    }
}

