/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.template;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.prettyprinter.AbstractBranchLayoutBox;
import com.maplesoft.client.prettyprinter.AncestorArrayLayoutBox;
import com.maplesoft.client.prettyprinter.DefaultLayoutBox;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutAnchor;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.LayoutVector;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.ResizableNotationBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreaker;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import com.maplesoft.client.prettyprinter.selection.StandardSelectionData;
import com.maplesoft.client.prettyprinter.template.SpecialFunctionTemplate;

public class IntegralTemplate
implements SpecialFunctionTemplate {
    private static final float INTEGRAND_BASELINE_ADJUST_FACTOR = 0.8f;
    private static final SelectionData integralSD = new StandardSelectionData(4);
    public static final int LOCATION_OF_INTEGRAL_IN_ANCESTOR = 0;
    public static final int LOCATION_OF_FUNCTION_IN_INTEGRAL = 2;
    private static final LayoutAnchor INTEGRAL_FROM_ANCHOR;
    private static final LayoutAnchor INTEGRAL_TO_ANCHOR;

    static {
        integralSD.setContextHelpAvailable(false);
        INTEGRAL_FROM_ANCHOR = new LayoutAnchor(0, new LayoutVector(0.5, 0.9), 1, new LayoutVector(0.0, 0.0), 3);
        INTEGRAL_TO_ANCHOR = new LayoutAnchor(0, new LayoutVector(1.1, 0.2), 2, new LayoutVector(0.0, 1.0), 3);
    }

    @Override
    public LayoutBox apply(LayoutFormatter formatter, Dag function, Dag[] args) {
        IntegralLayoutBox box = null;
        if (args != null && args.length >= 2 && !formatter.isInProc()) {
            Dag eval = args[1];
            Dag var = null;
            Dag from = null;
            Dag to = null;
            boolean fail = false;
            int[] vpath = new int[]{1, 1};
            if (eval.getType() == 20) {
                var = eval.getChild(0);
                Dag range = eval.getChild(1);
                if (range.getType() != 35) {
                    fail = true;
                } else {
                    from = range.getChild(0);
                    to = range.getChild(1);
                    int[] nArray = new int[3];
                    nArray[0] = 1;
                    nArray[1] = 1;
                    int[] tmppath = nArray;
                    vpath = tmppath;
                }
            } else {
                var = eval;
                int[] tmppath = new int[]{1, 1};
                vpath = tmppath;
            }
            LayoutBox[] nameArgs = null;
            if (args.length > 3) {
                nameArgs = new LayoutBox[args.length - 2];
                int i = 2;
                while (i < args.length) {
                    if (args[i].getType() != 8) {
                        fail = true;
                        break;
                    }
                    nameArgs[i - 2] = DagBuilder.createLayout(formatter, args[i]);
                    ++i;
                }
            }
            if (!fail) {
                LayoutBox functionBox = DagBuilder.createLayout(formatter, args[0]);
                functionBox.applyLayout();
                int[] nArray = new int[2];
                nArray[0] = 1;
                int[] fpath = nArray;
                functionBox = AncestorArrayLayoutBox.wrapWithAncestorData(functionBox, function, fpath);
                InlineLayoutBox varBox = new InlineLayoutBox();
                StandardSelectionData varBoxSD = new StandardSelectionData(1);
                varBox.setSelectionData(varBoxSD);
                NotationLayoutBox dBox = NotationLayoutBox.createCustomBox(formatter, "d");
                dBox.setSelectionData(integralSD);
                varBox.addChild(dBox);
                LayoutBox ivarBox = DagBuilder.createLayout(formatter, var);
                ivarBox = AncestorArrayLayoutBox.wrapWithAncestorData(ivarBox, function, vpath);
                varBox.addChild(ivarBox);
                varBox.setDag(varBox.getChild(1).getDag());
                int integralConstraint = IntegralTemplate.isFunctionBoxAnIntegral(functionBox) ? 5 : 0;
                ResizableNotationBox integralSign = new ResizableNotationBox(formatter, 97, integralConstraint, functionBox){

                    @Override
                    public double getBaseline() {
                        double bl = super.getBaseline();
                        return bl;
                    }
                };
                integralSign.setBaselineAdjustment(true);
                integralSign.setSelectionData(integralSD);
                this.adjustForImageGlyphs(formatter, integralSign);
                AbstractBranchLayoutBox integralBox = null;
                if (from != null && to != null) {
                    integralBox = new DefaultLayoutBox(3);
                    integralBox.addChild(integralSign);
                    formatter.incSuperscriptCount();
                    LayoutBox fromBox = DagBuilder.createLayout(formatter, from);
                    int[] nArray2 = new int[4];
                    nArray2[0] = 1;
                    nArray2[1] = 1;
                    nArray2[2] = 1;
                    int[] frpath = nArray2;
                    fromBox = AncestorArrayLayoutBox.wrapWithAncestorData(fromBox, function, frpath);
                    LayoutBox toBox = DagBuilder.createLayout(formatter, to);
                    int[] topath = new int[]{1, 1, 1, 1};
                    toBox = AncestorArrayLayoutBox.wrapWithAncestorData(toBox, function, topath);
                    integralBox.addChild(fromBox);
                    integralBox.addChild(toBox);
                    formatter.decSuperscriptCount();
                    integralBox.addLayoutAnchor(INTEGRAL_FROM_ANCHOR);
                    integralBox.addLayoutAnchor(INTEGRAL_TO_ANCHOR);
                    int[] NStraversal = new int[6];
                    NStraversal[5] = -10;
                    NStraversal[2] = -10;
                    NStraversal[0] = -10;
                    NStraversal[1] = 0;
                    NStraversal[3] = 2;
                    NStraversal[4] = 1;
                    SelectionData integralBoxSD = new SelectionData(1);
                    integralBoxSD.setStandardEastWestArray(integralBox);
                    integralBoxSD.setTraversalNorthSouth(NStraversal);
                    integralBox.setSelectionData(integralBoxSD);
                    this.adjustForImageGlyphs(formatter, integralSign);
                } else {
                    integralBox = new InlineLayoutBox(1);
                    integralBox.addChild(integralSign);
                }
                box = new IntegralLayoutBox(integralBox, NotationLayoutBox.createNotationBox(formatter, 76), functionBox, NotationLayoutBox.createNotationBox(formatter, 76), varBox);
                if (nameArgs != null) {
                    int i = 0;
                    while (i < nameArgs.length) {
                        box.addChild(NotationLayoutBox.createNotationBox(formatter, 14));
                        box.addChild(nameArgs[i]);
                        ++i;
                    }
                }
            }
        }
        return box;
    }

    public static LayoutBox findLastConsecutiveIntegralBox(LayoutBox constraint1) {
        LayoutBox box = null;
        if (IntegralTemplate.isFunctionBoxAnIntegral(constraint1) && IntegralTemplate.isFunctionBoxAnIntegral((box = constraint1).getChild(0).getChild(2))) {
            box = IntegralTemplate.findLastConsecutiveIntegralBox(box.getChild(0).getChild(2));
        }
        return box;
    }

    public static boolean isFunctionBoxAnIntegral(LayoutBox b) {
        boolean result = false;
        if (b != null && b.numChildren() > 0) {
            result = b.getChild(0) instanceof IntegralLayoutBox;
        }
        return result;
    }

    private void adjustForImageGlyphs(LayoutFormatter f, LayoutBox box) {
    }

    static class IntegralLayoutBox
    extends InlineLayoutBox {
        private static LineBreaker lb = LineBreakerFactory.newLineBreaker(14);

        IntegralLayoutBox(LayoutBox integral, LayoutBox notation, LayoutBox func, LayoutBox notation_two, LayoutBox var) {
            super(5);
            this.addChild(integral);
            this.addChild(notation);
            this.addChild(func);
            this.addChild(notation_two);
            this.addChild(var);
        }

        IntegralLayoutBox() {
        }

        @Override
        public void setLineBreaker(LineBreaker l) {
        }

        @Override
        public LineBreaker getLineBreaker() {
            return lb;
        }
    }
}

