/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.template;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.prettyprinter.DefaultLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutAnchor;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.MatrixLayoutBox;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.ResizableNotationBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import com.maplesoft.client.prettyprinter.selection.StandardSelectionData;
import com.maplesoft.client.prettyprinter.template.BracketTemplate;
import com.maplesoft.client.prettyprinter.template.SpecialFunctionTemplate;

public class MatrixTemplate
implements SpecialFunctionTemplate {
    @Override
    public LayoutBox apply(LayoutFormatter formatter, Dag function, Dag[] args) {
        LayoutBox box = null;
        if (args != null) {
            if (args.length == 1 && args[0].getType() == 30) {
                box = this.buildMatrix(formatter, args);
            } else if (args.length >= 2 && args[0].getType() == 30 && args[1].getType() == 30) {
                boolean field;
                Dag coeff = args[0];
                Dag bases = args[1];
                Dag option = null;
                if (args.length > 2) {
                    option = args[2];
                }
                String optionName = option != null ? DagBuilder.lPrint(option) : null;
                boolean bl = field = optionName != null ? optionName.equals("\"field\"") : false;
                if (coeff.getLength() == bases.getLength()) {
                    box = this.buildBasisVector(formatter, coeff, bases, field);
                }
            }
        }
        return box;
    }

    public LayoutBox buildMatrix(LayoutFormatter formatter, Dag[] args) {
        LayoutBox box = null;
        boolean error = false;
        boolean numeric = true;
        int row = 0;
        int col = 0;
        Dag rows = args[0];
        int numRows = rows.getLength();
        int cols = -1;
        row = 0;
        while (row < numRows) {
            Dag childRow = rows.getChild(row);
            if (childRow.getType() != 30) {
                error = true;
                break;
            }
            if (cols > 0 && childRow.getLength() != cols) {
                error = true;
                break;
            }
            if (cols < 0) {
                cols = childRow.getLength();
            }
            ++row;
        }
        if (!error) {
            LayoutBox firstChild = null;
            box = new MatrixLayoutBox(numRows, cols, 1);
            if (numRows > 1) {
                ((MatrixLayoutBox)box).setBaselineFudgeFactor(formatter.getFontHeight(1) / 2.0);
            } else {
                ((MatrixLayoutBox)box).setBaselineFudgeFactor(formatter.getFontHeight(1) / 6.0);
            }
            row = 0;
            while (row < numRows) {
                Dag childRow = rows.getChild(row);
                col = 0;
                while (col < cols) {
                    StandardSelectionData elementSD = new StandardSelectionData(4);
                    LayoutBox child = DagBuilder.createLayout(formatter, childRow.getChild(col));
                    child.setSelectionData(elementSD);
                    box.addChild(child);
                    LayoutBox layoutBox = firstChild = firstChild == null ? child : firstChild;
                    if (numeric && !DagUtil.isNumeric(childRow.getChild(col))) {
                        numeric = false;
                    }
                    ++col;
                }
                ++row;
            }
            ((MatrixLayoutBox)box).setJustification(numeric ? 2 : 1);
            ((MatrixLayoutBox)box).setSeparators(formatter.getRowSeparator(), formatter.getColumnSeparator());
            box.applyLayout();
            if (numRows == 1) {
                box.setBaseline(firstChild.getBaseline());
            } else if (box.getHeight() > formatter.getFontHeight(0)) {
                box.setBaseline(box.getHeight() / 2.0);
            }
            if (box.numChildren() > 0) {
                SelectionData sd = new SelectionData(2);
                int[] NStraversal = new int[numRows * cols + 1];
                int i = 0;
                while (i < cols) {
                    int j = 0;
                    while (j < numRows) {
                        NStraversal[j + i * numRows] = i + j * cols;
                        ++j;
                    }
                    NStraversal[numRows * (i + 1)] = -10;
                    ++i;
                }
                sd.setTraversalNorthSouth(NStraversal);
                sd.setStandardEastWestArray(box);
                box.setSelectionData(sd);
            }
            box = BracketTemplate.apply(formatter, box, 95, 96);
            box.applyLayout();
            if (box.getWidth() < formatter.getSafeBreakWidth()) {
                box.setLineBreaker(LineBreakerFactory.newLineBreaker(5));
            } else {
                box = DagBuilder.createLayout(formatter, args[0]);
            }
        }
        return box;
    }

    public LayoutBox buildBasisVector(LayoutFormatter formatter, Dag coeff, Dag bases, boolean field) {
        Dag term = null;
        DefaultLayoutBox box = new DefaultLayoutBox("BasisVector");
        int length = coeff.getLength();
        int i = 0;
        while (i < length) {
            term = coeff.getChild(i);
            if (term.getType() == 30) {
                term = term.getChild(0);
            }
            this.addBasisVectorTerm(formatter, box, term, bases.getChild(i), field);
            ++i;
        }
        if (box.numChildren() == 0) {
            box.addChild(NotationLayoutBox.createCustomBox(formatter, "0 "));
            box.addChild(this.createBasisVectorCoordinate(formatter, bases.getChild(0), field));
            box.addLayoutAnchor(LayoutAnchor.INLINE_01);
        }
        SelectionData sd = new SelectionData(1);
        sd.setStandardNorthSouthArray();
        sd.setStandardEastWestArray(box);
        box.setSelectionData(sd);
        return box;
    }

    public void addBasisVectorTerm(LayoutFormatter formatter, LayoutBox parent, Dag term, Dag coord, boolean field) {
        boolean positive = true;
        LayoutBox box = null;
        if (term.getType() == 29) {
            term = term.getChild(0);
        }
        boolean simpleSum = false;
        if (term.getType() == 16 && term.getLength() == 2) {
            simpleSum = true;
        }
        if (DagUtil.isOne(term)) {
            box = this.createBasisVectorCoordinate(formatter, coord, field);
        } else if (DagUtil.isMinusOne(term)) {
            box = this.createBasisVectorCoordinate(formatter, coord, field);
            positive = false;
        } else if (!DagUtil.isZero(term)) {
            if (parent.numChildren() > 0) {
                if (DagUtil.isNegative(term)) {
                    term = DagUtil.negate(term);
                    positive = false;
                } else if (simpleSum && DagUtil.isNegative(term.getChild(1))) {
                    Dag[] kids = new Dag[]{term.getChild(0), DagUtil.negate(term.getChild(1))};
                    term = Dag.createDag(16, kids, null, false);
                    positive = false;
                }
            }
            box = new DefaultLayoutBox("Term");
            LayoutBox termBox = DagBuilder.createLayout(formatter, term);
            if (!simpleSum) {
                termBox = BracketTemplate.apply(formatter, termBox, term, 4);
            }
            box.addChild(termBox);
            box.addChild(NotationLayoutBox.createNotationBox(formatter, 76));
            box.addChild(this.createBasisVectorCoordinate(formatter, coord, field));
            box.addLayoutAnchor(LayoutAnchor.INLINE_01);
            box.addLayoutAnchor(LayoutAnchor.INLINE_12);
        }
        if (box != null) {
            int size = parent.numChildren();
            if (size != 0) {
                NotationLayoutBox sign = NotationLayoutBox.createNotationBox(formatter, positive ? 1 : 2);
                parent.addChild(sign);
            } else if (size == 0 && !positive) {
                parent.addChild(NotationLayoutBox.createNotationBox(formatter, 24));
            }
            parent.addChild(box);
            while (size < parent.numChildren()) {
                if (size > 0) {
                    parent.addLayoutAnchor(LayoutAnchor.createLeftToRightAnchor(size - 1));
                }
                ++size;
            }
        }
    }

    public LayoutBox createBasisVectorCoordinate(LayoutFormatter formatter, Dag coord, boolean field) {
        DefaultLayoutBox box = new DefaultLayoutBox("Coordinate");
        NotationLayoutBox eBox = NotationLayoutBox.createCustomBox(formatter, "e");
        box.addChild(eBox);
        formatter.incSuperscriptCount();
        if (coord.getType() == 7) {
            box.addChild(NotationLayoutBox.createCustomBox(formatter, coord.getData()));
        } else {
            box.addChild(DagBuilder.createLayout(formatter, coord));
        }
        formatter.decSuperscriptCount();
        box.addLayoutAnchor(LayoutAnchor.SUBSCRIPT_10);
        if (field) {
            ResizableNotationBox overbar = new ResizableNotationBox(formatter, 105, 1, eBox);
            box.addChild(overbar);
            box.addLayoutAnchor(LayoutAnchor.UNDER_02);
        }
        return box;
    }
}

