/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.template;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.client.dag.ProcDagFactory;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.ProcLayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.selection.StandardSelectionData;
import com.maplesoft.client.prettyprinter.template.BracketTemplate;

public class ProcTemplate {
    private static final String TERMINATE = ";";
    private static final String DCOLON_OPERATOR = "::";
    public static final int PARAM_SEQ = 0;
    public static final int LOCAL_SEQ = 1;
    public static final int OPTION_SEQ = 2;
    public static final int REMEMBER_TABLE = 3;
    public static final int STATEMENT_SEQ = 4;
    public static final int DESCRIPTION_SEQ = 5;
    public static final int GLOBAL_SEQ = 6;
    public static final int LEXICAL_SEQ = 7;
    public static final String[] KEYWORDS = new String[]{"", "local ", "option ", "", "", "description ", "global ", ""};

    public static LayoutBox apply(LayoutFormatter formatter, Dag dag) {
        ProcLayoutBox box = new ProcLayoutBox();
        int length = dag.getLength();
        LayoutBox[] boxes = new LayoutBox[length + 1];
        formatter.setInOperatorProc(false);
        boolean operatorProc = false;
        boolean arrow = false;
        boolean builtin = false;
        boolean hidden = false;
        int verboseProc = ProcDagFactory.getVerbosity();
        boolean longForm = ProcDagFactory.useLongForm();
        NotationLayoutBox start = NotationLayoutBox.createNotationBox(formatter, 36);
        int i = 0;
        while (i < length) {
            boxes[i] = new InlineLayoutBox();
            Dag child = dag.getChild(i);
            switch (i) {
                case 0: {
                    ProcTemplate.processParamChild(formatter, boxes, start, dag);
                    break;
                }
                case 2: {
                    if (child == null || child.getLength() <= 0) break;
                    boxes[i] = KeywordListSubTemplate.apply(formatter, child, KEYWORDS[2]);
                    int childLength = child.getLength();
                    int j = 0;
                    while (j < childLength) {
                        if (child.getChild(j).getType() == 8) {
                            String optionName = child.getChild(j).getData();
                            if (optionName.equals("operator")) {
                                operatorProc = formatter.getProcCount() <= 1;
                                formatter.setInOperatorProc(operatorProc);
                            } else if (optionName.startsWith("arrow")) {
                                arrow = true;
                            } else if (optionName.startsWith("Copyright")) {
                                builtin = true;
                            }
                        }
                        ++j;
                    }
                    break;
                }
                case 1: 
                case 5: 
                case 6: {
                    if (child == null || child.getLength() <= 0) break;
                    boxes[i] = KeywordListSubTemplate.apply(formatter, child, KEYWORDS[i]);
                    break;
                }
                case 4: {
                    if (operatorProc &= child.getType() != 46) {
                        formatter.decProcCount();
                    } else if (verboseProc == 0 || verboseProc == 1 && builtin) {
                        formatter.setInOperatorProc(operatorProc);
                        hidden = true;
                    }
                    if (hidden) {
                        boxes[i] = NotationLayoutBox.createNotationBox(formatter, 18);
                    } else {
                        int childType = child.getType();
                        if (childType != 46 && (child.getLength() != 0 || childType != 29)) {
                            LayoutBox singleStatement = DagBuilder.createLayout(formatter, child);
                            if (childType != 34 && childType != 42 && childType != 49 && childType != 43 && child.getData() != null) {
                                InlineLayoutBox temp = new InlineLayoutBox(2);
                                temp.addChild(singleStatement);
                                singleStatement = temp;
                            }
                            boxes[i] = singleStatement;
                        } else {
                            boxes[i] = DagBuilder.createLayout(formatter, child);
                        }
                    }
                    if (!operatorProc) break;
                    formatter.incProcCount();
                }
            }
            ++i;
        }
        if (operatorProc && arrow) {
            Dag child = dag.getChild(0);
            if (child != null && child.getLength() == 1) {
                box.addChild(DagBuilder.createLayout(formatter, child.getChild(0)));
            } else {
                box.addChild(boxes[0]);
            }
            box.addChild(NotationLayoutBox.createNotationBox(formatter, 25));
            box.addChild(boxes[4]);
            box.setSelectionData(new StandardSelectionData(2));
            return box;
        }
        NotationLayoutBox end = NotationLayoutBox.createNotationBox(formatter, longForm ? 71 : 37);
        InlineLayoutBox firstLine = new InlineLayoutBox();
        firstLine.addChild(start);
        firstLine.addChild(boxes[0]);
        if (ProcDagFactory.hasReturnType(dag)) {
            Dag returnDag = dag.getChild(length - 1);
            NotationLayoutBox oper = NotationLayoutBox.createCustomBox(formatter, DCOLON_OPERATOR);
            LayoutBox returnType = DagBuilder.createLayout(formatter, returnDag);
            firstLine.addChild(oper);
            firstLine.addChild(returnType);
            firstLine.addChild(ProcTemplate.createSemiColon(formatter));
        }
        ProcTemplate.addBox(box, firstLine, formatter);
        if (boxes[1].numChildren() > 1 && !hidden) {
            ProcTemplate.addBox(box, boxes[1], formatter);
        }
        if (boxes[2].numChildren() > 1 && !hidden) {
            ProcTemplate.addBox(box, boxes[2], formatter);
        }
        if (boxes[5].numChildren() > 1 && !hidden) {
            ProcTemplate.addBox(box, boxes[5], formatter);
        }
        if (boxes[6].numChildren() > 1 && !hidden) {
            ProcTemplate.addBox(box, boxes[6], formatter);
        }
        if (boxes[4] != null) {
            ProcIndentLayoutBox statements = new ProcIndentLayoutBox(boxes[4]);
            ProcTemplate.addBox(box, statements, formatter);
        }
        InlineLayoutBox tend = new InlineLayoutBox(2);
        tend.addChild(end);
        tend.addChild(ProcTemplate.createSemiColon(formatter));
        box.addChild(tend);
        box.setSelectionData(new StandardSelectionData(2));
        box.setLineBreaker(LineBreakerFactory.newLineBreaker(16));
        return box;
    }

    private static void processParamChild(LayoutFormatter formatter, LayoutBox[] boxes, LayoutBox start, Dag dag) {
        Dag child = dag.getChild(0);
        LayoutBox paramList = new InlineLayoutBox();
        Dag params = DagUtil.formatProcParams(dag);
        if (params != null) {
            paramList = DagBuilder.createLayout(formatter, params);
        } else if (child != null && child.getLength() > 0) {
            paramList = DagBuilder.createLayout(formatter, child);
        }
        LayoutBox bracketedParams = BracketTemplate.apply(formatter, start, paramList);
        boxes[0].addChild(bracketedParams);
    }

    public static LayoutBox createSemiColon(LayoutFormatter formatter) {
        return formatter.createNotationBox(174, TERMINATE, 1);
    }

    protected static void addBox(LayoutBox parent, LayoutBox child, LayoutFormatter formatter) {
        parent.addChild(child);
        ProcTemplate.addNeededDelimiter(formatter, parent);
    }

    public static LayoutBox layoutStatement(LayoutFormatter f, Dag statement) {
        return new ProcIndentLayoutBox(DagBuilder.createLayout(f, statement));
    }

    public static void addNeededDelimiter(LayoutFormatter f, LayoutBox b) {
        ProcTemplate.findDelimiter(b, true);
        b.addChild(new ProcDelimiter(f));
    }

    private static boolean findDelimiter(LayoutBox b, boolean removeDelimiter) {
        boolean found = false;
        if (b.numChildren() > 0) {
            LayoutBox c = b.getChild(b.numChildren() - 1);
            if (c instanceof ProcDelimiter) {
                found = true;
                b.removeChild(b.numChildren() - 1);
            } else {
                found = ProcTemplate.findDelimiter(c, removeDelimiter);
            }
        }
        return found;
    }

    public static class KeywordListSubTemplate {
        public static LayoutBox apply(LayoutFormatter formatter, Dag dag, String keyword) {
            InlineLayoutBox result = new InlineLayoutBox();
            LayoutBox localList = DagBuilder.createLayout(formatter, dag);
            result.addChild(formatter.createNotationBox(174, keyword, 2));
            result.addChild(localList);
            result.addChild(formatter.createNotationBox(174, ProcTemplate.TERMINATE, 1));
            return result;
        }
    }

    public static class ProcDelimiter
    extends InlineLayoutBox {
        public ProcDelimiter(LayoutFormatter formatter) {
            this.addChild(NotationLayoutBox.createCustomBox(formatter, " "));
        }
    }

    public static class ProcIndentLayoutBox
    extends InlineLayoutBox {
        public ProcIndentLayoutBox(LayoutBox box) {
            this.addChild(box);
        }
    }
}

