/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.template;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.FunctionDagFactory;
import com.maplesoft.client.prettyprinter.DefaultLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutAnchor;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.LayoutVector;
import com.maplesoft.client.prettyprinter.ResizableNotationBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import com.maplesoft.client.prettyprinter.selection.StandardSelectionData;
import com.maplesoft.client.prettyprinter.template.SpecialFunctionTemplate;

public class RootTemplate
implements SpecialFunctionTemplate {
    private static SelectionData sd;

    @Override
    public LayoutBox apply(LayoutFormatter formatter, Dag function, Dag[] args) {
        LayoutBox b = new RootLayoutBox();
        if (args != null && args.length > 0) {
            b = RootTemplate.applyRoot(b, formatter, args[0]);
            b.applyLayout();
            if (b.getWidth() > formatter.getSafeBreakWidth()) {
                b = FunctionDagFactory.createGenericLayout(formatter, function);
            }
        }
        return b;
    }

    public static LayoutBox apply(LayoutBox b, LayoutFormatter formatter, Dag powerDag) {
        int length;
        if (!(b instanceof RootLayoutBox)) {
            RootLayoutBox childB = new RootLayoutBox();
            b.addChild(childB);
            b = childB;
        }
        if ((length = powerDag.getLength()) != 2) {
            return null;
        }
        b = RootTemplate.applyRoot(b, formatter, powerDag.getChild(0));
        b.applyLayout();
        if (b.getWidth() > formatter.getSafeBreakWidth()) {
            Dag[] expseqArgs = new Dag[1];
            Dag[] functionArgs = new Dag[2];
            expseqArgs[0] = powerDag.getChild(0);
            Dag expSeq = Dag.createDag(29, expseqArgs, null, false);
            functionArgs[0] = Dag.createDag(8, null, "sqrt", false);
            functionArgs[1] = expSeq;
            Dag functionDag = Dag.createDag(18, functionArgs, null, false);
            b = FunctionDagFactory.createGenericLayout(formatter, functionDag);
        }
        return b;
    }

    public static LayoutBox applyRoot(LayoutBox b, LayoutFormatter formatter, Dag baseDag) {
        LayoutBox base = DagBuilder.createLayout(formatter, baseDag);
        ResizableNotationBox root = new ResizableNotationBox(formatter, 99, 2, base, base);
        if (sd == null) {
            sd = new StandardSelectionData(4);
            sd.setContextHelpAvailable(false);
        }
        root.setSelectionData(sd);
        b.addChild(root);
        b.addChild(base);
        b.addLayoutAnchor(new LayoutAnchor(0, LayoutVector.SOUTHEAST, 1, LayoutVector.SOUTHEAST));
        int[] nArray = new int[2];
        nArray[1] = 1;
        int[] traverseEW = nArray;
        SelectionData boxSD = new SelectionData(1);
        boxSD.setFirstCaretPosition(0);
        boxSD.setLastCaretPosition(1);
        boxSD.setStandardNorthSouthArray();
        boxSD.setTraversalEastWest(traverseEW);
        b.setSelectionData(boxSD);
        b.setRightSideBearing(2.0 * formatter.getBearingMultiplier());
        b.setLineBreaker(LineBreakerFactory.newLineBreaker(5));
        return b;
    }

    public static class RootLayoutBox
    extends DefaultLayoutBox {
        public RootLayoutBox() {
            super("sqrt", 2);
        }

        @Override
        protected LayoutBox getReferenceForBaseline() {
            return this.getChild(1);
        }
    }
}

