/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.template;

import com.maplesoft.client.dag.BranchDag;
import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.PowerDagFactory;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import com.maplesoft.client.prettyprinter.selection.StandardSelectionData;
import com.maplesoft.client.prettyprinter.template.BracketTemplate;
import com.maplesoft.client.prettyprinter.template.SpecialFunctionTemplate;

public class SeriesTemplate
implements SpecialFunctionTemplate {
    private static final SelectionData orderSD = new StandardSelectionData(2);

    static {
        orderSD.setContextHelpAvailable(false);
    }

    @Override
    public LayoutBox apply(LayoutFormatter formatter, Dag function, Dag[] args) {
        SeriesLayoutBox box = null;
        if (args != null && args.length == 3) {
            Dag sum = args[0];
            Dag base = args[1];
            Dag power = args[2];
            Dag term = base;
            if (new Integer(power.getData()) != 1) {
                term = PowerDagFactory.create(base, power);
            }
            LayoutBox termBox = DagBuilder.createLayout(formatter, term);
            termBox = BracketTemplate.apply(formatter, termBox, term, -1);
            SeriesOrderLayoutBox orderBox = new SeriesOrderLayoutBox(NotationLayoutBox.createCustomBox(formatter, "O"), termBox);
            orderBox.setSelectionData(orderSD);
            box = sum instanceof BranchDag && ((BranchDag)sum).getLength() > 0 ? new SeriesLayoutBox(DagBuilder.createLayout(formatter, sum), NotationLayoutBox.createNotationBox(formatter, 1), orderBox) : new SeriesLayoutBox(DagBuilder.createLayout(formatter, sum), orderBox);
            box.setSelectionData(new StandardSelectionData(2));
        }
        return box;
    }

    static class SeriesLayoutBox
    extends InlineLayoutBox {
        SeriesLayoutBox(LayoutBox series, LayoutBox notation, LayoutBox order) {
            super(3);
            this.addChild(series);
            this.addChild(notation);
            this.addChild(order);
        }

        SeriesLayoutBox(LayoutBox series, LayoutBox order) {
            super(2);
            this.addChild(series);
            this.addChild(order);
        }

        SeriesLayoutBox() {
        }
    }

    static class SeriesOrderLayoutBox
    extends InlineLayoutBox {
        SeriesOrderLayoutBox(LayoutBox notation, LayoutBox term) {
            super(2);
            this.addChild(notation);
            this.addChild(term);
            this.setLineBreaker(LineBreakerFactory.newLineBreaker(5));
        }

        SeriesOrderLayoutBox() {
        }
    }
}

