/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.template;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreaker;
import com.maplesoft.client.prettyprinter.linebreaker.LineBreakerFactory;
import com.maplesoft.client.prettyprinter.template.ProcTemplate;

public class StatementSeqTemplate {
    public static LayoutBox apply(LayoutFormatter formatter, Dag dag) {
        StatementSeqLayoutBox box = null;
        int length = dag.getLength();
        if (length > 0) {
            box = new StatementSeqLayoutBox();
            int n = 0;
            while (n < length) {
                boolean applyTerminator = true;
                StatementSeqRowLayoutBox row = new StatementSeqRowLayoutBox();
                row.addChild(DagBuilder.createLayout(formatter, dag.getChild(n)));
                int type = dag.getChild(n).getType();
                if (type == 34 || type == 42 || type == 49 || type == 43) {
                    applyTerminator = false;
                }
                if (applyTerminator) {
                    row.addChild(ProcTemplate.createSemiColon(formatter));
                }
                if (n > 0) {
                    ProcTemplate.addNeededDelimiter(formatter, box);
                }
                box.addChild(new ProcTemplate.ProcIndentLayoutBox(row));
                ++n;
            }
        }
        return box;
    }

    public static class StatementSeqLayoutBox
    extends InlineLayoutBox {
        private static LineBreaker lb = LineBreakerFactory.newLineBreaker(16);

        @Override
        public void setLineBreaker(LineBreaker l) {
        }

        @Override
        public LineBreaker getLineBreaker() {
            return lb;
        }
    }

    public static class StatementSeqRowLayoutBox
    extends InlineLayoutBox {
    }
}

