/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.client.prettyprinter.template;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.prettyprinter.AbstractBranchLayoutBox;
import com.maplesoft.client.prettyprinter.DefaultLayoutBox;
import com.maplesoft.client.prettyprinter.InlineLayoutBox;
import com.maplesoft.client.prettyprinter.LayoutAnchor;
import com.maplesoft.client.prettyprinter.LayoutBox;
import com.maplesoft.client.prettyprinter.LayoutFormatter;
import com.maplesoft.client.prettyprinter.NotationLayoutBox;
import com.maplesoft.client.prettyprinter.selection.SelectionData;
import com.maplesoft.client.prettyprinter.selection.StandardSelectionData;
import com.maplesoft.client.prettyprinter.template.BracketTemplate;

public class SubScriptTemplate {
    private static SelectionData braceSD = null;

    public static LayoutBox apply(LayoutFormatter formatter, Dag dag) {
        AbstractBranchLayoutBox box = null;
        if (dag.getLength() > 1) {
            box = new DefaultLayoutBox(2);
            Dag name = dag.getChild(0);
            Dag index = dag.getChild(1);
            if (formatter.useInLine(dag) || formatter.isInProc()) {
                if (braceSD == null) {
                    braceSD = new StandardSelectionData(2);
                    braceSD.setContextHelpAvailable(false);
                }
                LayoutBox left = DagBuilder.createLayout(formatter, name);
                left = BracketTemplate.apply(formatter, left, name, 2);
                NotationLayoutBox lBrace = NotationLayoutBox.createNotationBox(formatter, 22);
                NotationLayoutBox rBrace = NotationLayoutBox.createNotationBox(formatter, 23);
                lBrace.setSelectionData(braceSD);
                rBrace.setSelectionData(braceSD);
                box = new InlineSubScriptLayoutBox(left, lBrace, DagBuilder.createLayout(formatter, index), rBrace);
            } else {
                LayoutBox left = DagBuilder.createLayout(formatter, name);
                left = BracketTemplate.apply(formatter, left, name, 2);
                box.addChild(left);
                formatter.incSuperscriptCount();
                box.addChild(DagBuilder.createLayout(formatter, index));
                formatter.decSuperscriptCount();
                box.addLayoutAnchor(LayoutAnchor.SUBSCRIPT_10);
                SelectionData sd = new SelectionData(1);
                sd.setStandardNorthSouthArray();
                sd.setStandardEastWestArray(box);
                box.setSelectionData(sd);
            }
        }
        return box;
    }

    static class InlineSubScriptLayoutBox
    extends InlineLayoutBox {
        InlineSubScriptLayoutBox(LayoutBox left, LayoutBox lBrace, LayoutBox index, LayoutBox rBrace) {
            super(4);
            this.addChild(left);
            this.addChild(lBrace);
            this.addChild(index);
            this.addChild(rBrace);
        }

        InlineSubScriptLayoutBox() {
        }
    }
}

