/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import com.maplesoft.mathdoc.components.WmiComponent;
import com.maplesoft.mathdoc.components.WmiComponentUtil;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Dimension;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class WmiAsyncProgressIndicator
extends JLabel
implements WmiComponent {
    private static final String[] PROGRESS_IMAGES = new String[]{"com/maplesoft/mathdoc/components/resources/progress/default/dot10.png", "com/maplesoft/mathdoc/components/resources/progress/default/dot09.png", "com/maplesoft/mathdoc/components/resources/progress/default/dot08.png", "com/maplesoft/mathdoc/components/resources/progress/default/dot07.png", "com/maplesoft/mathdoc/components/resources/progress/default/dot06.png", "com/maplesoft/mathdoc/components/resources/progress/default/dot05.png", "com/maplesoft/mathdoc/components/resources/progress/default/dot04.png", "com/maplesoft/mathdoc/components/resources/progress/default/dot03.png", "com/maplesoft/mathdoc/components/resources/progress/default/dot02.png", "com/maplesoft/mathdoc/components/resources/progress/default/dot01.png", "com/maplesoft/mathdoc/components/resources/progress/default/dot00.png", "com/maplesoft/mathdoc/components/resources/progress/default/dot01.png", "com/maplesoft/mathdoc/components/resources/progress/default/dot02.png", "com/maplesoft/mathdoc/components/resources/progress/default/dot03.png", "com/maplesoft/mathdoc/components/resources/progress/default/dot04.png", "com/maplesoft/mathdoc/components/resources/progress/default/dot05.png", "com/maplesoft/mathdoc/components/resources/progress/default/dot06.png", "com/maplesoft/mathdoc/components/resources/progress/default/dot07.png", "com/maplesoft/mathdoc/components/resources/progress/default/dot08.png", "com/maplesoft/mathdoc/components/resources/progress/default/dot09.png"};
    private static final String STATIC_PROGRESS_IMAGE = "com/maplesoft/mathdoc/components/resources/progress/default/static.png";
    private static final String[] MAC_PROGRESS_IMAGES = new String[]{"com/maplesoft/mathdoc/components/resources/progress/mac/spinner00.png", "com/maplesoft/mathdoc/components/resources/progress/mac/spinner01.png", "com/maplesoft/mathdoc/components/resources/progress/mac/spinner02.png", "com/maplesoft/mathdoc/components/resources/progress/mac/spinner03.png", "com/maplesoft/mathdoc/components/resources/progress/mac/spinner04.png", "com/maplesoft/mathdoc/components/resources/progress/mac/spinner05.png", "com/maplesoft/mathdoc/components/resources/progress/mac/spinner06.png", "com/maplesoft/mathdoc/components/resources/progress/mac/spinner07.png", "com/maplesoft/mathdoc/components/resources/progress/mac/spinner08.png", "com/maplesoft/mathdoc/components/resources/progress/mac/spinner09.png", "com/maplesoft/mathdoc/components/resources/progress/mac/spinner10.png", "com/maplesoft/mathdoc/components/resources/progress/mac/spinner11.png"};
    private static final String MAC_STATIC_PROGRESS_IMAGE = "com/maplesoft/mathdoc/components/resources/progress/mac/static.png";
    private static final String[] MAC_TEXTURED_PROGRESS_IMAGES = new String[]{"com/maplesoft/mathdoc/components/resources/progress/mac_t/spinner00.png", "com/maplesoft/mathdoc/components/resources/progress/mac_t/spinner01.png", "com/maplesoft/mathdoc/components/resources/progress/mac_t/spinner02.png", "com/maplesoft/mathdoc/components/resources/progress/mac_t/spinner03.png", "com/maplesoft/mathdoc/components/resources/progress/mac_t/spinner04.png", "com/maplesoft/mathdoc/components/resources/progress/mac_t/spinner05.png", "com/maplesoft/mathdoc/components/resources/progress/mac_t/spinner06.png", "com/maplesoft/mathdoc/components/resources/progress/mac_t/spinner07.png", "com/maplesoft/mathdoc/components/resources/progress/mac_t/spinner08.png", "com/maplesoft/mathdoc/components/resources/progress/mac_t/spinner09.png", "com/maplesoft/mathdoc/components/resources/progress/mac_t/spinner10.png", "com/maplesoft/mathdoc/components/resources/progress/mac_t/spinner11.png"};
    private static final String MAC_TEXTURED_STATIC_PROGRESS_IMAGE = "com/maplesoft/mathdoc/components/resources/progress/mac_t/static.png";
    private ImageIcon staticStateIcon = null;
    private Vector progressImageVector;
    private int imageIndex;
    private Timer updateTimer = null;
    private WmiProgressUpdater updater = null;
    private WmiProgressImageUpdater swapper = new WmiProgressImageUpdater();

    public WmiAsyncProgressIndicator() {
        this.progressImageVector = new Vector();
        if (RuntimePlatform.isMac()) {
            if (this.isTexturedWindow()) {
                this.loadImageTable(MAC_TEXTURED_STATIC_PROGRESS_IMAGE, MAC_TEXTURED_PROGRESS_IMAGES);
            } else {
                this.loadImageTable(MAC_STATIC_PROGRESS_IMAGE, MAC_PROGRESS_IMAGES);
            }
        } else {
            this.loadImageTable(STATIC_PROGRESS_IMAGE, PROGRESS_IMAGES);
        }
        this.imageIndex = this.progressImageVector.size();
        this.updateTimer = new Timer(true);
    }

    public void release() {
        try {
            this.updateTimer.cancel();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateTimer = null;
    }

    public WmiAsyncProgressIndicator(int width, int height) {
        this();
        this.setPreferredSize(new Dimension(width, height));
    }

    protected boolean isTexturedWindow() {
        String brushMetalLook;
        boolean windowIsTextured = false;
        if (RuntimePlatform.isMac() && (brushMetalLook = System.getProperty("apple.awt.brushMetalLook")) != null) {
            windowIsTextured = Boolean.valueOf(brushMetalLook);
        }
        return windowIsTextured;
    }

    protected boolean loadImageTable(String staticState, String[] progressImages) {
        boolean loadSuccessful = true;
        if (staticState != null) {
            this.staticStateIcon = WmiComponentUtil.getImageIcon(staticState);
            if (this.staticStateIcon != null) {
                this.setPreferredSize(new Dimension(this.staticStateIcon.getIconWidth(), this.staticStateIcon.getIconHeight()));
            } else {
                loadSuccessful = false;
            }
        }
        int i = 0;
        while (i < progressImages.length && loadSuccessful) {
            ImageIcon nextImage = WmiComponentUtil.getImageIcon(progressImages[i]);
            if (nextImage != null) {
                this.progressImageVector.add(nextImage);
            } else {
                loadSuccessful = false;
            }
            ++i;
        }
        this.stop();
        return loadSuccessful;
    }

    public void start() {
        this.imageIndex = 0;
        this.update();
    }

    public void start(int interval) {
        if (this.updater == null) {
            this.updater = new WmiProgressUpdater();
            this.updateTimer.schedule((TimerTask)this.updater, 0L, (long)interval);
        }
    }

    public void update() {
        ++this.imageIndex;
        if (this.imageIndex >= this.progressImageVector.size()) {
            this.imageIndex = 0;
        }
        SwingUtilities.invokeLater(this.swapper);
    }

    public void stop() {
        if (this.updater != null) {
            this.updater.cancel();
            this.updater = null;
        }
        if (this.staticStateIcon != null) {
            this.setIcon(this.staticStateIcon);
        }
        this.imageIndex = 0;
    }

    @Override
    public void dispose() {
        this.stop();
        this.updateTimer = null;
        this.progressImageVector.clear();
        this.progressImageVector = null;
        this.swapper = null;
    }

    private class WmiProgressImageUpdater
    implements Runnable {
        private WmiProgressImageUpdater() {
        }

        @Override
        public void run() {
            WmiAsyncProgressIndicator.this.setIcon((ImageIcon)WmiAsyncProgressIndicator.this.progressImageVector.get(WmiAsyncProgressIndicator.this.imageIndex));
            WmiAsyncProgressIndicator.this.paintImmediately(WmiAsyncProgressIndicator.this.getBounds());
        }
    }

    private class WmiProgressUpdater
    extends TimerTask {
        private WmiProgressUpdater() {
        }

        @Override
        public void run() {
            WmiAsyncProgressIndicator.this.update();
        }
    }
}

