/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import com.maplesoft.mathdoc.components.WmiComponent;
import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.controller.WmiDataActionEvent;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class WmiComboBox
extends JComboBox
implements WmiComponent {
    protected WmiCommand boxCmd = null;
    private boolean ignoreSelectionChange = false;
    private ItemListener myListener = null;

    public WmiComboBox(Object[] items, WmiCommand cmd) {
        super(items);
        this.initializeComboBox(cmd);
    }

    public WmiComboBox(ComboBoxModel aModel, WmiCommand cmd) {
        super(aModel);
        this.initializeComboBox(cmd);
    }

    public WmiComboBox(Vector items, WmiCommand cmd) {
        super(items);
        this.initializeComboBox(cmd);
    }

    public WmiComboBox(WmiCommand cmd) {
        this.initializeComboBox(cmd);
    }

    protected void initializeComboBox(WmiCommand cmd) {
        this.boxCmd = cmd;
        if (RuntimePlatform.isMac()) {
            ListCellRenderer lcr = this.getRenderer();
            MacComboBoxRenderer mcbr = new MacComboBoxRenderer(lcr);
            this.setRenderer(mcbr);
        }
        this.setEditable(false);
        this.myListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && !WmiComboBox.this.ignoreSelectionChange) {
                    WmiComboBox.this.invokeCommand(e, e.getItem());
                }
            }
        };
        this.addItemListener(this.myListener);
    }

    @Override
    public void processKeyEvent(KeyEvent e) {
        boolean isEnterKey;
        boolean bl = isEnterKey = e.getKeyCode() == 10;
        if (!isEnterKey) {
            this.ignoreSelectionChange = true;
        }
        super.processKeyEvent(e);
        this.ignoreSelectionChange = false;
        if (isEnterKey) {
            this.invokeCommand(e, this.getItemAt(this.getSelectedIndex()));
        }
    }

    public boolean isIgnoreSelectionChange() {
        return this.ignoreSelectionChange;
    }

    public void setIgnoreSelectionChange(boolean ignoreSelectionChange) {
        this.ignoreSelectionChange = ignoreSelectionChange;
    }

    protected void invokeCommand(EventObject evt, Object value) {
        if (this.boxCmd != null) {
            Object evtSrc = null;
            if (evt != null) {
                evtSrc = evt.getSource();
            }
            WmiDataActionEvent cmdEvt = new WmiDataActionEvent(evtSrc, 0, null, value);
            this.boxCmd.actionPerformed(cmdEvt);
            WmiMathDocumentView view = WmiMathDocumentView.getActiveDocumentView();
            if (view != null) {
                view.requestFocus();
            }
        }
    }

    @Override
    public void dispose() {
        if (this.myListener != null) {
            this.removeItemListener(this.myListener);
            this.myListener = null;
        }
        this.boxCmd = null;
    }

    private class MacComboBoxRenderer
    implements ListCellRenderer {
        private ListCellRenderer wrappedRenderer = null;

        public MacComboBoxRenderer(ListCellRenderer lcr) {
            this.wrappedRenderer = lcr;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JComponent c = (JComponent)this.wrappedRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            String valueString = "<empty>";
            if (value != null) {
                valueString = value instanceof String ? (String)value : value.toString();
            }
            Dimension d = new Dimension(valueString.length() * 8, 18);
            c.setMaximumSize(d);
            c.setPreferredSize(d);
            return c;
        }
    }
}

