/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import com.maplesoft.mathdoc.components.WmiContextManager;
import com.maplesoft.mathdoc.components.WmiContextualMenu;
import com.maplesoft.mathdoc.components.WmiMathMLEditorButtonMenu;
import com.maplesoft.mathdoc.controller.WmiMenu;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.util.WmiResourcePackage;
import com.maplesoft.mathdoc.view.WmiMathMLEditorDocumentView;
import com.maplesoft.mathdoc.view.WmiSelection;
import com.maplesoft.mathdoc.view.WmiView;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

public class WmiMathMLContextMenuManager
extends WmiContextManager {
    public static final String CONTEXT_RESOURCES = "com.maplesoft.mathdoc.components.resources.palette.Palette";
    public static final String CONTEXT_MENUS = "contextMenus";
    public static final String MATHML_EDITOR_MENU = "MathMLEditorContextMenu";
    private static final String RESOURCES = "com/maplesoft/mathdoc/components/resources/palette/";
    private Hashtable tagToMenu = new Hashtable();
    private boolean popupEnabled = true;

    public WmiMathMLContextMenuManager(WmiMathMLEditorDocumentView documentView) {
        this(3, documentView, false);
    }

    public WmiMathMLContextMenuManager(int menuAlignment, WmiMathMLEditorDocumentView documentView, boolean extendedPalette) {
        this.constructContextMenu(menuAlignment, documentView, extendedPalette, "");
    }

    public WmiMathMLContextMenuManager(int menuAlignment, WmiMathMLEditorDocumentView documentView, String menuXML) {
        this.constructContextMenu(menuAlignment, documentView, false, menuXML);
    }

    private void constructContextMenu(int menuAlignment, WmiMathMLEditorDocumentView documentView, boolean extendedPalette, String menuXML) {
        WmiResourcePackage resourcePackage = WmiResourcePackage.getResourcePackage(CONTEXT_RESOURCES);
        String contextMenuList = resourcePackage.getStringForKey(CONTEXT_MENUS);
        if (contextMenuList != null) {
            StringTokenizer tokens = new StringTokenizer(contextMenuList);
            while (tokens.hasMoreTokens()) {
                String menuName = tokens.nextToken();
                if (menuName.trim().length() <= 0) continue;
                WmiModelTag tag = null;
                if (menuName.equals(MATHML_EDITOR_MENU)) {
                    WmiMathMLEditorButtonMenu editorMenu = new WmiMathMLEditorButtonMenu(menuName, CONTEXT_RESOURCES, RESOURCES, menuAlignment, documentView, true, extendedPalette, menuXML);
                    tag = WmiModelUtil.getTagForString(editorMenu.getModelTagString());
                    if (tag == null) continue;
                    this.tagToMenu.put(tag, editorMenu);
                    continue;
                }
                WmiContextualMenu contextMenu = new WmiContextualMenu(menuName, CONTEXT_RESOURCES);
                tag = WmiModelUtil.getTagForString(contextMenu.getModelTagString());
                if (tag == null) continue;
                this.tagToMenu.put(tag, contextMenu);
            }
        }
    }

    @Override
    public WmiContextualMenu getMenuForModel(WmiModel model) {
        WmiModelTag tag = model.getTag();
        WmiContextualMenu answer = (WmiContextualMenu)this.tagToMenu.get(tag);
        return answer;
    }

    @Override
    public void popupRequestNotification(WmiView view, MouseEvent e) {
        if (!this.popupEnabled) {
            return;
        }
        WmiMathMLEditorDocumentView srcDoc = (WmiMathMLEditorDocumentView)view;
        WmiSelection activeSelection = srcDoc.getSelection();
        this.setContextForDocument(srcDoc);
        WmiMenu activeMenu = this.getActiveContextualMenu();
        if (activeMenu == null) {
            this.buildMenu();
            activeMenu = this.getActiveContextualMenu();
        }
        if (activeMenu != null) {
            if (activeMenu instanceof WmiMathMLEditorButtonMenu) {
                ((WmiMathMLEditorButtonMenu)activeMenu).show(srcDoc, e.getX(), e.getY());
            } else {
                JPopupMenu menu = activeMenu.getPopupMenu();
                activeMenu.setSelected(true);
                menu.show(srcDoc, e.getX(), e.getY());
            }
            this.setContextForDocument(srcDoc);
        }
    }

    public void setPopupEnabled(boolean enabled) {
        this.popupEnabled = enabled;
    }

    public void popdownMenu() {
        WmiMenu activeMenu = this.getActiveContextualMenu();
        if (activeMenu != null && activeMenu instanceof WmiMathMLEditorButtonMenu) {
            ((WmiMathMLEditorButtonMenu)activeMenu).hide();
        }
    }

    protected void addCommonMenuElements(JMenu menu) {
    }

    @Override
    protected void removeCommonMenuElements(JMenu menu) {
    }
}

