/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import com.maplesoft.applets.GlassPaneListener;
import com.maplesoft.mathdoc.components.WmiContextualMenu;
import com.maplesoft.mathdoc.components.WmiMathMLMenuParser;
import com.maplesoft.mathdoc.components.palettes.WmiMathMLEditorPalette;
import com.maplesoft.mathdoc.components.palettes.WmiMathMLEditorPaletteManager;
import com.maplesoft.mathdoc.components.palettes.WmiMathMLPaletteButtonFactory;
import com.maplesoft.mathdoc.controller.WmiMenu;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorDictionary;
import com.maplesoft.mathdoc.util.WmiResourcePackage;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import com.maplesoft.mathdoc.view.WmiMathMLEditorDocumentView;
import com.maplesoft.util.WmiMathEntityNameMapper;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class WmiMathMLEditorButtonMenu
extends WmiContextualMenu {
    public static final String BUTTON_PREFERRED_WIDTH_PROPERTY = "button.preferred.width";
    public static final String BUTTON_PREFERRED_HEIGHT_PROPERTY = "button.preferred.height";
    public static final int DEFAULT_BUTTON_WIDTH = 50;
    public static final int DEFAULT_BUTTON_HEIGHT = 40;
    private WmiMathMLEditorPaletteManager paletteManager;
    protected static WmiMathMLPaletteButtonFactory buttonFactory = null;
    protected AbstractButton activeMenuItem = null;
    protected JWindow activePaletteWindow = null;
    protected SubMenuGlassPane activePaletteGlassPane = null;
    protected Container activePaletteContentPane = null;
    protected boolean activePaletteWindowJustShown = false;
    protected WmiMathMLEditorButtonMenu activeMenu = null;
    protected AbstractButton activeButton = null;
    public WmiMathMLButtonMenuPanel buttonPanel;
    public JWindow buttonMenuWindow = null;
    public JWindow buttonSubmenuWindow = null;
    private boolean menuOpenMode = false;
    public boolean buildForToolbar = false;
    public int buttonWidth;
    public int buttonHeight;
    private WmiMathDocumentView view;
    private AbstractButton currentTopMenuItem = null;
    private WmiMathMLEditorButtonMenu parentMenu = null;
    private WmiMathMLEditorButtonMenu childMenu = null;
    private ArrayList actionControllerCallerList = new ArrayList();

    static {
        buttonFactory = new WmiMathMLPaletteButtonFactory();
    }

    public WmiMathMLEditorButtonMenu(String name, String resources, String resourcePath, int menuAlignment, WmiMathMLEditorDocumentView documentView, boolean usePalettes, boolean extendedPalette, String menuXML) {
        super(name, resources, resourcePath, extendedPalette, menuXML);
        this.view = documentView;
        try {
            this.buttonWidth = Integer.parseInt(this.getMenuResourceBundle().getStringForKey(BUTTON_PREFERRED_WIDTH_PROPERTY));
            this.buttonHeight = Integer.parseInt(this.getMenuResourceBundle().getStringForKey(BUTTON_PREFERRED_HEIGHT_PROPERTY));
        }
        catch (Exception e) {
            this.buttonWidth = 50;
            this.buttonHeight = 40;
        }
        this.buttonPanel = new WmiMathMLButtonMenuPanel();
        BoxLayout layout = new BoxLayout(this.buttonPanel, menuAlignment);
        this.buttonPanel.setLayout(layout);
        this.paletteManager = new WmiMathMLEditorPaletteManager(extendedPalette);
        if (usePalettes && menuXML.equals("")) {
            this.createPalettes();
        }
        this.paletteManager.setView(documentView);
    }

    public void setParentMenu(WmiMathMLEditorButtonMenu menu) {
        this.parentMenu = menu;
    }

    public void setChildMenu(WmiMathMLEditorButtonMenu menu) {
        this.childMenu = menu;
    }

    public void setButtonWidth(int width) {
        this.buttonWidth = width;
    }

    public String getImageResourcePath() {
        return this.imageResourcePath;
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.buttonPanel.removeAll();
    }

    @Override
    protected void buildMenu() {
        if (this.buildForToolbar || this.buttonMenuWindow != null) {
            if (this.menuXML.equals("")) {
                WmiMathMLEditorButtonMenu.buildMenu(this.menuKey, this);
            } else {
                this.buildMenu(this.menuKey, this, this.menuXML, (WmiMathMLEditorDocumentView)this.view);
            }
        }
    }

    protected static void buildMenu(String name, WmiMenu destMenu) {
        String itemString = destMenu.getMenuElementKeys(name);
        if (itemString != null) {
            StringTokenizer tokens = new StringTokenizer(itemString);
            while (tokens.hasMoreTokens()) {
                String subKeys;
                String curToken = tokens.nextToken();
                String itemName = destMenu.getItemNameForKey(String.valueOf(name) + "." + curToken);
                if (itemName == null) {
                    itemName = curToken;
                }
                if ((subKeys = destMenu.getMenuElementKeys(String.valueOf(name) + "." + curToken)) != null) continue;
                ((WmiMathMLEditorButtonMenu)destMenu).createMenuItem(itemName);
            }
        }
    }

    protected void buildMenu(String name, WmiMenu destMenu, String menuXML, WmiMathMLEditorDocumentView view) {
        WmiMathMLMenuParser parser = new WmiMathMLMenuParser(destMenu, menuXML, view);
        parser.parse();
    }

    private JWindow createJWindowWithSharedOwner(Component toShare) {
        Window parent = (Window)SwingUtilities.getAncestorOfClass(Window.class, toShare);
        JWindow jwindow = null;
        if (parent instanceof Dialog) {
            jwindow = new JWindow(parent);
        } else if (parent instanceof Frame) {
            jwindow = new JWindow((Frame)parent);
        } else {
            throw new IllegalArgumentException("component has no window");
        }
        jwindow.setFocusableWindowState(false);
        return jwindow;
    }

    protected void createMenuItem(String itemName) {
        String iconName = this.getIconNameForKey(itemName);
        AbstractButton menuItem = buttonFactory.createButton(this.imageResourcePath, iconName, true, 0, 0);
        menuItem.setPreferredSize(new Dimension(this.buttonWidth, this.buttonHeight));
        this.buttonPanel.addMenuItem(menuItem);
        WmiMathMLEditorPalette palette = null;
        palette = this.paletteManager.getPaletteByName(itemName);
        if (palette != null) {
            WmiMathMLButtonListener listener = new WmiMathMLButtonListener(menuItem, palette, this);
            menuItem.addActionListener(listener);
            menuItem.addMouseListener(listener);
        }
    }

    protected AbstractButton createMenuItem(WmiMathMLEditorPalette palette, WmiResourcePackage resources, String buttonLabel, boolean useMathML) {
        palette.setMenu(this);
        AbstractButton menuItem = null;
        String iconName = this.getIconNameForKey(buttonLabel);
        if (iconName != null) {
            menuItem = buttonFactory.createButton(this.imageResourcePath, iconName, !useMathML, this.buttonWidth, this.buttonHeight);
        } else {
            String twoDMathInsertProperty = resources.getStringForKey(String.valueOf(buttonLabel) + ".insert.2dmath");
            String mathml = "";
            if (twoDMathInsertProperty != null) {
                mathml = twoDMathInsertProperty;
                menuItem = buttonFactory.createButton(twoDMathInsertProperty, !useMathML, this.buttonWidth, this.buttonHeight);
            } else if (WmiMathEntityNameMapper.getUnicodeCharacter(buttonLabel) != '\u0000') {
                mathml = WmiMathOperatorDictionary.isNameForOperator("&" + buttonLabel + ";") ? "<mrow><mo>&" + buttonLabel + ";" + "</mo></mrow>" : "<mrow><mi>&" + buttonLabel + ";" + "</mi></mrow>";
                menuItem = buttonFactory.createButton(mathml, !useMathML, this.buttonWidth, this.buttonHeight);
            } else {
                mathml = WmiMathOperatorDictionary.isNameForOperator(buttonLabel) ? "<mrow><mo>" + buttonLabel + "</mo></mrow>" : "<mrow><mi>" + buttonLabel + "</mi></mrow>";
                menuItem = buttonLabel.length() == 1 ? buttonFactory.createButton(buttonLabel.charAt(0), !useMathML) : buttonFactory.createButton(mathml, !useMathML, this.buttonWidth, this.buttonHeight);
            }
            if (useMathML) {
                palette.getInsert2DMathList().add(mathml);
            }
        }
        return menuItem;
    }

    protected void createMenuItemButton(String buttonLabel, WmiResourcePackage resources, String tooltip) {
        WmiMathMLEditorPalette palette = (WmiMathMLEditorPalette)this.paletteManager.createEmptyPalette(buttonLabel);
        AbstractButton menuItem = this.createMenuItem(palette, resources, buttonLabel, true);
        menuItem.setToolTipText(tooltip);
        palette.getButtonToIndex().put(menuItem, new Integer(0));
        WmiMathMLEditorPalette.MathMLActionControllerCaller actionControllerCaller = palette.new WmiMathMLEditorPalette.MathMLActionControllerCaller();
        this.actionControllerCallerList.add(actionControllerCaller);
        WmiMathMLButtonListener listener = new WmiMathMLButtonListener(menuItem, palette, this);
        menuItem.addMouseListener(listener);
        this.buttonPanel.addMenuItem(menuItem);
    }

    protected WmiMathMLEditorPalette createMenuButton(String buttonLabel, WmiResourcePackage resources, String tooltip) {
        WmiMathMLEditorPalette palette = (WmiMathMLEditorPalette)this.paletteManager.createEmptyPalette(buttonLabel);
        this.currentTopMenuItem = this.createMenuItem(palette, resources, buttonLabel, false);
        if (this.currentTopMenuItem.getIcon() == null) {
            this.buttonPanel.addMenuItem(this.currentTopMenuItem);
        } else {
            this.buttonPanel.add(this.currentTopMenuItem);
        }
        if (tooltip != null && !tooltip.trim().equals("")) {
            this.currentTopMenuItem.setToolTipText(tooltip);
        }
        if (palette != null) {
            if (this.buttonMenuWindow == null) {
                this.buttonMenuWindow = this.createJWindowWithSharedOwner(this.paletteManager.getView());
            }
            WmiMathMLButtonListener listener = new WmiMathMLButtonListener(this.currentTopMenuItem, palette, this);
            this.currentTopMenuItem.addActionListener(listener);
            this.currentTopMenuItem.addMouseListener(listener);
        }
        return palette;
    }

    protected void replacePaletteWithMenu(WmiMathMLEditorButtonMenu menu, WmiMathMLEditorDocumentView view) {
        if (this.currentTopMenuItem != null) {
            MouseListener[] listeners = this.currentTopMenuItem.getMouseListeners();
            int i = 0;
            while (i < listeners.length) {
                if (listeners[i] instanceof WmiMathMLButtonListener) {
                    ((WmiMathMLButtonListener)listeners[i]).setMenu(menu, view);
                }
                ++i;
            }
        }
        menu.buttonMenuWindow = null;
        menu.setParentMenu(this);
        this.setChildMenu(menu);
    }

    private void createPalettes() {
        if (this.paletteManager != null) {
            List paletteNames = this.paletteManager.getPaletteNames();
            int i = 0;
            while (i < paletteNames.size()) {
                this.paletteManager.createPalette(paletteNames.get(i).toString(), null);
                ++i;
            }
        }
    }

    public String getIconNameForKey(String key) {
        return this.getMenuResourceBundle().getStringForKey(String.valueOf(key) + ".icon");
    }

    @Override
    public WmiContextualMenu copyMenu() {
        WmiMathMLEditorButtonMenu answer = null;
        try {
            answer = (WmiMathMLEditorButtonMenu)this.clone();
            if (answer != null) {
                answer.removeAll();
                answer.buildMenu();
            }
        }
        catch (CloneNotSupportedException e) {
            WmiErrorLog.log(e);
        }
        return answer;
    }

    public void show(WmiMathDocumentView view, int x, int y) {
        this.view = view;
        if (this.buttonMenuWindow == null) {
            this.buttonMenuWindow = this.createJWindowWithSharedOwner(view);
            if (this.buttonPanel.getComponentCount() == 0) {
                this.buildMenu();
            }
            this.buttonMenuWindow.getContentPane().add(this.buttonPanel);
        }
        Point p = view.getLocationOnScreen();
        this.buttonMenuWindow.setLocation(p.x + x, p.y + y);
        this.buttonMenuWindow.pack();
        this.buttonMenuWindow.setVisible(true);
        this.buttonMenuWindow.toFront();
        this.buttonMenuWindow.setGlassPane(new SubMenuGlassPane());
        this.buttonMenuWindow.getGlassPane().setVisible(true);
    }

    public void showSubmenu(WmiMathDocumentView view, int x, int y) {
        this.view = view;
        if (this.buttonSubmenuWindow != null) {
            this.buttonSubmenuWindow.setVisible(false);
            this.buttonSubmenuWindow.dispose();
        }
        this.buttonSubmenuWindow = this.createJWindowWithSharedOwner(view);
        this.buttonSubmenuWindow.getContentPane().add(this.buttonPanel);
        Point p = view.getLocationOnScreen();
        this.buttonSubmenuWindow.setLocation(x, y);
        this.buttonSubmenuWindow.pack();
        this.buttonSubmenuWindow.setVisible(true);
        this.buttonSubmenuWindow.toFront();
    }

    @Override
    public void hide() {
        boolean buttonWindowExists = false;
        if (this.buttonSubmenuWindow != null) {
            this.buttonSubmenuWindow.setVisible(false);
            this.buttonSubmenuWindow.dispose();
            this.buttonSubmenuWindow = null;
            buttonWindowExists = true;
        }
        if (this.buttonMenuWindow != null) {
            this.buttonMenuWindow.setVisible(false);
            this.buttonMenuWindow.dispose();
            this.buttonMenuWindow = null;
            buttonWindowExists = true;
        }
        if (this.menuOpenMode) {
            this.activeMenu.hide();
        }
        if (buttonWindowExists && this.parentMenu != null) {
            this.parentMenu.activeMenuItem = null;
            this.parentMenu.activeButton = null;
        }
        this.hidePaletteWindow();
        this.menuOpenMode = false;
        this.activeButton = null;
        this.activeMenuItem = null;
        this.paletteManager.getView().requestFocusInWindow();
    }

    public void hidePaletteWindow() {
        if (this.activePaletteWindow != null) {
            this.activePaletteWindow.setVisible(false);
            this.activePaletteWindow.dispose();
            this.activePaletteWindow = null;
            this.activePaletteGlassPane = null;
            this.activePaletteContentPane = null;
            this.activePaletteWindowJustShown = false;
            this.activeMenuItem = null;
            this.activeButton = null;
        }
    }

    public void hideSubmenu() {
        boolean buttonWindowExists = false;
        if (this.buttonMenuWindow != null) {
            this.buttonMenuWindow.setVisible(false);
            this.buttonMenuWindow.dispose();
            this.buttonMenuWindow = null;
            buttonWindowExists = true;
        }
        if (this.menuOpenMode) {
            this.activeMenu.hide();
        }
        this.hidePaletteWindow();
        this.menuOpenMode = false;
        this.activeButton = null;
        this.activeMenuItem = null;
        this.paletteManager.getView().requestFocusInWindow();
    }

    public void setActivePaletteWindow(JWindow active) {
        this.activePaletteWindow = active;
    }

    public WmiMathMLEditorPalette.MathMLActionControllerCaller findControllerCaller(AbstractButton button) {
        int i = 0;
        while (i < this.actionControllerCallerList.size()) {
            WmiMathMLEditorPalette.MathMLActionControllerCaller caller = (WmiMathMLEditorPalette.MathMLActionControllerCaller)this.actionControllerCallerList.get(i);
            if (caller.handlesButton(button)) {
                return caller;
            }
            ++i;
        }
        return null;
    }

    public boolean isActivePaletteWindowJustShown() {
        return this.activePaletteWindowJustShown;
    }

    public void setActivePaletteWindowJustShown(boolean activePaletteWindowJustShown) {
        this.activePaletteWindowJustShown = activePaletteWindowJustShown;
    }

    public WmiMathMLEditorButtonMenu getParentMenu() {
        return this.parentMenu;
    }

    public AbstractButton getActiveMenuItem() {
        return this.activeMenuItem;
    }

    public void setActiveMenuItem(AbstractButton activeMenuItem) {
        this.activeMenuItem = activeMenuItem;
    }

    public AbstractButton getActiveButton() {
        return this.activeButton;
    }

    public void setActiveButton(AbstractButton activeButton) {
        this.activeButton = activeButton;
    }

    public WmiMathMLEditorButtonMenu getActiveMenu() {
        return this.activeMenu;
    }

    public void setActiveMenu(WmiMathMLEditorButtonMenu activeMenu) {
        this.activeMenu = activeMenu;
    }

    public JWindow getActivePaletteWindow() {
        return this.activePaletteWindow;
    }

    class SubMenuGlassPane
    extends JPanel {
        private static final long serialVersionUID = 1L;

        @Override
        protected void paintComponent(Graphics g) {
        }

        public SubMenuGlassPane() {
            this.setOpaque(false);
        }
    }

    public class WmiMathMLButtonListener
    implements ActionListener,
    MouseListener {
        private AbstractButton menuItem;
        private WmiMathMLEditorButtonMenu menu;
        private WmiMathMLEditorDocumentView view;
        WmiMathMLEditorPalette palette;
        WmiMathMLEditorButtonMenu buttonMenu;

        public WmiMathMLButtonListener(AbstractButton menuItem, WmiMathMLEditorPalette palette, WmiMathMLEditorButtonMenu buttonMenu) {
            this.menuItem = menuItem;
            this.palette = palette;
            this.buttonMenu = buttonMenu;
            this.menu = null;
            this.view = null;
        }

        public void setMenu(WmiMathMLEditorButtonMenu menu, WmiMathMLEditorDocumentView view) {
            this.menu = menu;
            this.view = view;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractButton source = (AbstractButton)e.getSource();
            if (WmiMathMLEditorButtonMenu.this.menuOpenMode && WmiMathMLEditorButtonMenu.this.activeMenu != this.menu) {
                WmiMathMLEditorButtonMenu.this.activeMenu.hide();
            }
            if (this.menu != null) {
                if (e != null) {
                    WmiMathMLEditorButtonMenu.this.activeButton = source;
                    WmiMathMLEditorButtonMenu.this.activePaletteWindowJustShown = true;
                    int x = (int)WmiMathMLEditorButtonMenu.this.activeButton.getLocationOnScreen().getX();
                    int y = (int)WmiMathMLEditorButtonMenu.this.activeButton.getLocationOnScreen().getY();
                    int width = Math.round(WmiMathMLEditorButtonMenu.this.activeButton.getWidth() / 5);
                    int height = WmiMathMLEditorButtonMenu.this.activeButton.getHeight() - 5;
                    this.menu.showSubmenu(this.view, x + width, y + height);
                    WmiMathMLEditorButtonMenu.this.menuOpenMode = true;
                    WmiMathMLEditorButtonMenu.this.activeMenu = this.menu;
                    JWindow w = this.menu.buttonSubmenuWindow;
                    w.setGlassPane(new SubMenuGlassPane());
                    GlassPaneListener l = new GlassPaneListener(this.menu, (SubMenuGlassPane)w.getGlassPane(), w.getContentPane(), "SUBMENU");
                    w.getGlassPane().addMouseListener(l);
                    w.getGlassPane().addMouseMotionListener(l);
                    w.getGlassPane().setVisible(true);
                }
            } else {
                if (WmiMathMLEditorButtonMenu.this.activePaletteWindow != null) {
                    WmiMathMLEditorButtonMenu.this.hidePaletteWindow();
                }
                WmiMathMLEditorButtonMenu.this.activeButton = source;
                WmiMathMLEditorButtonMenu.this.activeMenuItem = this.menuItem;
                WmiMathMLEditorButtonMenu.this.activePaletteWindowJustShown = true;
                WmiMathMLEditorButtonMenu.this.activePaletteWindow = WmiMathMLEditorButtonMenu.this.createJWindowWithSharedOwner(WmiMathMLEditorButtonMenu.this.paletteManager.getView());
                WmiMathMLEditorButtonMenu.this.activePaletteWindow.getContentPane().add(this.palette);
                WmiMathMLEditorButtonMenu.this.activePaletteWindow.pack();
                this.palette.setMenu(this.buttonMenu);
                int x = (int)this.menuItem.getLocationOnScreen().getX();
                int y = (int)this.menuItem.getLocationOnScreen().getY();
                int width = this.menuItem.getWidth();
                int height = this.menuItem.getHeight() - 5;
                WmiMathMLEditorButtonMenu.this.activePaletteWindow.setLocation(x + width / 5, y + height);
                WmiMathMLEditorButtonMenu.this.activePaletteWindow.pack();
                WmiMathMLEditorButtonMenu.this.activePaletteWindow.setVisible(true);
                WmiMathMLEditorButtonMenu.this.activePaletteWindow.toFront();
                WmiMathMLEditorButtonMenu.this.activePaletteWindow.setGlassPane(new SubMenuGlassPane());
                WmiMathMLEditorButtonMenu.this.activePaletteGlassPane = (SubMenuGlassPane)WmiMathMLEditorButtonMenu.this.activePaletteWindow.getGlassPane();
                WmiMathMLEditorButtonMenu.this.activePaletteContentPane = WmiMathMLEditorButtonMenu.this.activePaletteWindow.getContentPane();
                GlassPaneListener l = new GlassPaneListener(this.buttonMenu, WmiMathMLEditorButtonMenu.this.activePaletteGlassPane, WmiMathMLEditorButtonMenu.this.activePaletteContentPane, "PALETTE");
                WmiMathMLEditorButtonMenu.this.activePaletteGlassPane.addMouseListener(l);
                WmiMathMLEditorButtonMenu.this.activePaletteGlassPane.addMouseMotionListener(l);
                WmiMathMLEditorButtonMenu.this.activePaletteGlassPane.setVisible(true);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            WmiMathMLEditorPalette.MathMLActionControllerCaller actionControllerCaller;
            ActionEvent action = new ActionEvent(e.getComponent(), 0, "");
            if (!(e.getComponent() instanceof WmiMathMLPaletteButtonFactory.TopLevelPaletteButton) && (actionControllerCaller = WmiMathMLEditorButtonMenu.this.findControllerCaller((AbstractButton)e.getComponent())) != null) {
                actionControllerCaller.actionPerformed(action);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    public class WmiMathMLButtonMenuPanel
    extends JPanel {
        WmiMathMLButtonMenuPanel() {
        }

        public WmiMathMLEditorPaletteManager getPaletteManager() {
            return WmiMathMLEditorButtonMenu.this.paletteManager;
        }

        public void addMenuItem(AbstractButton b) {
            GridBagLayout gridbag = new GridBagLayout();
            JPanel p = new JPanel(gridbag);
            GridBagConstraints c = gridbag.getConstraints(p);
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            gridbag.setConstraints(b, c);
            p.add(b);
            this.add(p);
        }
    }
}

