/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import com.maplesoft.mathdoc.components.WmiComponent;
import com.maplesoft.mathdoc.util.WmiResourcePackage;
import java.awt.FontMetrics;
import java.text.DecimalFormat;
import java.util.Arrays;
import javax.swing.JTextField;

public class WmiPointProbeField
extends JTextField
implements WmiComponent {
    private static DecimalFormat formatter = new DecimalFormat();
    private static String ERROR_MESSAGE = "Point_Probe_Error";
    private WmiResourcePackage resources;
    private String errorMessage = null;
    private boolean lastUpdateWasError = false;

    private static String formatValue(double value) {
        String formattedString = String.valueOf(value);
        formatter.applyPattern(WmiPointProbeField.getPattern(value));
        formattedString = formatter.format(value);
        return formattedString;
    }

    private static String getPattern(double value) {
        StringBuffer sb = new StringBuffer("0.");
        if (Math.abs(value) != 0.0) {
            int n = 2 - (int)(Math.log(value) / Math.log(10.0));
            int i = 0;
            while (i < Math.min(8, Math.abs(n))) {
                sb.append('#');
                ++i;
            }
        }
        return sb.toString();
    }

    public WmiPointProbeField(String resourceLocation) {
        super(10);
        this.setEditable(false);
        this.resources = WmiResourcePackage.getResourcePackage(resourceLocation);
    }

    public void update2dPoint(double x, double y, boolean showErrorMsg) {
        if (showErrorMsg) {
            if (!this.lastUpdateWasError) {
                this.lastUpdateWasError = true;
                if (this.errorMessage == null) {
                    this.errorMessage = this.resources.getStringForKey(ERROR_MESSAGE);
                }
                this.setText(this.errorMessage);
            }
        } else {
            this.lastUpdateWasError = false;
            String msg = this.createMessage(WmiPointProbeField.formatValue(x), WmiPointProbeField.formatValue(y));
            this.setText(msg);
        }
        this.setCaretPosition(0);
    }

    public void clear() {
        this.setText("");
        this.lastUpdateWasError = false;
    }

    private String createMessage(String x, String y) {
        StringBuffer retVal = new StringBuffer();
        String sep = " , ";
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        int charWidth = metrics.stringWidth("m");
        int maxChars = this.getSize().width / charWidth;
        int maxWidth = (maxChars - sep.length()) / 2;
        retVal.append(this.checkLength(x, maxWidth, false));
        retVal.append(sep);
        retVal.append(this.checkLength(y, maxWidth, true));
        return retVal.toString();
    }

    private String checkLength(String str, int minLength, boolean append) {
        String paddedString = str;
        int len = str.length();
        if (len < minLength) {
            StringBuffer buffer = new StringBuffer(str);
            char[] pad = new char[minLength - len];
            Arrays.fill(pad, ' ');
            if (append) {
                buffer.append(pad);
            } else {
                buffer.insert(0, pad);
            }
            paddedString = buffer.toString();
        }
        return paddedString;
    }

    @Override
    public void dispose() {
        this.errorMessage = null;
        this.resources = null;
    }
}

