/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import com.maplesoft.mathdoc.components.WmiToolBar;
import com.maplesoft.mathdoc.components.WmiToolBarButton;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;

public abstract class WmiScrollableToolBar
extends WmiToolBar
implements ComponentListener {
    private static final long SCROLL_DELAY_TIME = 1000L;
    private static final int SCROLL_SPEED = 4;
    private static String SCROLL_RIGHT_RESOURCE = "com/maplesoft/mathdoc/components/resources/scroll_right.gif";
    private static String SCROLL_LEFT_RESOURCE = "com/maplesoft/mathdoc/components/resources/scroll_left.gif";
    private static String SCROLL_THREAD_NAME = "ToolBar Scroller";
    private static Insets TOOLBAR_INSETS = new Insets(2, 4, 2, 2);
    private JButton m_right = null;
    private JButton m_left = null;
    private boolean holdScroll = false;
    protected int shift = 0;
    private ToolbarScrollerThread scrollThread = null;
    private MouseListener mlstright = null;
    private MouseListener mlstleft = null;
    protected static String VISIBLE_CLIENT_PROP = "__visible";

    public WmiScrollableToolBar(int iconSize, boolean doToolReset, WmiMathDocumentView docView) {
        super(iconSize, docView);
        if (doToolReset) {
            this.resetTools();
        }
    }

    public WmiScrollableToolBar(int iconSize, boolean doToolReset) {
        this(iconSize, doToolReset, WmiMathDocumentView.getActiveDocumentView());
    }

    public WmiScrollableToolBar(int iconSize) {
        this(iconSize, true, WmiMathDocumentView.getActiveDocumentView());
    }

    public WmiScrollableToolBar(boolean doToolReset) {
        this(1, doToolReset, WmiMathDocumentView.getActiveDocumentView());
    }

    public WmiScrollableToolBar() {
        this(1, true, WmiMathDocumentView.getActiveDocumentView());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetTools() {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.commandMap.clear();
            this.toolBarPnl.removeAll();
            this.setToolBarLocked(false);
            this.buildTools();
            this.setToolBarLocked(true);
            this.setFloatable(false);
            if (this.toolBarPnl != null) {
                this.m_right = new WmiToolBarButton(8, SCROLL_RIGHT_RESOURCE);
                this.m_left = new WmiToolBarButton(8, SCROLL_LEFT_RESOURCE);
                this.toolBarPnl.add(this.m_right);
                this.toolBarPnl.add(this.m_left);
                this.mlstright = new Scroller(false);
                this.mlstleft = new Scroller(true);
                this.m_right.addMouseListener(this.mlstright);
                this.m_left.addMouseListener(this.mlstleft);
                this.toolBarPnl.setLayout(new ScrollableToolBarLayout());
                this.add(this.toolBarPnl);
                this.validate();
            }
        }
    }

    public void resetScrollBarTools() {
    }

    protected abstract void buildTools();

    protected void scrollOnce(boolean upDown) {
        this.shift = upDown ? --this.shift : ++this.shift;
        this.toolBarPnl.invalidate();
        this.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseResources() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.m_right != null) {
                this.m_right.removeMouseListener(this.mlstright);
            }
            this.m_right = null;
            if (this.m_left != null) {
                this.m_left.removeMouseListener(this.mlstleft);
            }
            this.m_left = null;
            if (this.scrollThread != null && this.scrollThread.isAlive()) {
                this.scrollThread.cancel();
            }
            this.scrollThread = null;
            super.releaseResources();
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.resizeToolBar();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    protected int getButtonSpacing() {
        return 1;
    }

    @Override
    public Insets getInsets() {
        return TOOLBAR_INSETS;
    }

    protected void setVisibleClientProperty(Component c, boolean visible) {
        ((JComponent)c).putClientProperty(VISIBLE_CLIENT_PROP, visible ? Boolean.TRUE : Boolean.FALSE);
    }

    protected class ScrollableToolBarLayout
    implements LayoutManager {
        private int hgap;
        private int height;

        protected ScrollableToolBarLayout() {
            this.hgap = WmiScrollableToolBar.this.getButtonSpacing();
            this.height = 0;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            this.processLayout(parent, true);
            return new Dimension(parent.getWidth(), this.getToolBarHeight());
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            this.processLayout(parent, true);
            return new Dimension(0, this.getToolBarHeight());
        }

        @Override
        public void layoutContainer(Container parent) {
            this.processLayout(parent, true);
        }

        public int getToolBarHeight() {
            int height = 44;
            if (WmiScrollableToolBar.this.getToolBarIconSize() == 1) {
                height = 28;
            }
            return height;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processLayout(Container parent, boolean layout) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                if (WmiScrollableToolBar.this.shift < 0) {
                    WmiScrollableToolBar.this.shift = 0;
                }
                Insets insets = WmiScrollableToolBar.this.getInsets();
                int members = parent.getComponentCount() - 2;
                int maxWidth = parent.getWidth() - (insets.left + insets.right - 2 * this.hgap);
                int adjustedMaxWidth = maxWidth - parent.getComponent(members + 1).getWidth() - this.hgap;
                if (WmiScrollableToolBar.this.shift != 0) {
                    maxWidth = adjustedMaxWidth;
                }
                int x = insets.left + this.hgap;
                int y = 0;
                int i = 0;
                Component m = null;
                this.height = this.getToolBarHeight();
                if (layout) {
                    i = 0;
                    while (i < WmiScrollableToolBar.this.shift) {
                        m = parent.getComponent(i);
                        m.setVisible(false);
                        ++i;
                    }
                }
                i = WmiScrollableToolBar.this.shift;
                while (i < members) {
                    m = parent.getComponent(i);
                    Object o = ((JComponent)m).getClientProperty(VISIBLE_CLIENT_PROP);
                    if (o == Boolean.FALSE) {
                        m.setVisible(false);
                    } else {
                        Dimension d = m.getPreferredSize();
                        int threshold = (i == members - 1 ? maxWidth : adjustedMaxWidth) - this.hgap;
                        if (x + d.width >= threshold) break;
                        if (layout) {
                            m.setVisible(true);
                            m.setSize(d.width, d.height);
                            m.setLocation(x, y + (this.height - d.height) / 2);
                        }
                        x += d.width + this.hgap;
                    }
                    ++i;
                }
                if (i < members || WmiScrollableToolBar.this.shift != 0) {
                    m = parent.getComponent(members);
                    Dimension d = m.getPreferredSize();
                    x = insets.left + this.hgap + adjustedMaxWidth - d.width;
                    if (layout) {
                        m.setVisible(true);
                        m.setEnabled(i < members);
                        m.setSize(d.width, d.height);
                        m.setLocation(x, this.height / 2 - d.height);
                        m = parent.getComponent(members + 1);
                        m.setVisible(true);
                        m.setEnabled(WmiScrollableToolBar.this.shift != 0);
                        d = m.getPreferredSize();
                        m.setSize(d.width, d.height);
                        m.setLocation(x, this.height / 2);
                    }
                    x += d.width;
                } else {
                    parent.getComponent(members).setVisible(false);
                    parent.getComponent(members + 1).setVisible(false);
                }
                if (layout) {
                    while (i < members) {
                        m = parent.getComponent(i++);
                        m.setVisible(false);
                    }
                }
            }
        }
    }

    protected class Scroller
    extends MouseAdapter {
        private boolean scrollBack;

        Scroller(boolean scrollBack) {
            this.scrollBack = scrollBack;
        }

        @Override
        public void mousePressed(MouseEvent me) {
            Object source = me.getSource();
            if (source instanceof JButton && ((JButton)source).isEnabled()) {
                JButton sourceButton = (JButton)source;
                WmiScrollableToolBar.this.holdScroll = true;
                WmiScrollableToolBar.this.scrollThread = new ToolbarScrollerThread(WmiScrollableToolBar.this, sourceButton, this.scrollBack);
                WmiScrollableToolBar.this.scrollThread.setPriority(1);
                WmiScrollableToolBar.this.scrollThread.start();
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            WmiScrollableToolBar.this.holdScroll = false;
        }
    }

    private static class ToolbarScrollerThread
    extends Thread {
        WmiScrollableToolBar myToolBar = null;
        AbstractButton scrollButton = null;
        boolean direction = false;
        boolean running = true;

        public ToolbarScrollerThread(WmiScrollableToolBar theBar, AbstractButton button, boolean dir) {
            super(SCROLL_THREAD_NAME);
            this.myToolBar = theBar;
            this.scrollButton = button;
            this.direction = dir;
        }

        @Override
        public void run() {
            long lastTime = 0L;
            long delayTime = 1000L;
            while (this.running && this.myToolBar.holdScroll && this.scrollButton.isEnabled()) {
                lastTime = System.currentTimeMillis();
                this.myToolBar.scrollOnce(this.direction);
                while (this.running && lastTime + delayTime > System.currentTimeMillis() && this.myToolBar.holdScroll) {
                }
                if (1000L - (delayTime /= 4L) * 4L <= 8L) continue;
                delayTime *= 4L;
            }
        }

        public void cancel() {
            this.running = false;
        }
    }
}

