/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JPanel;

public class WmiSmartFlowLayoutContentPanel
extends JPanel {
    private static Dimension DEFAULT_PROTOTYPE_SIZE = new Dimension(5, 5);
    private boolean uniformContentItemSize;
    private Dimension prototypeSize;

    public WmiSmartFlowLayoutContentPanel(int rowPadding, int columnPadding, boolean uniformContentItemSize) {
        this(rowPadding, columnPadding, uniformContentItemSize, 1);
    }

    public WmiSmartFlowLayoutContentPanel(int rowPadding, int columnPadding, boolean uniformContentItemSize, int flowDirection) {
        this.setLayout(new BaselineFlowLayout(flowDirection, columnPadding, rowPadding));
        this.uniformContentItemSize = uniformContentItemSize;
        this.setOpaque(false);
    }

    public void setPrototypeButtonSize(Dimension d) {
        this.prototypeSize = d;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getPreferredSize() {
        Dimension d = null;
        Object object = this.getTreeLock();
        synchronized (object) {
            int hgap = 0;
            int vgap = 0;
            LayoutManager layout = this.getLayout();
            if (layout instanceof FlowLayout) {
                hgap = ((FlowLayout)layout).getHgap();
                vgap = ((FlowLayout)layout).getVgap();
            }
            d = this.uniformContentItemSize ? this.layoutUniformContentItemSize(hgap, vgap) : this.layoutVariableContentItemSize(hgap, vgap);
        }
        return d;
    }

    protected Dimension getDefaultPrototypeSize() {
        return DEFAULT_PROTOTYPE_SIZE;
    }

    protected int getContentWidth() {
        Container c = this.getParent();
        return c != null ? c.getWidth() : 0;
    }

    protected Dimension layoutUniformContentItemSize(int hgap, int vgap) {
        return this.layoutUniformContentItemSize(hgap, vgap, this.getComponentCount());
    }

    protected Dimension layoutUniformContentItemSize(int hgap, int vgap, int componentCount) {
        Dimension d;
        if (this.prototypeSize != null) {
            d = this.prototypeSize;
        } else if (this.getComponentCount() > 0) {
            Component c = this.getComponent(0);
            d = c.getPreferredSize();
        } else {
            d = this.getDefaultPrototypeSize();
        }
        int toolWidth = d.width;
        int toolHeight = d.height;
        if (toolWidth < 1) {
            toolWidth = 32;
        }
        toolWidth += hgap;
        int width = this.getContentWidth();
        if (width < 1) {
            width = 32;
        }
        int componentsPerRow = width / toolWidth;
        componentsPerRow = Math.max(componentsPerRow, 1);
        int rows = componentCount / componentsPerRow;
        if (componentCount % componentsPerRow != 0) {
            ++rows;
        }
        rows = Math.max(rows, 1);
        int height = rows * (toolHeight + vgap);
        return new Dimension(width, height);
    }

    protected Dimension layoutVariableContentItemSize(int hgap, int vgap) {
        int width = this.getContentWidth();
        int height = 0;
        int currentRowWidth = 0;
        int rowStart = 0;
        int i = 0;
        while (i < this.getComponentCount()) {
            Component c = this.getComponent(i);
            Dimension d = c.getPreferredSize();
            int compWidth = d.width;
            int compHeight = d.height + vgap;
            if (currentRowWidth + compWidth <= width) {
                if (currentRowWidth > 0) {
                    currentRowWidth += hgap;
                }
                currentRowWidth += compWidth;
            } else {
                int rowHeight = this.computeBaselineAlignment(this, rowStart, i, height, false) + vgap;
                rowStart = i;
                height += rowHeight;
                if (compWidth < width) {
                    currentRowWidth = compWidth;
                } else {
                    currentRowWidth = 0;
                    height += compHeight;
                    if (rowStart < this.getComponentCount() - 1) {
                        ++rowStart;
                    }
                }
            }
            ++i;
        }
        height += this.computeBaselineAlignment(this, rowStart, this.getComponentCount(), height, false) + vgap;
        return new Dimension(width, height);
    }

    protected int getBaseline(Component c) {
        return c.getHeight() / 2;
    }

    protected int computeBaselineAlignment(Container p, int start, int end, int y, boolean move) {
        int baseline;
        Component child;
        int maxBaseline = 0;
        int maxHeight = 0;
        int i = start;
        while (i < end) {
            child = p.getComponent(i);
            baseline = this.getBaseline(child);
            maxBaseline = Math.max(baseline, maxBaseline);
            ++i;
        }
        i = start;
        while (i < end) {
            child = p.getComponent(i);
            baseline = this.getBaseline(child);
            int alignedBaselineY = maxBaseline - baseline;
            maxHeight = Math.max(alignedBaselineY + child.getHeight(), maxHeight);
            if (move) {
                child.setLocation(child.getX(), y + alignedBaselineY);
            }
            ++i;
        }
        return maxHeight;
    }

    public void setUniformContentItemSize(boolean uniformContentItemSize) {
        this.uniformContentItemSize = uniformContentItemSize;
    }

    private class BaselineFlowLayout
    extends FlowLayout {
        public BaselineFlowLayout(int flowDirection, int columnPadding, int rowPadding) {
            super(flowDirection, columnPadding, rowPadding);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void moveComponentsWithBaseline(Container target, int x, int y, int width, int height, int rowStart, int rowEnd, boolean ltr) {
            Object object = target.getTreeLock();
            synchronized (object) {
                switch (this.getAlignment()) {
                    case 0: {
                        x += ltr ? 0 : width;
                        break;
                    }
                    case 1: {
                        x += width / 2;
                        break;
                    }
                    case 2: {
                        x += ltr ? width : 0;
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        x += width;
                    }
                }
                WmiSmartFlowLayoutContentPanel.this.computeBaselineAlignment(target, rowStart, rowEnd, y, true);
                int i = rowStart;
                while (i < rowEnd) {
                    Component m = target.getComponent(i);
                    if (m.isVisible()) {
                        int childY = m.getY();
                        if (ltr) {
                            m.setLocation(x, childY);
                        } else {
                            m.setLocation(target.getWidth() - x - m.getWidth(), childY);
                        }
                        x += m.getWidth() + this.getHgap();
                    }
                    ++i;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container target) {
            Object object = target.getTreeLock();
            synchronized (object) {
                int hgap = this.getHgap();
                int vgap = this.getVgap();
                Insets insets = target.getInsets();
                int maxwidth = target.getWidth() - (insets.left + insets.right + hgap * 2);
                int nmembers = target.getComponentCount();
                int x = 0;
                int y = insets.top + vgap;
                int rowh = 0;
                int start = 0;
                boolean ltr = target.getComponentOrientation().isLeftToRight();
                int i = 0;
                while (i < nmembers) {
                    Component m = target.getComponent(i);
                    if (m.isVisible()) {
                        Dimension d = m.getPreferredSize();
                        m.setSize(d.width, d.height);
                        if (x == 0 || x + d.width <= maxwidth) {
                            if (x > 0) {
                                x += hgap;
                            }
                            x += d.width;
                            rowh = Math.max(rowh, d.height);
                        } else {
                            this.moveComponentsWithBaseline(target, insets.left + hgap, y, maxwidth - x, rowh, start, i, ltr);
                            x = d.width;
                            y += vgap + rowh;
                            rowh = d.height;
                            start = i;
                        }
                    }
                    ++i;
                }
                this.moveComponentsWithBaseline(target, insets.left + hgap, y, maxwidth - x, rowh, start, nmembers, ltr);
            }
        }
    }
}

