/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import com.maplesoft.mathdoc.platform.WmiComponentMetrics;
import com.maplesoft.util.RuntimePlatform;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.border.MatteBorder;

public class WmiStatusBar
extends JComponent {
    public static final String LEFT = "left";
    public static final String RIGHT = "right";
    public static final int DEFAULT_HORIZONTAL_GAP = 5;

    public WmiStatusBar(int gapSize) {
        if (RuntimePlatform.isMac()) {
            MatteBorder brdr = new MatteBorder(1, 0, 0, 0, Color.GRAY);
            this.setBorder(brdr);
        }
        this.setLayout(new WmiStatusBarLayout(gapSize));
    }

    public WmiStatusBar() {
        this(5);
    }

    public class WmiStatusBarLayout
    implements LayoutManager2 {
        public static final int MINIMUM_DIMENSIONS = 0;
        public static final int MAXIMUM_DIMENSIONS = 1;
        public static final int PREFERRED_DIMENSIONS = 2;
        protected Vector leftComponents = new Vector();
        protected Vector rightComponents = new Vector();
        protected int hGapSize;

        public WmiStatusBarLayout(int gapSize) {
            this.hGapSize = gapSize;
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
            String where = (String)constraints;
            if (where.equals(WmiStatusBar.LEFT)) {
                this.leftComponents.add(comp);
            } else if (where.equals(WmiStatusBar.RIGHT)) {
                this.rightComponents.add(comp);
            }
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            this.addLayoutComponent(comp, name);
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        @Override
        public void invalidateLayout(Container target) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            if (this.leftComponents.contains(comp)) {
                this.leftComponents.remove(comp);
            }
            if (this.rightComponents.contains(comp)) {
                this.rightComponents.remove(comp);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Insets insets = parent.getInsets();
            Dimension leftDims = this.getTotalSize(this.leftComponents, 2);
            Dimension rightDims = this.getTotalSize(this.rightComponents, 2);
            int maxHeight = leftDims.height > rightDims.height ? leftDims.height : rightDims.height;
            int width = leftDims.width + rightDims.width + insets.left + insets.right;
            int height = maxHeight + insets.top + insets.bottom;
            return new Dimension(width, height);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Insets insets = parent.getInsets();
            Dimension leftDims = this.getTotalSize(this.leftComponents, 0);
            Dimension rightDims = this.getTotalSize(this.rightComponents, 0);
            int maxHeight = leftDims.height > rightDims.height ? leftDims.height : rightDims.height;
            int width = leftDims.width + rightDims.width + insets.left + insets.right;
            int height = maxHeight + insets.top + insets.bottom;
            return new Dimension(width, height);
        }

        @Override
        public Dimension maximumLayoutSize(Container parent) {
            Insets insets = parent.getInsets();
            Dimension leftDims = this.getTotalSize(this.leftComponents, 1);
            Dimension rightDims = this.getTotalSize(this.rightComponents, 1);
            int maxHeight = leftDims.height > rightDims.height ? leftDims.height : rightDims.height;
            int width = leftDims.width + rightDims.width + insets.left + insets.right;
            int height = maxHeight + insets.top + insets.bottom;
            return new Dimension(width, height);
        }

        @Override
        public void layoutContainer(Container parent) {
            this.computeLayout(parent);
        }

        private Dimension getTotalSize(Vector compList, int type) {
            int totalWidth = -this.hGapSize;
            int maxHeight = WmiComponentMetrics.STATUS_BAR_MINIMUM_HEIGHT;
            int i = 0;
            while (i < compList.size()) {
                JComponent comp = (JComponent)compList.get(i);
                if (comp != null) {
                    int height;
                    if (type == 2) {
                        totalWidth = (int)((double)totalWidth + comp.getPreferredSize().getWidth());
                        height = (int)comp.getPreferredSize().getHeight();
                    } else if (type == 0) {
                        totalWidth = (int)((double)totalWidth + comp.getMinimumSize().getWidth());
                        height = (int)comp.getMinimumSize().getHeight();
                    } else {
                        totalWidth = (int)((double)totalWidth + comp.getMaximumSize().getWidth());
                        height = (int)comp.getMaximumSize().getHeight();
                    }
                    totalWidth += this.hGapSize;
                    maxHeight = height > maxHeight ? height : maxHeight;
                }
                ++i;
            }
            totalWidth = totalWidth > 0 ? totalWidth : 0;
            return new Dimension(totalWidth, maxHeight);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void computeLayout(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                int height;
                int width;
                Dimension curDim;
                Component cur;
                Insets parentInsets = parent.getInsets();
                Dimension leftSize = this.getTotalSize(this.leftComponents, 2);
                Dimension rightSize = this.getTotalSize(this.rightComponents, 2);
                int fillNeeded = parent.getWidth() - (2 * this.hGapSize + leftSize.width + rightSize.width + parentInsets.left + parentInsets.right);
                fillNeeded = fillNeeded > 0 ? fillNeeded : 0;
                int xPos = parentInsets.left + this.hGapSize;
                int yPos = 0;
                int i = 0;
                while (i < this.leftComponents.size()) {
                    cur = (Component)this.leftComponents.get(i);
                    curDim = cur.getPreferredSize();
                    yPos = (parent.getHeight() - curDim.height) / 2 + parentInsets.top;
                    width = curDim.width;
                    if (i == this.leftComponents.size() - 1) {
                        width += fillNeeded;
                    }
                    height = curDim.height;
                    cur.setBounds(xPos, yPos, width, height);
                    cur.setVisible(true);
                    xPos += width + this.hGapSize;
                    ++i;
                }
                xPos -= this.hGapSize;
                i = 0;
                while (i < this.rightComponents.size()) {
                    cur = (Component)this.rightComponents.get(i);
                    curDim = cur.getPreferredSize();
                    yPos = (parent.getHeight() - curDim.height) / 2 + parentInsets.top;
                    width = curDim.width;
                    height = curDim.height;
                    cur.setBounds(xPos, yPos, width, height);
                    cur.setVisible(true);
                    xPos += width + this.hGapSize;
                    ++i;
                }
            }
        }
    }
}

