/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import com.maplesoft.mathdoc.controller.WmiCommand;
import com.maplesoft.mathdoc.controller.WmiCommandProxy;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.view.WmiMathDocumentView;
import java.awt.event.ComponentEvent;
import java.util.HashMap;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class WmiToolBar
extends JToolBar {
    public static final int TOOLBAR_ICONS_DEFAULT = 0;
    public static final int TOOLBAR_ICONS_SMALL = 1;
    public static final int TOOLBAR_ICONS_LARGE = 2;
    protected JPanel toolBarPnl = null;
    protected HashMap commandMap = null;
    private boolean toolBarLocked = false;
    private int toolBarIconSize;
    protected WmiMathDocumentView currentView = null;

    public WmiToolBar(int iconSize, WmiMathDocumentView docView) {
        this.currentView = docView;
        this.setToolBarIconSize(iconSize);
        this.commandMap = new HashMap();
        this.toolBarPnl = new JPanel();
        this.toolBarPnl.setOpaque(false);
        this.setFocusable(false);
    }

    public WmiToolBar(WmiMathDocumentView docView) {
        this(1, docView);
    }

    public void resizeToolBar() {
        this.toolBarPnl.invalidate();
        this.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseResources() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.toolBarPnl != null) {
                this.toolBarPnl.removeAll();
            }
            this.toolBarPnl = null;
            if (this.commandMap != null) {
                this.commandMap.clear();
            }
            this.commandMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JComboBox addComboBox(JComboBox jb) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (!this.isToolBarLocked()) {
                this.commandMap.put(jb.getName(), jb);
                this.toolBarPnl.add(jb);
            }
        }
        return jb;
    }

    @Override
    public void addSeparator() {
        this.addSeparator(10);
    }

    public void addSeparator(int width) {
        this.toolBarPnl.add(Box.createHorizontalStrut(width));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractButton addButtonTool(String name) {
        AbstractButton btn = null;
        WmiCommandProxy command = null;
        Object object = this.getTreeLock();
        synchronized (object) {
            if (!this.isToolBarLocked()) {
                if (name.equals("-")) {
                    this.addSeparator();
                } else {
                    try {
                        command = this.currentView != null ? WmiCommand.getCommandProxy(name, this.currentView) : WmiCommand.getCommandProxy(name);
                        if (command != null) {
                            int buttonSize = 2;
                            if (this.getToolBarIconSize() == 1) {
                                buttonSize = 1;
                            }
                            if ((btn = command.createButton(buttonSize, this)) != null) {
                                this.toolBarPnl.add(btn);
                                this.commandMap.put(name, btn);
                            }
                        }
                    }
                    catch (NullPointerException e) {
                        WmiErrorLog.log(e);
                    }
                }
            }
        }
        return btn;
    }

    public int getPreferredButtonIconSize() {
        return 24;
    }

    public void componentResized(ComponentEvent e) {
        this.resizeToolBar();
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public static void updateTool(AbstractButton tool, String name) {
        WmiCommandProxy command = WmiCommand.getCommandProxy(name);
        if (command != null) {
            tool.setEnabled(command.isEnabled());
            if (((WmiCommand)command).getType() == 1) {
                tool.setSelected(((WmiCommand)command).isSelected());
            }
        }
    }

    public static void updateTool(AbstractButton tool, String name, WmiMathDocumentView view) {
        WmiCommandProxy command = WmiCommand.getCommandProxy(name);
        if (command != null) {
            tool.setEnabled(((WmiCommand)command).isEnabled(view));
            if (((WmiCommand)command).getType() == 1) {
                tool.setSelected(((WmiCommand)command).isSelected(view));
            }
        }
    }

    public void updateButtonTools(WmiMathDocumentView view) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.refreshIconImages(view);
        } else {
            SwingUtilities.invokeLater(new WmiToolBarIconUpdater(view));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshIconImages(WmiMathDocumentView view) {
        Object object = this.getTreeLock();
        synchronized (object) {
            Set commandKeySet = this.commandMap.keySet();
            for (String key : commandKeySet) {
                AbstractButton aBtn;
                Object btn = this.commandMap.get(key);
                AbstractButton abstractButton = aBtn = btn instanceof AbstractButton ? (AbstractButton)btn : null;
                if (aBtn == null) continue;
                WmiToolBar.updateTool(aBtn, key, view);
            }
        }
    }

    public boolean isToolBarLocked() {
        return this.toolBarLocked;
    }

    public void setToolBarLocked(boolean toolBarLocked) {
        this.toolBarLocked = toolBarLocked;
    }

    public int getToolBarIconSize() {
        return this.toolBarIconSize;
    }

    public void setToolBarIconSize(int toolBarIconSize) {
        this.toolBarIconSize = toolBarIconSize;
    }

    protected class WmiToolBarIconUpdater
    implements Runnable {
        private WmiMathDocumentView viewToUpdate;

        protected WmiToolBarIconUpdater(WmiMathDocumentView view) {
            this.viewToUpdate = view;
        }

        @Override
        public void run() {
            WmiToolBar.this.refreshIconImages(this.viewToUpdate);
        }
    }
}

