/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import com.maplesoft.mathdoc.components.WmiComponentUtil;
import com.maplesoft.mathdoc.platform.WmiToolBarButtonUIFactory;
import com.maplesoft.util.ResourceLoader;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class WmiToolBarButton
extends JButton {
    public static final boolean JACK_TOOLBAR_BUTTON_UI = Boolean.getBoolean("jack.ui");
    private static final String ICON_DISABLED_SUFFIX = "X";
    private static final String ICON_FILE_SUFFIX = ".gif";

    public WmiToolBarButton(int size, int preferredSize, String imageName, String resPath) {
        WmiToolBarButton.installIcon(this, size, preferredSize, imageName, resPath);
        this.initializeButton();
    }

    public WmiToolBarButton(int preferredSize, String resourcePath) {
        ImageIcon icon = WmiToolBarButton.getImageIcon("", resourcePath, preferredSize);
        if (icon != null) {
            this.setIcon(icon);
        }
        this.initializeButton();
    }

    public WmiToolBarButton(Icon[] icons) {
        this.setIcon(icons[0]);
        this.setDisabledIcon(icons[1]);
        this.initializeButton();
    }

    public WmiToolBarButton() {
        this.initializeButton();
    }

    private void initializeButton() {
        this.setRequestFocusEnabled(false);
        this.setFocusPainted(false);
        this.setUI(WmiToolBarButtonUIFactory.createUI());
    }

    public static void installIcon(AbstractButton b, int size, int preferredSize, String imageName, String resPath) {
        String disabledImageResource;
        ImageIcon disabledIcon;
        String baseName = imageName;
        String enabledImageResource = WmiToolBarButton.getIconName(baseName, size, preferredSize, true);
        ImageIcon enabledIcon = WmiToolBarButton.getImageIcon(resPath, enabledImageResource, preferredSize);
        if (enabledIcon != null) {
            b.setIcon(enabledIcon);
        }
        if ((disabledIcon = WmiToolBarButton.getImageIcon(resPath, disabledImageResource = WmiToolBarButton.getIconName(baseName, size, preferredSize, false), preferredSize)) != null) {
            b.setDisabledIcon(disabledIcon);
        }
    }

    public static String getIconName(String baseName, int iconSize, int preferredSize, boolean enabled) {
        String iconName = null;
        if (baseName != null) {
            if (JACK_TOOLBAR_BUTTON_UI && preferredSize != -1) {
                baseName = String.valueOf(baseName) + 32;
            } else {
                switch (iconSize) {
                    case 1: {
                        baseName = String.valueOf(baseName) + 16;
                        break;
                    }
                    case 2: {
                        baseName = String.valueOf(baseName) + 32;
                        break;
                    }
                }
            }
            if (!enabled) {
                baseName = String.valueOf(baseName) + ICON_DISABLED_SUFFIX;
            }
            iconName = baseName = String.valueOf(baseName) + ICON_FILE_SUFFIX;
        }
        return iconName;
    }

    public static ImageIcon getImageIcon(String imagePath, String name) {
        return WmiToolBarButton.getImageIcon(imagePath, name, -1);
    }

    public static ImageIcon getImageIcon(String imagePath, String name, int preferredSize) {
        ImageIcon icon;
        String resPath = String.valueOf(imagePath) + '/' + name;
        if (JACK_TOOLBAR_BUTTON_UI && preferredSize != -1) {
            int imageSize = preferredSize;
            Image img = ResourceLoader.getResourceAsImage(resPath);
            BufferedImage buffy = new BufferedImage(imageSize, imageSize, 2);
            Graphics2D g2 = buffy.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2.drawImage(img, 0, 0, buffy.getWidth(), buffy.getHeight(), null);
            g2.dispose();
            icon = new ImageIcon(buffy);
        } else {
            icon = WmiComponentUtil.getImageIcon(resPath);
        }
        return icon;
    }
}

