/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import com.maplesoft.mathdoc.components.WmiComponent;
import com.maplesoft.mathdoc.components.WmiComponentUtil;
import com.maplesoft.mathdoc.components.WmiNumFormatDelegate;
import com.maplesoft.mathdoc.components.WmiStepperControl;
import com.maplesoft.mathdoc.components.WmiStepperTarget;
import com.maplesoft.mathdoc.components.WmiToolBarSpinTarget;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class WmiToolBarSpinControl
extends JPanel
implements WmiComponent,
WmiStepperTarget {
    public static final int DEFAULT_ICON_SIZE = 1;
    private int ctrlId = -1;
    private int ctrlSize = 0;
    private String ctrlLabel = null;
    private String ctrlIcon = null;
    private float ctrlValue = 0.0f;
    private float ctrlStepSize = 1.0f;
    private JLabel myLabel = null;
    private JTextField myTextField = null;
    private WmiStepperControl myStepper = null;
    private WmiNumFormatDelegate myFmtDelegate = null;
    private WmiEditHandler editHandler = new WmiEditHandler();
    private Vector targets = new Vector();

    public WmiToolBarSpinControl(int id, int size, String label, String icon) {
        this.ctrlId = id;
        this.ctrlSize = size;
        this.ctrlLabel = label;
        this.ctrlIcon = icon;
        this.setLayout(new BoxLayout(this, 0));
        this.add(Box.createHorizontalStrut(5));
        if (label != null || icon != null) {
            this.myLabel = new JLabel();
            if (label != null) {
                this.myLabel.setText(label);
            } else {
                ImageIcon labelIcon = WmiComponentUtil.getImageIcon(icon);
                if (labelIcon != null) {
                    this.myLabel.setIcon(labelIcon);
                }
            }
            this.add(this.myLabel);
            this.add(Box.createHorizontalStrut(5));
        }
        this.myTextField = new JTextField();
        this.myTextField.setHorizontalAlignment(0);
        this.myTextField.setPreferredSize(new Dimension(40, 20));
        this.myTextField.setMaximumSize(new Dimension(40, 20));
        this.myTextField.addActionListener(this.editHandler);
        this.add(this.myTextField);
        this.add(Box.createHorizontalStrut(5));
        this.myStepper = new WmiStepperControl(size);
        this.add(this.myStepper);
        this.add(Box.createHorizontalStrut(5));
        this.myStepper.addTarget(this);
        this.updateValueDisplay();
    }

    public WmiToolBarSpinControl(int id, int size) {
        this(id, size, null, null);
    }

    public WmiToolBarSpinControl(int id) {
        this(id, 1, null, null);
    }

    public WmiToolBarSpinControl() {
        this(-1, 1, null, null);
    }

    public void setFormatDelegate(WmiNumFormatDelegate delegate) {
        this.myFmtDelegate = delegate;
        this.updateValueDisplay();
    }

    public WmiNumFormatDelegate getFormateDelegate() {
        return this.myFmtDelegate;
    }

    public void setControlValue(float value, boolean doNotify) {
        this.ctrlValue = value;
        this.updateValueDisplay(doNotify);
    }

    public void setControlValue(float value) {
        this.setControlValue(value, false);
    }

    public float getControlValue() {
        return this.ctrlValue;
    }

    public void synchronizeValueWithDisplay() {
        try {
            float newValue = Float.parseFloat(this.myTextField.getText());
            this.setControlValue(newValue, true);
        }
        catch (NumberFormatException nfe) {
            this.setControlValue(this.ctrlValue, false);
        }
    }

    private void updateValueDisplay(boolean doNotify) {
        if (this.myFmtDelegate != null) {
            String dspString = this.myFmtDelegate.getDisplayString(this.ctrlValue);
        } else {
            String dspString = Integer.toString((int)this.ctrlValue);
        }
        this.myTextField.setText(Integer.toString((int)this.ctrlValue));
        if (doNotify) {
            this.notifyTargets(this.ctrlValue);
        }
    }

    private void updateValueDisplay() {
        this.updateValueDisplay(true);
    }

    public void addTarget(WmiToolBarSpinTarget target) {
        if (!this.targets.contains(target)) {
            this.targets.add(target);
        }
    }

    public void removeTarget(WmiToolBarSpinTarget target) {
        this.targets.remove(target);
    }

    private void notifyTargets(float value) {
        Iterator i = this.targets.iterator();
        while (i.hasNext()) {
            ((WmiToolBarSpinTarget)i.next()).valueChangeNotify(this.ctrlId, value);
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public void stepNotify(int ctrlId, int direction) {
        this.ctrlValue = direction == 1 ? (this.ctrlValue += this.ctrlStepSize) : (this.ctrlValue -= this.ctrlStepSize);
        if (this.myFmtDelegate != null) {
            this.ctrlValue = this.myFmtDelegate.rangeClamp(this.ctrlValue);
        }
        this.updateValueDisplay();
    }

    private class WmiEditHandler
    implements ActionListener {
        private WmiEditHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WmiToolBarSpinControl.this.synchronizeValueWithDisplay();
        }
    }
}

