/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components;

import com.maplesoft.mathdoc.util.WmiMutex;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class WmiUpdateScheduler
implements ActionListener {
    private static final int UPDATE_INTERVAL_THRESHOLD = 100;
    private static final long STARTUP_FUDGE = System.currentTimeMillis() + 5000L;
    private WmiMutex monitor = new WmiMutex();
    private long targetTime = Math.max(this.targetTime, STARTUP_FUDGE);
    protected Timer timer = new Timer(this.getUpdateIntervalThreshold(), this);
    private Runnable action;

    public WmiUpdateScheduler(Runnable updateAction) {
        this.timer.setRepeats(true);
        this.timer.start();
        this.action = updateAction;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean locked = false;
        try {
            try {
                locked = this.monitor.acquire(this.getUpdateIntervalThreshold() / 2);
                if (locked && System.currentTimeMillis() > this.targetTime) {
                    this.action.run();
                    this.timer.stop();
                }
            }
            catch (InterruptedException interruptedException) {
                if (locked) {
                    this.monitor.release();
                }
            }
        }
        finally {
            if (locked) {
                this.monitor.release();
            }
        }
    }

    protected int getUpdateIntervalThreshold() {
        return 100;
    }

    public void ping() {
        boolean locked = false;
        try {
            try {
                locked = this.monitor.acquire(this.getUpdateIntervalThreshold() / 2);
                if (locked) {
                    this.targetTime = Math.max(System.currentTimeMillis() + (long)this.getUpdateIntervalThreshold(), this.targetTime);
                    if (!this.timer.isRunning()) {
                        this.timer.start();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                if (locked) {
                    this.monitor.release();
                }
            }
        }
        finally {
            if (locked) {
                this.monitor.release();
            }
        }
    }
}

