/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components.dockingtools;

import com.maplesoft.mathdoc.components.WmiComponentUtil;
import com.maplesoft.mathdoc.components.dockingtools.WmiDockException;
import com.maplesoft.mathdoc.components.dockingtools.WmiDockingHost;
import com.maplesoft.mathdoc.components.dockingtools.WmiItemConfigurationError;
import com.maplesoft.mathdoc.components.dockingtools.WmiPalette;
import com.maplesoft.mathdoc.components.dockingtools.WmiPaletteContentPanel;
import com.maplesoft.mathdoc.controller.view.palettes.WmiPaletteManager;
import com.maplesoft.mathdoc.util.WmiResourcePackage;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.MissingResourceException;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

public class WmiConfigurablePalette
extends WmiPalette {
    public static final String ITEM_COUNT_PROPERTY = "items.count";
    public static final String PALETTE_TITLE_PROPERTY = "palette.title";
    public static final String PALETTE_ICON_PATH_PROPERTY = "palette.iconpath";
    public static final String PALETTE_INITIAL_EXPANDED_PROPERTY = "palette.initialexpanded";
    public static final String PALETTE_BORDER_COLOR_PROPERTY = "palette.border.color";
    public static final String PALETTE_TITLE_COLOR_PROPERTY = "palette.title.color";
    public static final String PALETTE_ICON_SIZE_PROPERTY = "palette.default.icon.size";
    public static final String PALETTE_HORIZ_TEXT_PROPERTY = "palette.item.text.position.horiz";
    public static final String PALETTE_VERT_TEXT_PROPERTY = "palette.item.text.position.vert";
    public static final String PALETTE_HIGHLIGHT_PROPERTY = "palette.item.highlight.enabled";
    public static final String PALETTE_ITEM_DEFAULT_PREFFERED_WIDTH_PROPERTY = "palette.item.preferred.width";
    public static final String PALETTE_ITEM_DEFAULT_PREFFERED_HEIGHT_PROPERTY = "palette.item.preferred.height";
    public static final String PALETTE_ITEM_DEFAULT_MAX_WIDTH_PROPERTY = "palette.item.max.width";
    public static final String PALETTE_ITEM_DEFAULT_MAX_HEIGHT_PROPERTY = "palette.item.max.height";
    public static final String PALETTE_ITEM_DEFAULT_MIN_WIDTH_PROPERTY = "palette.item.min.width";
    public static final String PALETTE_ITEM_DEFAULT_MIN_HEIGHT_PROPERTY = "palette.item.min.height";
    public static final String PALETTE_BUTTON_HIGHLIGHT_STYLE = "palette.item.highlight.style";
    public static final String PALETTE_BUTTON_UNHIGHLIGHT_STYLE = "palette.item.unhighlight.style";
    public static final String ITEM_BORDER_RAISED_VALUE = "raised";
    public static final String ITEM_BORDER_LOWERED_VALUE = "lowered";
    public static final String ITEM_BORDER_NONE_VALUE = "none";
    public static final String PALETTE_PREFERRED_ROWS_PROPERTY = "palette.rows";
    public static final String PALETTE_PREFERRED_COLS_PROPERTY = "palette.columns";
    public static final String PALETTE_ROW_PADDING = "palette.row.padding";
    public static final String PALETTE_COLUMN_PADDING = "palette.column.padding";
    public static final String PALETTE_ICON_SIZE_SMALL_VALUE = "small";
    public static final String PALETTE_ICON_SIZE_LARGE_VALUE = "large";
    public static final int MIN_ROWS = 3;
    public static final int MIN_COLS = 3;
    public static final int DEFAULT_ROW_PADDING = 2;
    public static final int DEFAULT_COLUMN_PADDING = 0;
    public static final String PALETTE_TEXT_RIGHT_VALUE = "right";
    public static final String PALETTE_TEXT_LEFT_VALUE = "left";
    public static final String PALETTE_TEXT_CENTER_VALUE = "center";
    public static final String PALETTE_TEXT_LEADING_VALUE = "leading";
    public static final String PALETTE_TEXT_TRAILING_VALUE = "trailing";
    public static final String PALETTE_TEXT_TOP_VALUE = "top";
    public static final String PALETTE_TEXT_BOTTOM_VALUE = "bottom";
    public static final String PALETTE_TEXT_NONE_VALUE = "none";
    public static final String PALETTE_FALSE_VALUE = "false";
    public static final int DEFAULT_LAYOUT_COLUMNS = 3;
    public static final int DEFAULT_LAYOUT_ROWS = 0;
    public static final int SIZE_SETTING_DISABLED = -1;
    public static final String PROPERTY_SEPARATOR = ".";
    public static final String JAR_FILE_PATH_SEPARATOR = "/";
    public static final String ITEM_TITLE_PROPERTY = "title";
    public static final String ITEM_SMALL_ICON_PROPERTY = "icon.small";
    public static final String ITEM_LARGE_ICON_PROPERTY = "icon.large";
    public static final String ITEM_TOOLTIP_PROPERTY = "tooltip";
    public static final String DEFAULT_ITEM_PREFIX = "button";
    public WmiPaletteManager paletteManager = null;
    protected String iconSize = null;
    protected String itemPrefix = "button";
    protected String iconPath = null;
    protected String textHorizPosition = "none";
    protected String textVertPosition = "none";
    protected int layoutColumns = 3;
    protected int layoutRows = 0;
    protected int rowPadding = 2;
    protected int columnPadding = 0;
    protected int paletteItemPreferredWidth = -1;
    protected int paletteItemPreferredHeight = -1;
    protected int paletteItemMaxWidth = -1;
    protected int paletteItemMaxHeight = -1;
    protected int paletteItemMinWidth = -1;
    protected int paletteItemMinHeight = -1;
    protected ActionControllerCaller actionCaller = new ActionControllerCaller();
    protected DragControllerCaller dragCaller = new DragControllerCaller();
    protected WmiDragController dragController = null;
    protected WmiActionController actionController = null;
    protected HashMap buttonToIndex = new HashMap();
    private boolean uniformContentItemSize = true;
    protected WmiResourcePackage configuration;
    protected boolean extendedPalette = false;
    private boolean isInitialized = true;

    public WmiConfigurablePalette(String resourceName, WmiPaletteManager paletteManager) {
        this(resourceName, resourceName, paletteManager);
    }

    public WmiConfigurablePalette(String resourceName, String displayName, WmiPaletteManager paletteManager) {
        super(resourceName, displayName);
        this.paletteManager = paletteManager;
        this.buildLayout();
    }

    public WmiConfigurablePalette(String resourceName, String displayName, WmiPaletteManager paletteManager, boolean extendedPalette) {
        super(resourceName, displayName);
        this.paletteManager = paletteManager;
        this.extendedPalette = extendedPalette;
        this.buildLayout();
    }

    @Override
    public void setExpanded(boolean expanded, boolean animate) {
        this.lazyInitializeIfNeeded(expanded);
        super.setExpanded(expanded, animate);
    }

    public String getShortName() {
        String resourceName = this.getResourceName();
        return resourceName.substring(resourceName.lastIndexOf(JAR_FILE_PATH_SEPARATOR) + 1);
    }

    protected void buildLayout() {
        this.configure();
    }

    protected boolean performLazyInitialize() {
        return false;
    }

    private void lazyInitializeIfNeeded(boolean expanded) {
        if (expanded && !this.isInitialized) {
            this.lazyInitialize();
        }
    }

    protected void lazyInitialize() {
        this.populateButtonPanel();
        this.getContent().doLayout();
        this.isInitialized = true;
    }

    public WmiResourcePackage getConfiguration() {
        if (this.configuration == null) {
            String resourceName = this.getResourceName();
            resourceName = String.valueOf(this.paletteManager.getPalettePath()) + resourceName;
            this.configuration = WmiResourcePackage.getResourcePackage(resourceName);
        }
        return this.configuration;
    }

    public void configure() throws WmiItemConfigurationError {
        this.getConfiguration();
        this.setTitle(this.configuration.getStringForKey(PALETTE_TITLE_PROPERTY));
        this.setIconPath(this.configuration.getStringForKey(PALETTE_ICON_PATH_PROPERTY));
        this.textHorizPosition = this.getOptionalProperty(this.configuration, PALETTE_HORIZ_TEXT_PROPERTY);
        this.textVertPosition = this.getOptionalProperty(this.configuration, PALETTE_VERT_TEXT_PROPERTY);
        this.textHorizPosition = this.textHorizPosition == null ? "none" : this.textHorizPosition;
        this.textVertPosition = this.textVertPosition == null ? "none" : this.textVertPosition;
        this.iconSize = this.getIconSize();
        this.paletteItemPreferredWidth = this.getOptionalIntegerProperty(this.configuration, PALETTE_ITEM_DEFAULT_PREFFERED_WIDTH_PROPERTY, -1);
        this.paletteItemPreferredHeight = this.getOptionalIntegerProperty(this.configuration, PALETTE_ITEM_DEFAULT_PREFFERED_HEIGHT_PROPERTY, -1);
        this.paletteItemMaxWidth = this.getOptionalIntegerProperty(this.configuration, PALETTE_ITEM_DEFAULT_MAX_WIDTH_PROPERTY, -1);
        this.paletteItemMaxHeight = this.getOptionalIntegerProperty(this.configuration, PALETTE_ITEM_DEFAULT_MAX_HEIGHT_PROPERTY, -1);
        this.paletteItemMinWidth = this.getOptionalIntegerProperty(this.configuration, PALETTE_ITEM_DEFAULT_MIN_WIDTH_PROPERTY, -1);
        this.paletteItemMinHeight = this.getOptionalIntegerProperty(this.configuration, PALETTE_ITEM_DEFAULT_MIN_HEIGHT_PROPERTY, -1);
        this.layoutRows = this.getOptionalIntegerProperty(this.configuration, PALETTE_PREFERRED_ROWS_PROPERTY, 0);
        this.layoutColumns = this.getOptionalIntegerProperty(this.configuration, PALETTE_PREFERRED_COLS_PROPERTY, 3);
        this.rowPadding = this.getOptionalIntegerProperty(this.configuration, PALETTE_ROW_PADDING, 2);
        this.columnPadding = this.getOptionalIntegerProperty(this.configuration, PALETTE_COLUMN_PADDING, 0);
        this.readColorConfiguration();
        JPanel contentPanel = this.createContentPanel();
        this.setContent(contentPanel);
        if (this.performLazyInitialize()) {
            this.isInitialized = false;
        } else {
            this.populateButtonPanel();
        }
        contentPanel.doLayout();
        String initExpand = this.getOptionalProperty(this.configuration, PALETTE_INITIAL_EXPANDED_PROPERTY);
        if (initExpand != null && initExpand.equals(PALETTE_FALSE_VALUE)) {
            this.setExpanded(false);
        }
    }

    protected JPanel createContentPanel() {
        return new WmiPaletteContentPanel(this, this.rowPadding, this.columnPadding, this.uniformContentItemSize);
    }

    protected void readColorConfiguration() {
        Color titleColor;
        Color borderColor = this.getColorProperty(PALETTE_BORDER_COLOR_PROPERTY);
        if (borderColor != null) {
            this.setForeground(borderColor);
        }
        if ((titleColor = this.getColorProperty(PALETTE_TITLE_COLOR_PROPERTY)) != null) {
            this.setTitleColor(titleColor);
        }
    }

    protected Color getColorProperty(String key) {
        String[] cc;
        Color color = null;
        String c = this.getOptionalProperty(this.configuration, key);
        if (c != null && (cc = c.split(" ")) != null && cc.length == 3) {
            int r = Integer.parseInt(cc[0]);
            int g = Integer.parseInt(cc[1]);
            int b = Integer.parseInt(cc[2]);
            color = new Color(r, g, b);
        }
        return color;
    }

    protected void populateButtonPanel() {
        int numItems = 0;
        try {
            numItems = Integer.parseInt(this.configuration.getStringForKey(ITEM_COUNT_PROPERTY));
        }
        catch (NumberFormatException nfe) {
            String resourceName = this.getResourceName();
            throw new WmiItemConfigurationError("No items for palette " + resourceName, nfe);
        }
        int i = 0;
        while (i < numItems) {
            this.addItem(this.getItemPrefix(), i, this.configuration);
            ++i;
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void setIconPath(String iconPath) {
        this.iconPath = iconPath;
        if (iconPath != null && !iconPath.endsWith(JAR_FILE_PATH_SEPARATOR)) {
            this.iconPath = String.valueOf(this.iconPath) + JAR_FILE_PATH_SEPARATOR;
        }
    }

    public String getIconSize() {
        if (this.iconSize == null) {
            this.iconSize = this.configuration.getStringForKey(PALETTE_ICON_SIZE_PROPERTY);
        }
        return this.iconSize;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public AbstractButton addItem(String prefix, int index, WmiResourcePackage config) throws WmiItemConfigurationError {
        return this.addItem(prefix, index, config, null);
    }

    public AbstractButton addItem(String name, WmiResourcePackage config) throws WmiItemConfigurationError {
        return this.addItem(name, config, null);
    }

    public AbstractButton addItem(String prefix, int index, WmiResourcePackage config, AbstractButton b) throws WmiItemConfigurationError {
        String buttonPropertyPrefix = String.valueOf(prefix) + index + PROPERTY_SEPARATOR;
        AbstractButton result = this.addItem(buttonPropertyPrefix, config, b);
        this.buttonToIndex.put(result, new Integer(index));
        return result;
    }

    public AbstractButton addItem(String name, WmiResourcePackage config, AbstractButton b) throws WmiItemConfigurationError {
        try {
            String toolTip;
            String iconname;
            AbstractButton itemButton;
            AbstractButton abstractButton = itemButton = b != null ? b : new JButton();
            if (!this.textVertPosition.equals("none") && !this.textHorizPosition.equals("none")) {
                itemButton.setText(config.getStringForKey(String.valueOf(name) + ITEM_TITLE_PROPERTY));
                int horizPosition = this.getTextPosition(this.textHorizPosition);
                int vertPosition = this.getTextPosition(this.textVertPosition);
                itemButton.setHorizontalTextPosition(horizPosition);
                itemButton.setVerticalTextPosition(vertPosition);
            }
            if (this.paletteItemPreferredWidth != -1 && this.paletteItemPreferredHeight != -1) {
                itemButton.setPreferredSize(new Dimension(this.paletteItemPreferredWidth, this.paletteItemPreferredHeight));
            }
            if (this.paletteItemMinWidth != -1 && this.paletteItemMinHeight != -1) {
                itemButton.setMinimumSize(new Dimension(this.paletteItemMinWidth, this.paletteItemMinHeight));
            }
            if (this.paletteItemMaxWidth != -1 && this.paletteItemMaxHeight != -1) {
                itemButton.setMaximumSize(new Dimension(this.paletteItemMaxWidth, this.paletteItemMaxHeight));
            }
            if (itemButton.getIcon() == null && (iconname = this.getOptionalProperty(config, name, ITEM_SMALL_ICON_PROPERTY)) != null) {
                ImageIcon sicon = WmiComponentUtil.getImageIcon(String.valueOf(this.getIconPath()) + iconname);
                iconname = config.getStringForKey(String.valueOf(name) + ITEM_LARGE_ICON_PROPERTY);
                ImageIcon licon = WmiComponentUtil.getImageIcon(String.valueOf(this.getIconPath()) + iconname);
                if (this.iconSize.equals(PALETTE_ICON_SIZE_SMALL_VALUE)) {
                    itemButton.setIcon(sicon);
                } else {
                    itemButton.setIcon(licon);
                }
            }
            if ((toolTip = this.getOptionalProperty(config, name, ITEM_TOOLTIP_PROPERTY)) != null) {
                itemButton.setToolTipText(toolTip);
            }
            itemButton.addActionListener(this.actionCaller);
            DragSource source = DragSource.getDefaultDragSource();
            source.createDefaultDragGestureRecognizer(itemButton, 1, this.dragCaller);
            this.getContent().add(itemButton);
            itemButton.setRequestFocusEnabled(false);
            itemButton.setFocusable(false);
            return itemButton;
        }
        catch (Exception e1) {
            String resourceName = this.getResourceName();
            throw new WmiItemConfigurationError("Palette " + resourceName + " Configuration Error at item " + name, e1);
        }
    }

    protected String getOptionalProperty(WmiResourcePackage config, String button, String property) {
        return this.getOptionalProperty(config, String.valueOf(button) + property);
    }

    protected String getOptionalProperty(WmiResourcePackage config, String propertyName) {
        String option = null;
        try {
            option = config.getStringForKey(propertyName);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return option;
    }

    private int getOptionalIntegerProperty(WmiResourcePackage config, String property, int defaultVal) {
        int value = defaultVal;
        try {
            value = Integer.parseInt(config.getStringForKey(property));
        }
        catch (Exception e) {
            value = defaultVal;
        }
        return value;
    }

    private int getTextPosition(String value) {
        int svalue = 0;
        if (value.equals(PALETTE_TEXT_RIGHT_VALUE)) {
            svalue = 4;
        } else if (value.equals(PALETTE_TEXT_LEFT_VALUE)) {
            svalue = 2;
        } else if (value.equals(PALETTE_TEXT_CENTER_VALUE)) {
            svalue = 0;
        } else if (value.equals(PALETTE_TEXT_LEADING_VALUE)) {
            svalue = 10;
        } else if (value.equals(PALETTE_TEXT_TRAILING_VALUE)) {
            svalue = 11;
        } else if (value.equals(PALETTE_TEXT_TOP_VALUE)) {
            svalue = 1;
        } else if (value.equals(PALETTE_TEXT_BOTTOM_VALUE)) {
            svalue = 3;
        }
        return svalue;
    }

    public String getItemPrefix() {
        return this.itemPrefix;
    }

    @Override
    public void dock(WmiDockingHost host, int location) throws WmiDockException {
        this.lazyInitializeIfNeeded(this.isExpanded());
        super.dock(host, location);
    }

    public void setDragController(WmiDragController dragController) {
        this.dragController = dragController;
    }

    public void setActionController(WmiActionController buttonAction) {
        this.actionController = buttonAction;
    }

    protected void setUniformContentItemSize(boolean uniformContentItemSize) {
        this.uniformContentItemSize = uniformContentItemSize;
        if (this.getContent() instanceof WmiPaletteContentPanel) {
            ((WmiPaletteContentPanel)this.getContent()).setUniformContentItemSize(uniformContentItemSize);
        }
    }

    protected boolean getUniformContentItemSize() {
        return this.uniformContentItemSize;
    }

    public class ActionControllerCaller
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            int calledIndex;
            Integer i = (Integer)WmiConfigurablePalette.this.buttonToIndex.get(e.getSource());
            int n = calledIndex = i != null ? i : -1;
            if (WmiConfigurablePalette.this.actionController != null) {
                WmiConfigurablePalette.this.actionController.actionPerformed(e, calledIndex);
            }
        }
    }

    public class DragControllerCaller
    implements DragGestureListener {
        @Override
        public void dragGestureRecognized(DragGestureEvent e) {
            int calledIndex = (Integer)WmiConfigurablePalette.this.buttonToIndex.get(e.getComponent());
            if (WmiConfigurablePalette.this.dragController != null) {
                WmiConfigurablePalette.this.dragController.dragGestureRecognized(e, calledIndex);
            }
        }
    }

    public static interface WmiActionController {
        public void actionPerformed(ActionEvent var1, int var2);
    }

    public static interface WmiDragController {
        public void dragGestureRecognized(DragGestureEvent var1, int var2);
    }
}

