/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components.dockingtools;

import com.maplesoft.mathdoc.components.dockingtools.WmiDockException;
import com.maplesoft.mathdoc.components.dockingtools.WmiDockable;
import com.maplesoft.mathdoc.components.dockingtools.WmiDockingHost;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JPanel;

public class WmiDockableCardButtonPane
extends JPanel
implements WmiDockable {
    public static boolean buttonHighlightEnabled = true;
    public static Color highlightedButtonColor = Color.BLUE;
    public static Color unhighlightedButtonColor = Color.BLACK;
    private static final ActionListener panelSwitcher = new WmiPanelSwitcher();
    private HashMap dockedHere = new HashMap();
    protected WmiDockableTitleButton titleButton;
    protected JPanel buttonPane;
    protected JPanel contentPane;
    protected JPanel cardPane;
    protected String title;
    protected CardLayout cardControl;
    protected JButton selectedButton = null;
    protected Object dockHost;
    private JPanel filler;
    String nowShowing = null;

    public WmiDockableCardButtonPane() {
    }

    public WmiDockableCardButtonPane(String title) {
        this.buildLayout();
        this.setTitle(title);
    }

    protected void buildLayout() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.buttonPane = new JPanel();
        this.buttonPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 0.01;
        gbc.fill = 2;
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.anchor = 11;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.titleButton = new WmiDockableTitleButton(this);
        this.buttonPane.add((Component)this.titleButton, gbc);
        gbc.weightx = 1.0;
        gbc.weighty = 0.9;
        gbc.fill = 1;
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.filler = new JPanel();
        this.buttonPane.add((Component)this.filler, gbc);
        this.titleButton.setRequestFocusEnabled(false);
        this.titleButton.setFocusable(false);
        this.titleButton.addActionListener(panelSwitcher);
        this.add((Component)this.buttonPane, "North");
        this.contentPane = new WmiContentPane(this.titleButton);
        this.cardPane = new JPanel();
        this.add((Component)this.cardPane, "Center");
        this.cardControl = new CardLayout();
        this.cardPane.setLayout(this.cardControl);
    }

    public String getNameOfTopmostPane() {
        return this.nowShowing;
    }

    public void switchTo(String panelName) {
        WmiDockableCardButtonPane pane = (WmiDockableCardButtonPane)this.dockedHere.get(panelName);
        pane = panelName.equals(this.getTitle()) ? this : pane;
        this.buttonHighlight(pane);
        this.nowShowing = panelName;
        this.cardControl.show(this.cardPane, panelName);
    }

    protected void buttonHighlight(WmiDockableCardButtonPane highlightPane) {
        if (buttonHighlightEnabled) {
            if (this.selectedButton != null) {
                this.selectedButton.setForeground(unhighlightedButtonColor);
            }
            JButton newSelectedButton = null;
            newSelectedButton = highlightPane != null ? highlightPane.getButton() : null;
            newSelectedButton = this.getTitle().equals(highlightPane.getTitle()) ? this.getButton() : newSelectedButton;
            newSelectedButton.setForeground(highlightedButtonColor);
            this.selectedButton = newSelectedButton;
        }
    }

    public static void setButtonHighlightEnabled(boolean buttonHighlightEnabled) {
        WmiDockableCardButtonPane.buttonHighlightEnabled = buttonHighlightEnabled;
    }

    public static void setButtonHighlightColor(Color highlightedButtonColor) {
        WmiDockableCardButtonPane.highlightedButtonColor = highlightedButtonColor;
    }

    public static void setButtonUnHighlightColor(Color unHighlightedButtonColor) {
        unhighlightedButtonColor = unHighlightedButtonColor;
    }

    public void addPane(WmiDockableCardButtonPane toAdd) {
        JButton button = toAdd.getButton();
        toAdd.hideButton();
        Component[] components = this.buttonPane.getComponents();
        int i = 0;
        while (i < components.length) {
            this.buttonPane.remove(components[i]);
            ++i;
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 0.01;
        gbc.fill = 2;
        gbc.ipadx = 0;
        gbc.ipady = 1;
        gbc.anchor = 11;
        gbc.gridx = 0;
        gbc.gridy = 0;
        int i2 = 0;
        while (i2 < components.length - 1) {
            this.buttonPane.add(components[i2], gbc);
            ++gbc.gridy;
            ++i2;
        }
        this.buttonPane.add((Component)button, gbc);
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        gbc.ipadx = 0;
        gbc.ipady = 0;
        this.buttonPane.add((Component)this.filler, gbc);
        this.buttonPane.revalidate();
        this.dockedHere.put(toAdd.getTitle(), toAdd);
        this.cardPane.add((Component)toAdd.getContentPane(), toAdd.getTitle());
        this.cardControl.last(this.cardPane);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        if (title == null) {
            throw new NullPointerException("Title cannot be null");
        }
        this.title = title;
        if (this.titleButton != null) {
            this.titleButton.setText(title);
            this.cardPane.add((Component)this.contentPane, title);
        }
    }

    public JButton getButton() {
        return this.titleButton;
    }

    public JPanel getContentPane() {
        return this.contentPane;
    }

    public void hideButton() {
        this.remove(this.buttonPane);
    }

    @Override
    public void dock(WmiDockingHost host) throws WmiDockException {
        this.dock(host, host.getPreferredDockLocation());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void dock(WmiDockingHost host, int location) throws WmiDockException {
        if (!host.isValidDockLocation(location)) throw new WmiDockException("Docking Host says location " + location + " is not valid.");
        if (location == 0 || location == 1) {
            this.remove(this.buttonPane);
            this.add((Component)this.buttonPane, "West");
        } else {
            this.remove(this.buttonPane);
            this.add((Component)this.buttonPane, "North");
        }
        if (host.isDockOpen(location)) {
            host.dock(this, location);
            this.buttonHighlight(this);
            this.dockHost = host;
            return;
        } else {
            WmiDockable docked = host.getDocked(location);
            if (!(docked instanceof WmiDockableCardButtonPane)) throw new WmiDockException("DockableCardButtonPane can only dock in open dock, or in a dock occupied by another DockableCardButtonPane");
            ((WmiDockableCardButtonPane)docked).addPane(this);
            ((WmiDockableCardButtonPane)docked).dockedHere.put(this.getTitle(), this);
            ((WmiDockableCardButtonPane)docked).switchTo(this.getTitle());
            this.dockHost = docked;
        }
    }

    @Override
    public void undock(WmiDockingHost host) {
        if (host.isDocked(this)) {
            if (this.dockHost instanceof WmiDockingHost) {
                if (this.dockedHere.size() == 0) {
                    host.undock(this);
                } else {
                    int location = host.getWhereDocked(this);
                    Iterator hosted = this.dockedHere.values().iterator();
                    WmiDockableCardButtonPane newRoot = this.removeHosted(this, (WmiDockableCardButtonPane)hosted.next());
                    hosted.remove();
                    host.undock(this);
                    try {
                        newRoot.dock(host, location);
                        this.buttonHighlight(newRoot);
                    }
                    catch (WmiDockException de) {
                        de.printStackTrace();
                    }
                    while (hosted.hasNext()) {
                        WmiDockableCardButtonPane nextDock = this.removeHosted(this, (WmiDockableCardButtonPane)hosted.next());
                        hosted.remove();
                        try {
                            nextDock.dock(host, location);
                        }
                        catch (WmiDockException de) {
                            de.printStackTrace();
                        }
                    }
                }
            } else if (this.dockHost instanceof WmiDockableCardButtonPane) {
                WmiDockableCardButtonPane myHost = (WmiDockableCardButtonPane)this.dockHost;
                this.removeHosted(myHost, this);
                myHost.dockedHere.remove(this.getTitle());
            }
        }
        this.dockHost = null;
    }

    public Iterator removeHosted() {
        Iterator palIt = null;
        ArrayList<WmiDockableCardButtonPane> palList = new ArrayList<WmiDockableCardButtonPane>();
        for (WmiDockableCardButtonPane pane : this.dockedHere.values()) {
            palList.add(this.removeHosted(this, pane));
        }
        palIt = palList.iterator();
        return palIt;
    }

    public void clearHosted() {
        this.dockedHere.clear();
    }

    public WmiDockableCardButtonPane removeHosted(WmiDockableCardButtonPane host, WmiDockableCardButtonPane target) {
        host.cardPane.remove(target.getContentPane());
        host.buttonPane.remove(target.getButton());
        host.switchTo(host.getTitle());
        target.buildLayout();
        return target;
    }

    @Override
    public Component getDockableComponent() {
        return this;
    }

    @Override
    public boolean canStack() {
        return true;
    }

    @Override
    public boolean contains(WmiDockable dockable) {
        return this.dockedHere.containsValue(dockable);
    }

    public void removeHostedRecord(WmiDockableCardButtonPane hosted) {
        this.dockedHere.remove(hosted.getTitle());
    }

    public static class WmiContentPane
    extends JPanel {
        private JButton titleButton;

        public WmiContentPane(JButton titleButton) {
            this.titleButton = titleButton;
        }

        public JButton getButton() {
            return this.titleButton;
        }
    }

    public static class WmiDockableTitleButton
    extends JButton {
        private WmiDockable ownerPanel;

        public WmiDockableTitleButton(WmiDockable owner) {
            this.ownerPanel = owner;
        }

        public WmiDockable getDockable() {
            return this.ownerPanel;
        }
    }

    public static class WmiPanelSwitcher
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            JButton button;
            Container parent = button = (JButton)e.getSource();
            while (!(parent instanceof WmiDockableCardButtonPane)) {
                parent = parent.getParent();
            }
            ((WmiDockableCardButtonPane)parent).switchTo(button.getText());
        }
    }
}

