/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components.palettes;

import com.maplesoft.mathdoc.components.dockingtools.WmiConfigurablePalette;
import com.maplesoft.mathdoc.components.dockingtools.WmiItemConfigurationError;
import com.maplesoft.mathdoc.components.palettes.WmiMathMLContentInsertionController;
import com.maplesoft.mathdoc.components.palettes.WmiMathMLEditorPalette;
import com.maplesoft.mathdoc.controller.view.palettes.WmiPaletteManager;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.util.WmiResourcePackage;
import com.maplesoft.util.WmiMathEntityNameMapper;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;

public class WmiMathMLEditorEntityInsertPalette
extends WmiMathMLEditorPalette {
    private static final String ENTITY_TAG_KEY = "entity.type";
    private static final String IDENTIFIER_TAG_VALUE = "identifier";
    private static final String NUMERIC_TAG_VALUE = "numeric";
    private static final String OPERATOR_TAG_VALUE = "operator";
    private static final String STRING_TAG_VALUE = "text";
    private Map insert2DMath;
    private WmiModelTag tag;

    public WmiMathMLEditorEntityInsertPalette(String resourceName, WmiPaletteManager paletteManager, boolean extendedPalette) {
        super(resourceName, paletteManager, extendedPalette);
        this.setActionController(new InsertAction());
    }

    public WmiMathMLEditorEntityInsertPalette(String resourceName, String displayName, WmiPaletteManager paletteManager, boolean extendedPalette) {
        super(resourceName, displayName, paletteManager, extendedPalette);
        this.setActionController(new InsertAction());
    }

    @Override
    protected boolean performLazyInitialize() {
        return false;
    }

    @Override
    public void configure() throws WmiItemConfigurationError {
        super.configure();
        WmiResourcePackage config = this.getConfiguration();
        this.tag = null;
        String tagType = config.getStringForKey(ENTITY_TAG_KEY);
        if (tagType != null) {
            if ((tagType = tagType.trim()).equals(IDENTIFIER_TAG_VALUE)) {
                this.tag = WmiModelTag.MATH_IDENTIFIER;
            } else if (tagType.equals(NUMERIC_TAG_VALUE)) {
                this.tag = WmiModelTag.MATH_NUMERIC;
            } else if (tagType.equals(OPERATOR_TAG_VALUE)) {
                this.tag = WmiModelTag.MATH_OPERATOR;
            } else if (tagType.equals(STRING_TAG_VALUE)) {
                this.tag = WmiModelTag.MATH_TEXT;
            }
        }
        if (this.tag == null) {
            throw new WmiItemConfigurationError("Error configuring " + this.getResourceName() + " palette: invalid or missing tag type \"" + tagType + "\"", null);
        }
    }

    @Override
    public AbstractButton addItem(String name, WmiResourcePackage config, AbstractButton b) throws WmiItemConfigurationError {
        if (this.insert2DMath == null) {
            this.insert2DMath = new HashMap();
        }
        AbstractButton item = null;
        if (b == null) {
            String insert2d = this.getOptionalProperty(config, name, ".insert.2dmath");
            if (insert2d != null) {
                this.insert2DMath.put(name, insert2d);
            } else {
                this.insert2DMath.put(name, name);
            }
            char c = WmiMathEntityNameMapper.getUnicodeCharacter(name);
            item = buttonFactory.createButton(c);
        } else {
            item = b;
        }
        item = super.addItem(name, config, item);
        return item;
    }

    private class InsertAction
    implements WmiConfigurablePalette.WmiActionController {
        private InsertAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e, int buttonIndex) {
            Component source = (Component)e.getSource();
            String name = (String)WmiMathMLEditorEntityInsertPalette.this.indexToNameList.get(buttonIndex);
            String twoDMath = (String)WmiMathMLEditorEntityInsertPalette.this.insert2DMath.get(name);
            WmiMathMLContentInsertionController.insertPaletteContent(source, twoDMath, WmiMathMLEditorEntityInsertPalette.this.tag);
            if (WmiMathMLEditorEntityInsertPalette.this.menu != null) {
                WmiMathMLEditorEntityInsertPalette.this.menu.hide();
            }
        }
    }
}

