/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components.palettes;

import com.maplesoft.mathdoc.components.WmiComponentUtil;
import com.maplesoft.mathdoc.components.WmiMathMLEditorButtonMenu;
import com.maplesoft.mathdoc.components.dockingtools.WmiConfigurablePalette;
import com.maplesoft.mathdoc.components.dockingtools.WmiItemConfigurationError;
import com.maplesoft.mathdoc.components.dockingtools.WmiPalette;
import com.maplesoft.mathdoc.components.dockingtools.WmiPaletteButtonFactory;
import com.maplesoft.mathdoc.components.dockingtools.WmiPaletteContentPanel;
import com.maplesoft.mathdoc.components.palettes.WmiMathMLContentInsertionController;
import com.maplesoft.mathdoc.components.palettes.WmiMathMLEditorPaletteManager;
import com.maplesoft.mathdoc.controller.view.palettes.WmiPaletteButtonDnDManager;
import com.maplesoft.mathdoc.controller.view.palettes.WmiPaletteManager;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorDictionary;
import com.maplesoft.mathdoc.util.WmiResourcePackage;
import com.maplesoft.util.WmiMathEntityNameMapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.dnd.DragGestureEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class WmiMathMLEditorPalette
extends WmiConfigurablePalette {
    public static final String PALETTE_BUTTON_LIST_PROPERTY = "buttons";
    public static final String EXTENDED_BUTTON_LIST_PROPERTY = "extended";
    public static final String PALETTE_INSERT_2D_MATH_PROPERTY = ".insert.2dmath";
    public static final String PALETTE_PREFERRED_WIDTH_PROPERTY = "palette.preferred.width";
    public static final String PALETTE_PREFERRED_HEIGHT_PROPERTY = "palette.preferred.height";
    public static final String PALETTE_PREFERRED_EXTENDED_WIDTH_PROPERTY = "palette.preferred.extended.width";
    public static final String PALETTE_PREFERRED_EXTENDED_HEIGHT_PROPERTY = "palette.preferred.extended.height";
    public static final int DEFAULT_WIDTH = 200;
    public static final int DEFAULT_HEIGHT = 200;
    protected List indexToNameList;
    protected List indexToExtendedNameList;
    protected ArrayList insert2DMathList;
    protected ArrayList originalNameList;
    protected ArrayList tooltipList;
    protected static WmiPaletteButtonFactory buttonFactory = null;
    protected WmiMathMLEditorButtonMenu menu;
    private boolean lazyInitialize = true;
    protected int paletteWidth;
    protected int paletteHeight;
    private int columns = 0;
    private int columnCount = 1;
    private int rowHeight = 0;
    private int rowWidth = 0;
    private int maxRowWidth = 0;

    static {
        buttonFactory = new WmiPaletteButtonFactory(new WmiPaletteButtonDnDManager());
    }

    public WmiMathMLEditorPalette(String resourceName, WmiPaletteManager paletteManager, boolean extendedPalette) {
        this(resourceName, "", paletteManager, extendedPalette);
    }

    public WmiMathMLEditorPalette(String resourceName, WmiPaletteManager paletteManager) {
        this(resourceName, "", paletteManager, false);
        this.paletteWidth = 0;
        this.paletteHeight = 0;
        this.lazyInitialize = true;
    }

    public void setColumnCount(int columns) {
        this.columns = columns;
    }

    public WmiMathMLEditorPalette(String resourceName, String displayName, WmiPaletteManager paletteManager, boolean extendedPalette) {
        super(resourceName, displayName, paletteManager, extendedPalette);
        if (this.insert2DMathList == null) {
            this.insert2DMathList = new ArrayList();
        }
        this.originalNameList = new ArrayList();
        this.tooltipList = new ArrayList();
        this.setDragController(new DragController());
        if (extendedPalette) {
            try {
                if (this.configuration.getStringForKey(PALETTE_PREFERRED_EXTENDED_WIDTH_PROPERTY) != null) {
                    this.paletteWidth = Integer.parseInt(this.configuration.getStringForKey(PALETTE_PREFERRED_EXTENDED_WIDTH_PROPERTY));
                }
                if (this.configuration.getStringForKey(PALETTE_PREFERRED_EXTENDED_HEIGHT_PROPERTY) != null) {
                    this.paletteHeight = Integer.parseInt(this.configuration.getStringForKey(PALETTE_PREFERRED_EXTENDED_HEIGHT_PROPERTY));
                }
            }
            catch (Exception e) {
                this.paletteWidth = 200;
                this.paletteHeight = 200;
            }
        }
        if (this.paletteWidth == 0 || this.paletteHeight == 0) {
            try {
                this.paletteWidth = Integer.parseInt(this.configuration.getStringForKey(PALETTE_PREFERRED_WIDTH_PROPERTY));
                this.paletteHeight = Integer.parseInt(this.configuration.getStringForKey(PALETTE_PREFERRED_HEIGHT_PROPERTY));
            }
            catch (Exception e) {
                this.paletteWidth = 200;
                this.paletteHeight = 200;
            }
        }
        this.setActionController(new InsertAction());
    }

    public WmiMathMLEditorPaletteManager getPaletteManager() {
        return (WmiMathMLEditorPaletteManager)this.paletteManager;
    }

    public WmiPaletteButtonFactory getButtonFactory() {
        return buttonFactory;
    }

    public ArrayList getInsert2DMathList() {
        return this.insert2DMathList;
    }

    public ArrayList getOriginalNameList() {
        return this.originalNameList;
    }

    public ArrayList getTooltipList() {
        return this.tooltipList;
    }

    public HashMap getButtonToIndex() {
        return this.buttonToIndex;
    }

    public void setMenu(WmiMathMLEditorButtonMenu menu) {
        this.menu = menu;
    }

    @Override
    protected void populateButtonPanel() {
        String buttonList;
        WmiResourcePackage config = this.getConfiguration();
        String extendedButtonList = config.getStringForKey(EXTENDED_BUTTON_LIST_PROPERTY);
        this.indexToExtendedNameList = new ArrayList();
        if (extendedButtonList != null) {
            String[] extendedButtons = extendedButtonList.split("\\s+");
            int i = 0;
            while (i < extendedButtons.length) {
                this.indexToExtendedNameList.add(extendedButtons[i]);
                ++i;
            }
        }
        if ((buttonList = config.getStringForKey(PALETTE_BUTTON_LIST_PROPERTY)) != null) {
            String[] buttons = buttonList.split("\\s+");
            this.indexToNameList = new ArrayList();
            int counter = 0;
            int i = 0;
            while (i < buttons.length) {
                if (this.extendedPalette || !this.indexToExtendedNameList.contains(buttons[i])) {
                    AbstractButton b = this.addItem(buttons[i], config);
                    this.indexToNameList.add(buttons[i]);
                    this.buttonToIndex.put(b, new Integer(counter));
                    ++counter;
                }
                ++i;
            }
            if (this.indexToNameList == null || this.indexToNameList.size() == 0) {
                throw new WmiItemConfigurationError("Error populating " + this.getResourceName() + " palette: empty button list", null);
            }
        } else {
            super.populateButtonPanel();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.paletteWidth, this.paletteHeight);
    }

    public void configureSize(int columns, int buttonCount) {
        if (this.rowWidth > this.maxRowWidth) {
            this.maxRowWidth = this.rowWidth;
        }
        this.paletteWidth = this.maxRowWidth + 4;
        this.paletteHeight = this.paletteHeight + this.rowHeight + 8;
    }

    @Override
    public void configurePanel() {
        this.setUI(WmiPalette.PaletteGroupPanelUI.getInstance());
        this.setBorder(null);
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
    }

    public AbstractButton addItem(String name, WmiResourcePackage config, int index, String tooltip) throws WmiItemConfigurationError {
        AbstractButton button = null;
        try {
            String twoDMathInsertProperty = config.getStringForKey(String.valueOf(name) + PALETTE_INSERT_2D_MATH_PROPERTY);
            String iconName = this.menu.getIconNameForKey(name);
            if (twoDMathInsertProperty != null) {
                this.insert2DMathList.add(twoDMathInsertProperty);
                String noPercents = twoDMathInsertProperty.replaceAll("%", "");
                button = buttonFactory.createButton(noPercents);
                if (iconName != null) {
                    ImageIcon icon = WmiComponentUtil.getImageIcon(String.valueOf(this.menu.getImageResourcePath()) + iconName);
                    button.setIcon(icon);
                }
            } else if (WmiMathEntityNameMapper.getUnicodeCharacter(name) != '\u0000') {
                String mathml = WmiMathOperatorDictionary.isNameForOperator("&" + name + ";") ? "<mrow><mo>&" + name + ";" + "</mo></mrow>" : "<mrow><mi>&" + name + ";" + "</mi></mrow>";
                this.insert2DMathList.add(mathml);
                button = buttonFactory.createButton(WmiMathEntityNameMapper.getUnicodeCharacter(name));
            } else {
                String mathml = "";
                mathml = WmiMathOperatorDictionary.isNameForOperator(name) ? "<mrow><mo>" + name + "</mo></mrow>" : "<mrow><mi>" + name + "</mi></mrow>";
                this.insert2DMathList.add(mathml);
                button = name.length() == 1 ? buttonFactory.createButton(name.charAt(0)) : buttonFactory.createButton(mathml);
            }
            this.buttonToIndex.put(button, new Integer(index));
            this.originalNameList.add(name);
            this.tooltipList.add(tooltip);
        }
        catch (Exception e1) {
            throw new WmiItemConfigurationError(String.valueOf(this.getResourceName()) + " WmiExpressionPalette item " + name + " needs insert property", e1);
        }
        if (this.columns > 0) {
            if (this.columnCount > this.columns) {
                if (this.rowWidth > this.maxRowWidth) {
                    this.maxRowWidth = this.rowWidth;
                }
                this.paletteHeight = this.paletteHeight + this.rowHeight + 4;
                this.columnCount = 1;
                this.rowWidth = 0;
                this.rowHeight = 0;
            }
            Dimension buttonSize = button.getPreferredSize();
            this.rowWidth = this.rowWidth + (int)buttonSize.getWidth() + 2;
            if (buttonSize.getHeight() > (double)this.rowHeight) {
                this.rowHeight = (int)buttonSize.getHeight();
            }
            ++this.columnCount;
        }
        button.setToolTipText(tooltip);
        super.addItem(name, config, button);
        return button;
    }

    public void addItem(WmiMathMLEditorButtonMenu palette) {
        this.getContent().add(palette);
    }

    public AbstractButton addMenuButton(String name, WmiResourcePackage config, int index, WmiMathMLEditorButtonMenu menu) throws WmiItemConfigurationError {
        return null;
    }

    @Override
    protected JPanel createContentPanel() {
        return new MathMLPaletteContentPanel(this, this.rowPadding, this.columnPadding, this.getUniformContentItemSize());
    }

    @Override
    protected boolean performLazyInitialize() {
        return true;
    }

    private class DragController
    implements WmiConfigurablePalette.WmiDragController {
        private DragController() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent e, int itemIndex) {
            if (WmiMathMLEditorPalette.this.menu != null) {
                WmiMathMLEditorPalette.this.menu.hide();
            }
        }
    }

    public class InsertAction
    implements WmiConfigurablePalette.WmiActionController {
        @Override
        public void actionPerformed(ActionEvent e, int buttonIndex) {
            Component source = (Component)e.getSource();
            String twoDMath = (String)WmiMathMLEditorPalette.this.insert2DMathList.get(buttonIndex);
            if (twoDMath.indexOf("matnm") != -1) {
                twoDMath = this.getMatrix2DMath();
            }
            WmiMathMLContentInsertionController.insertPaletteContent(source, twoDMath);
            if (WmiMathMLEditorPalette.this.menu != null) {
                WmiMathMLEditorPalette.this.menu.hide();
            }
        }

        String getMatrix2DMath() {
            int result;
            String twoDMath = "";
            JDialog frame = new JDialog();
            MyQueryComponent myQueryComp = new MyQueryComponent();
            Object[] options = new Object[]{"Ok", "Cancel"};
            ImageIcon okIcon = this.createImageIcon("resources/okIcon.PNG", "Ok");
            ImageIcon cancelIcon = this.createImageIcon("resources/cancelIcon.PNG", "Cancel");
            if (okIcon != null && cancelIcon != null) {
                options[0] = okIcon;
                options[1] = cancelIcon;
            }
            if ((result = JOptionPane.showOptionDialog(frame, myQueryComp.getComponent(), null, 0, -1, null, options, null)) == 0) {
                twoDMath = myQueryComp.getMatrixMathML();
            }
            return twoDMath;
        }

        protected ImageIcon createImageIcon(String path, String description) {
            URL imgURL = this.getClass().getResource(path);
            if (imgURL != null) {
                return new ImageIcon(imgURL, description);
            }
            System.err.println("Couldn't find file: " + path);
            return null;
        }

        private class MyQueryComponent {
            private JPanel mainPanel = new JPanel();
            private String[] lengths = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9"};
            private JComboBox rowsMenu = new JComboBox<String>(this.lengths);
            private JComboBox colsMenu = new JComboBox<String>(this.lengths);

            private MyQueryComponent() {
                this.rowsMenu.setSelectedItem("2");
                this.colsMenu.setSelectedItem("2");
                this.mainPanel.setLayout(new FlowLayout());
                this.mainPanel.add(this.rowsMenu);
                this.mainPanel.add(new JLabel("   x   "));
                this.mainPanel.add(this.colsMenu);
            }

            public int getRows() {
                return Integer.parseInt((String)this.rowsMenu.getSelectedItem());
            }

            public int getCols() {
                return Integer.parseInt((String)this.colsMenu.getSelectedItem());
            }

            public String getMatrixMathML() {
                int rows = this.getRows();
                int cols = this.getCols();
                StringBuffer mml = new StringBuffer();
                mml.append("<mrow> <mfenced open=\"[\" close=\"]\" stretchy=\"true\"> <mtable> ");
                int i = 1;
                while (i <= rows) {
                    mml.append("<mtr> ");
                    int j = 1;
                    while (j <= cols) {
                        mml.append("<mtd> <maction actiontype=\"maplesoft:selection-placeholder\"> <mi mathcolor='blue'>");
                        mml.append("z");
                        mml.append("</mi> </maction> </mtd> ");
                        ++j;
                    }
                    mml.append("</mtr> ");
                    ++i;
                }
                mml.append("</mtable> </mfenced> </mrow>");
                return mml.toString();
            }

            public JComponent getComponent() {
                return this.mainPanel;
            }
        }
    }

    public class MathMLActionControllerCaller
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            int calledIndex;
            Integer i = (Integer)WmiMathMLEditorPalette.this.buttonToIndex.get(e.getSource());
            int n = calledIndex = i != null ? i : -1;
            if (WmiMathMLEditorPalette.this.actionController != null) {
                WmiMathMLEditorPalette.this.actionController.actionPerformed(e, calledIndex);
            }
        }

        public boolean handlesButton(AbstractButton button) {
            return WmiMathMLEditorPalette.this.buttonToIndex.containsKey(button);
        }
    }

    protected class MathMLPaletteContentPanel
    extends WmiPaletteContentPanel {
        public MathMLPaletteContentPanel(WmiPalette palette, int rowPadding, int columnPadding, boolean uniformContentItemSize) {
            super(palette, rowPadding, columnPadding, uniformContentItemSize);
            this.setBorder(BorderFactory.createBevelBorder(0));
        }
    }
}

