/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.components.palettes;

import com.maplesoft.mathdoc.components.dockingtools.WmiConfigurablePalette;
import com.maplesoft.mathdoc.components.dockingtools.WmiDockingHost;
import com.maplesoft.mathdoc.components.palettes.WmiMathMLEditorEntityInsertPalette;
import com.maplesoft.mathdoc.components.palettes.WmiMathMLEditorExpressionPalette;
import com.maplesoft.mathdoc.components.palettes.WmiMathMLEditorPalette;
import com.maplesoft.mathdoc.controller.view.palettes.WmiPaletteManager;
import com.maplesoft.mathdoc.view.WmiMathMLEditorDocumentView;
import java.util.HashMap;

public class WmiMathMLEditorPaletteManager
extends WmiPaletteManager {
    public static final String PALETTE_MANIFEST_PATH = "com/maplesoft/mathdoc/components/resources/palette/palette-manifest";
    public static final String PALETTE_ERRORMES_PATH = "com/maplesoft/mathdoc/components/resources/palette/palette-errors";
    HashMap nameToPalettes = new HashMap();
    private WmiMathMLEditorDocumentView documentView;
    private boolean extendedPalette = false;

    public WmiMathMLEditorPaletteManager(boolean extendedPalette) {
        super(PALETTE_MANIFEST_PATH, PALETTE_ERRORMES_PATH);
        this.extendedPalette = extendedPalette;
    }

    public void setView(WmiMathMLEditorDocumentView documentView) {
        this.documentView = documentView;
    }

    public WmiMathMLEditorDocumentView getView() {
        return this.documentView;
    }

    @Override
    public WmiConfigurablePalette createPalette(String paletteName, WmiDockingHost host) {
        String fullName = String.valueOf(this.getPalettePath()) + paletteName;
        WmiMathMLEditorPalette palette = null;
        if (this.paletteMapForHost.containsKey(host)) {
            this.nameToPalettes = (HashMap)this.paletteMapForHost.get(host);
        } else {
            this.paletteMapForHost.put(host, this.nameToPalettes);
        }
        if (this.nameToPalettes.containsKey(fullName)) {
            palette = (WmiMathMLEditorPalette)this.nameToPalettes.get(fullName);
        } else {
            if (paletteName.equals("Layout") || paletteName.equals("Fences") || paletteName.equals("Trigonometry") || paletteName.equals("Calculus")) {
                palette = new WmiMathMLEditorExpressionPalette(paletteName, fullName, this, this.extendedPalette);
            } else if (paletteName.equals("Operators") || paletteName.equals("Relational") || paletteName.equals("Sets") || paletteName.equals("Logic") || paletteName.equals("LowerGreek") || paletteName.equals("UpperGreek")) {
                palette = new WmiMathMLEditorEntityInsertPalette(paletteName, fullName, this, this.extendedPalette);
            }
            this.nameToPalettes.put(fullName, palette);
            this.paletteToName.put(palette, paletteName);
        }
        return palette;
    }

    public WmiConfigurablePalette createEmptyPalette(String paletteName) {
        String fullName = String.valueOf(this.getPalettePath()) + paletteName;
        WmiMathMLEditorPalette palette = null;
        palette = new WmiMathMLEditorPalette(paletteName, this);
        this.nameToPalettes.put(fullName, palette);
        this.paletteToName.put(palette, paletteName);
        return palette;
    }

    public WmiMathMLEditorPalette getPaletteByName(String name) {
        return (WmiMathMLEditorPalette)this.nameToPalettes.get(String.valueOf(this.getPalettePath()) + name);
    }
}

